﻿
StiMobileDesigner.prototype.InfographicsMenu = function () {
    var menu = this.BaseMenu("infographicsMenu", this.options.buttons.insertInfographics, "Down");

    var header = document.createElement("div");
    header.innerHTML = this.loc.Report.Infographics;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var categories = this.GetAddSeriesItems();
    categories.push(this.Item("StiGauge", this.loc.Components.StiGauge, "Gauge.StiGauge.png", "StiGauge"));
    
    var countInRow = 0;

    for (var i = 0; i < categories.length; i++) {
        var categoryButton = this.ComponentButton("Infographic" + categories[i].name, categories[i].caption, categories[i].imageName, "ComponentButton", null, true);
        categoryButton.categoryName = categories[i].name;
        categoryButton.onmousedown = null;
        categoryButton.ontouchstart = null;
                
        categoryButton.action = function () {
            var subMenu = this.jsObject.InfographicsSubMenu(this);
            subMenu.changeVisibleState(true);
        }

        countInRow++;
        innerTable.addCellInLastRow(categoryButton);
        if (countInRow == 6) {
            innerTable.addRow();
            countInRow = 0;
        }
    }

    menu.onshow = function () {
        if (this.jsObject.options.buttons["InfographicStiGauge"])
            this.jsObject.options.buttons["InfographicStiGauge"].setEnabled(false);
    }

    return menu;
}

StiMobileDesigner.prototype.InfographicsSubMenu = function (parentButton) {
    var menu = this.BaseMenu("componentsSubMenu", parentButton, "Down");
    menu.type = "HorMenu";

    var header = document.createElement("div");
    if (parentButton.caption) header.innerHTML = parentButton.caption.innerHTML;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var items = null;
    var itemType = "";

    switch (parentButton.categoryName) {
        case "ClusteredColumn": items = this.GetChartClusteredColumnItems(); itemType = "StiChart"; break;
        case "Line": items = this.GetChartLineItems(); itemType = "StiChart"; break;
        case "Area": items = this.GetChartAreaItems(); itemType = "StiChart"; break;
        case "Range": items = this.GetChartRangeItems(); itemName = "StiChart"; break;
        case "ClusteredBar": items = this.GetChartClusteredBarItems(); itemType = "StiChart"; break;
        case "Scatter": items = this.GetChartScatterItems(); itemType = "StiChart"; break;
        case "Pie": items = this.GetChartPieItems(); itemType = "StiChart"; break;
        case "Radar": items = this.GetChartRadarItems(); itemType = "StiChart"; break;
        case "Funnel": items = this.GetChartFunnelItems(); itemType = "StiChart"; break;
        case "Financial": items = this.GetChartFinancialItems(); itemType = "StiChart"; break;
        case "Others": items = this.GetChartOthersItems(); itemType = "StiChart"; break;
        case "StiGauge": items = this.GetGaugeTypeItems(); itemType = "StiGauge"; break;
    }

    var countInRow = 0;
    if (!items) return menu;

    for (var i = 0; i < items.length; i++) {
        if (items[i] == "separator") continue;

        var infographicsButton = this.ComponentButton("Infographic;" + itemType + ";" + items[i].name, items[i].caption, items[i].imageName, "ComponentButton");
        infographicsButton.onmousedown = null;
        infographicsButton.ontouchstart = null;
        infographicsButton.menu = menu;

        infographicsButton.action = function () {
            if (this.menu) this.menu.changeVisibleState(false);
            if (this.jsObject.options.currentMenu) {
                var parentButton = this.jsObject.options.currentMenu.parentButton;
                this.jsObject.options.currentMenu.changeVisibleState(false);
                parentButton.setSelected(true);
            }
            else if (this.jsObject.options.insertPanel) {
                this.jsObject.options.insertPanel.resetChoose();
            }
            this.setSelected(!this.isSelected);
            this.jsObject.options.drawComponent = this.isSelected;
            this.jsObject.options.paintPanel.setCopyStyleMode(false);
            this.jsObject.options.paintPanel.changeCursorType(this.isSelected);
            if (this.jsObject.options.insertPanel) this.jsObject.options.insertPanel.selectedComponent = this.isSelected ? this : null;
        }

        countInRow++;
        innerTable.addCellInLastRow(infographicsButton);
        if (countInRow == 4) {
            innerTable.addRow();
            countInRow = 0;
        }
    }

    menu.ontouchstart = function (mouseProcess) {
        var this_ = this;
        this.isTouchStartFlag = mouseProcess ? false : true;
        clearTimeout(this.isTouchStartTimer);
        this.jsObject.options.horMenuPressed = this;
        this.isTouchStartTimer = setTimeout(function () {
            this_.isTouchStartFlag = false;
        }, 1000);
    }

    return menu;
}