﻿
StiMobileDesigner.prototype.InitializePreviewPanel = function () {
    var previewPanel = this.ChildWorkPanel("previewPanel", "stiDesignerPreviewPanel");
    previewPanel.style.display = "none";

    var viewerContainer = document.createElement("div");
    this.options.viewerContainer = viewerContainer;
    this.options.mainPanel.appendChild(viewerContainer);
    viewerContainer.style.position = "absolute";
    viewerContainer.style.background = "#ffffff";
    viewerContainer.style.zIndex = "30";
    viewerContainer.style.display = "none";
    viewerContainer.visible = false;
    viewerContainer.style.bottom = "0px";
    viewerContainer.style.right = "0px";
    viewerContainer.style.left = "0px";
    viewerContainer.style.top = this.options.toolBar.offsetHeight + "px";

    viewerContainer.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
    }

    if (this.options.cloudMode) {
        viewerContainer.frame = document.createElement("iframe");
        viewerContainer.appendChild(viewerContainer.frame);
        viewerContainer.frame.style.position = "absolute";
        viewerContainer.frame.style.width = "100%";
        viewerContainer.frame.style.height = "100%";
        viewerContainer.frame.style.border = "0px";
    }

    previewPanel.mainTable = this.CreateHTMLTable();
    previewPanel.mainTable.addCell(this.PreviewPanelPrevewAsBlock());
    previewPanel.mainTable.addCell(this.GroupBlockSeparator());
    previewPanel.mainTable.addCell(this.PreviewPanelNavigationBlock());
    previewPanel.mainTable.addCell(this.GroupBlockSeparator());
    previewPanel.mainTable.addCell(this.PreviewPanelViewModeBlock());
    previewPanel.mainTable.addCell(this.GroupBlockSeparator());
    previewPanel.appendChild(previewPanel.mainTable);

    previewPanel.onshow = function () {
        this.jsObject.options.previewMode = true;
        this.undoButtonState = this.jsObject.options.buttons.undoButton.isEnabled;
        this.redoButtonState = this.jsObject.options.buttons.redoButton.isEnabled;
        this.jsObject.options.buttons.undoButton.setEnabled(false);
        this.jsObject.options.buttons.redoButton.setEnabled(false);

        if (this.jsObject.options.mvcMode) {            
            this.jsObject.options.pagesPanel.changeVisibleState(false);
            if (this.jsObject.options.report && this.jsObject.options.currentPage) {                
                this.jsObject.options.currentPage.style.display = "none";
                this.jsObject.options.paintPanel.style.textAlign = "center";
                if (this.jsObject.options.showPanelPropertiesAndDictionary) {
                    this.jsObject.options.propertiesPanel.changeVisibleState(false);
                    this.jsObject.options.propertiesPanel.showButtonsPanel.changeVisibleState(false);
                }
            }
            return;
        }

        this.jsObject.options.viewerContainer.changeVisibleState(true);

        if (!this.jsObject.options.cloudMode)
            this.jsObject.options.viewer.jsObject.options.reportPanel.style.top = this.jsObject.options.viewer.jsObject.options.toolbar.offsetHeight + "px";

    }

    previewPanel.onhide = function () {
        this.jsObject.options.previewMode = false;
        this.jsObject.options.buttons.undoButton.setEnabled(this.undoButtonState);
        this.jsObject.options.buttons.redoButton.setEnabled(this.redoButtonState);

        if (this.jsObject.options.mvcMode) {
            this.jsObject.options.previewPageNumber = 0;
            this.jsObject.options.previewCountPages = 0;
            this.updateNavigationControls();
            this.jsObject.options.pagesPanel.changeVisibleState(true);
            if (this.jsObject.options.report && this.jsObject.options.currentPage) {                
                this.jsObject.options.currentPage.style.display = "";
                this.jsObject.options.paintPanel.style.textAlign = "left";
                this.jsObject.options.paintPanel.removePreviewPages();
                if (this.jsObject.options.showPanelPropertiesAndDictionary) {
                    this.jsObject.options.propertiesPanel.changeVisibleState(!this.jsObject.options.propertiesPanel.fixedViewMode);
                    this.jsObject.options.propertiesPanel.showButtonsPanel.changeVisibleState(this.jsObject.options.propertiesPanel.fixedViewMode);
                }
            }
            return;
        }

        this.jsObject.options.viewerContainer.changeVisibleState(false);

        if (this.jsObject.options.cloudMode) {
            var previewFrame = this.jsObject.options.viewerContainer.frame;
            var win = previewFrame.contentWindow || previewFrame.window;
            if (win && win.jsStiCloudReportsMobileViewer) {
                win.jsStiCloudReportsMobileViewer.StopRenderReportTask();
            }

            if (this.jsObject.options.buttons.previewToolButton)
                this.jsObject.options.buttons.previewToolButton.progress.style.visibility = "hidden";
        }
        else if (this.jsObject.options.viewer) {
            var viewerExportForm = this.jsObject.options.viewer.jsObject.options.forms.exportForm;
            if (viewerExportForm && viewerExportForm.visible) viewerExportForm.changeVisibleState(false);
            this.jsObject.options.viewer.jsObject.options.processImage.hide();
        }
    }

    previewPanel.updateNavigationControls = function () {
        var controls = this.jsObject.options.controls;
        var buttons = this.jsObject.options.buttons;
        var options = this.jsObject.options;

        if (buttons.previewOnePage.isEnabled && buttons.previewWholeReport.isEnabled)
            if (options.previewPageNumber != -1) buttons.previewOnePage.setSelected(true); else buttons.previewWholeReport.setSelected(true);
        buttons.previewFirstPage.setEnabled(options.previewPageNumber > 0);
        buttons.previewPrevPage.setEnabled(options.previewPageNumber > 0);
        buttons.previewNextPage.setEnabled(options.previewPageNumber < options.previewCountPages - 1 && options.previewPageNumber != -1);
        buttons.previewLastPage.setEnabled(options.previewPageNumber < options.previewCountPages - 1 && options.previewPageNumber != -1);
        controls.previewGotoPage.setEnabled(options.previewPageNumber != -1 && options.report != null);
        controls.previewGotoPage.value = controls.previewGotoPage.isEnabled ? options.previewPageNumber + 1 : "";

        var wordPage = previewPanel.jsObject.loc.Toolbars.TabPage;
        var wordPageOf = previewPanel.jsObject.loc.A_WebViewer.PageOf;

        controls.groupBlockNavigation.cellPageOf.innerHTML = wordPage + " " + (controls.previewGotoPage.isEnabled ? options.previewPageNumber + 1 : "0") + " " +
            wordPageOf + " " + options.previewCountPages;
    }
}

//Prevew As
StiMobileDesigner.prototype.PreviewPanelPrevewAsBlock = function () {
    var previewAsGroupBlock = this.GroupBlock("groupBlockPrevewAs", this.loc.Wizards.Preview, false, null);
    var innerTable = this.CreateHTMLTable();
    previewAsGroupBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";
    innerTable.style.width = "100%";
    
    //Preview As HTML Button
    var previewAsHTMLButton = this.BigButton("previewAsHTML", null, this.loc.DesignerFx.PreviewAs.replace("{0}", "HTML"), "PreviewAsHTML.png",
        [this.loc.DesignerFx.PreviewAs.replace("{0}", "HTML"), this.HelpLinks["preview"]], false, this.GetStyles("StandartBigButton"));
    innerTable.addCell(previewAsHTMLButton).style.padding = "2px";
    previewAsHTMLButton.action = function() { this.jsObject.PreviewAs("html"); }
    
    //Preview As PDF Button
    var previewAsPDFButton = this.BigButton("previewAsPDF", null, this.loc.DesignerFx.PreviewAs.replace("{0}", "PDF"), "PreviewAsPDF.png",
        [this.loc.DesignerFx.PreviewAs.replace("{0}", "PDF"), this.HelpLinks["preview"]], false, this.GetStyles("StandartBigButton"));
    innerTable.addCell(previewAsPDFButton).style.padding = "2px";
    previewAsPDFButton.action = function() { this.jsObject.PreviewAs("pdf"); }

    return previewAsGroupBlock;
}

//Navigation
StiMobileDesigner.prototype.PreviewPanelNavigationBlock = function () {
    var navigationBlock = this.GroupBlock("groupBlockNavigation", this.loc.PropertyCategory.NavigationCategory, false, null);
    var innerTable = this.CreateHTMLTable();
    navigationBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";
    var upTable = this.CreateHTMLTable(); 
    var downTable = this.CreateHTMLTable(); 
    downTable.style.width = "100%";
    innerTable.addCell(upTable);
    innerTable.addCellInNextRow(downTable);
    
    //FirstPage
    var firstPageButton = this.StandartSmallButton("previewFirstPage", null, null, "FirstPage.png",
        [this.loc.A_WebViewer.FirstPage, this.HelpLinks["preview"]], null);
    firstPageButton.action = function () {
        this.jsObject.options.previewPageNumber = 0;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
    upTable.addCell(firstPageButton).style.padding = "0 2px 0 2px";
    
    //PrevPage
    var prevPageButton = this.StandartSmallButton("previewPrevPage", null, null, "PrevPage.png",
        [this.loc.A_WebViewer.PrevPage, this.HelpLinks["preview"]], null);
    prevPageButton.action = function () {
        if (this.jsObject.options.previewPageNumber > 0) this.jsObject.options.previewPageNumber--;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
    upTable.addCell(prevPageButton).style.padding = "0 2px 0 2px";
    
    //GotoPage
    var gotoPage = this.TextBox("previewGotoPage", 50);   
    gotoPage.action = function () { 
        if (this.value == this.jsObject.options.previewPageNumber + 1) return;
        this.value = this.jsObject.StrToCorrectPositiveInt(this.value);
        this.jsObject.options.previewPageNumber = this.jsObject.StrToInt(this.value) == 0 ? this.jsObject.StrToInt(this.value) : this.jsObject.StrToInt(this.value) - 1; 
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
    upTable.addCell(gotoPage).style.padding = "0 2px 0 2px";
    
    //NextPage
    var nextPageButton = this.StandartSmallButton("previewNextPage", null, null, "NextPage.png",
        [this.loc.A_WebViewer.NextPage, this.HelpLinks["preview"]], null);
    nextPageButton.action = function () {
        if (this.jsObject.options.previewPageNumber < this.jsObject.options.previewCountPages - 1) this.jsObject.options.previewPageNumber++;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
    upTable.addCell(nextPageButton).style.padding = "0 2px 0 2px";
        
    //LastPage
    var lastPageButton = this.StandartSmallButton("previewLastPage", null, null, "LastPage.png",
        [this.loc.A_WebViewer.LastPage, this.HelpLinks["preview"]], null);
    lastPageButton.action = function () { 
        this.jsObject.options.previewPageNumber = this.jsObject.options.previewCountPages - 1;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
    upTable.addCell(lastPageButton).style.padding = "0 2px 0 2px";
    
    //Page Of
    navigationBlock.cellPageOf = downTable.addCell();
    navigationBlock.cellPageOf.style.textAlign = "Center";
    navigationBlock.cellPageOf.style.fontSize = "12px";
    navigationBlock.cellPageOf.setAttribute("colspan", "5");
   
    return navigationBlock;
}

//View Mode
StiMobileDesigner.prototype.PreviewPanelViewModeBlock = function () {
    var viewModeGroupBlock = this.GroupBlock("groupBlockViewMode", this.loc.FormViewer.ViewMode, false, null);
    var innerTable = this.CreateHTMLTable();
    viewModeGroupBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";
    innerTable.style.width = "100%";
    
    //One Page
    var previewOnePage = this.BigButton("previewOnePage", "previewViewMode", this.loc.A_WebViewer.OnePage, "OnePage.png",
        [this.loc.A_WebViewer.OnePage, this.HelpLinks["preview"]], false, this.GetStyles("StandartBigButton"));
    innerTable.addCell(previewOnePage).style.padding = "2px";
    previewOnePage.action = function() { 
        this.setSelected(true);
        this.jsObject.options.previewPageNumber = 0;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }

    //Whole Report
    var previewWholeReport = this.BigButton("previewWholeReport", "previewViewMode", this.loc.A_WebViewer.WholeReport, "WholeReport.png",
        [this.loc.A_WebViewer.WholeReport, this.HelpLinks["preview"]], false, this.GetStyles("StandartBigButton"));
    innerTable.addCell(previewWholeReport).style.padding = "2px";
    previewWholeReport.action = function() { 
        this.setSelected(true);
        this.jsObject.options.previewPageNumber = -1;
        this.jsObject.options.previewPanel.updateNavigationControls();
        this.jsObject.SendCommandGetPreviewPages(this.jsObject.options.previewPageNumber);
    }
            
    return viewModeGroupBlock;
}

StiMobileDesigner.prototype.PreviewAs = function (format) {
    this.options.previewAsAction = true;
    this.SendCommandPreviewAs(format); //Only for MVC Designer\    
}