﻿
StiMobileDesigner.prototype.InitializeToolBar = function () {
    var toolBar = document.createElement("div");
    this.options.toolBar = toolBar;    
    this.options.mainPanel.appendChild(toolBar);
    toolBar.className = "stiDesignerToolBar";
    toolBar.jsObject = this;
    if (this.options.isTouchDevice) toolBar.style.overflowX = "auto"; else toolBar.style.overflow = "hidden";
    var toolButoonCellClass = "stiDesignerToolButtonCell";

    var toolBarTable = this.CreateHTMLTable();
    toolBarTable.style.width = "100%";    
    toolBarTable.style.height = "100%";
    toolBar.appendChild(toolBarTable);

    toolBar.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        this.jsObject.options.paintPanel.style.top = this.jsObject.options.workPanel.offsetHeight + this.offsetHeight + "px";
    }

    if (this.options.showSaveButton) {
        var saveReportHotButton = this.StatusPanelButton("saveReportHotButton", null, "SaveWhite.png", null, null, 30, 30);
        saveReportHotButton.style.marginLeft = "3px";
        var saveReportToolHotButtonCell = toolBarTable.addCell(saveReportHotButton);
        saveReportToolHotButtonCell.className = toolButoonCellClass;
        saveReportHotButton.action = function () { this.jsObject.ActionSaveReport(); }
    }

    //Undo Button
    var undoButton = this.StatusPanelButton("undoButton", null, "Undo.png", this.loc.MainMenu.menuEditUndo.replace("&", ""), null, 30, 30);
    toolBarTable.addCell(undoButton).className = toolButoonCellClass;
    undoButton.style.marginLeft = "3px";

    //Redo Button
    var redoButton = this.StatusPanelButton("redoButton", null, "Redo.png", this.loc.MainMenu.menuEditRedo.replace("&", ""), null, 30, 30);
    toolBarTable.addCell(redoButton).className = toolButoonCellClass;
    redoButton.style.marginLeft = "3px";    

    var fileButtonCell = toolBarTable.addCell();
    fileButtonCell.className = toolButoonCellClass;
    var fileButton = this.FileButton();
    fileButton.style.margin = "2px 2px 0 3px";
    fileButtonCell.appendChild(fileButton);
    fileButton.style.display = this.options.showFileMenu && !this.options.cloudMode ? "" : "none";
    
    var buttons = [
        ["homeToolButton", this.loc.Toolbars.TabHome, true],
        ["insertToolButton", this.loc.PropertyMain.Insert, this.options.showInsertButton],
        ["layoutToolButton", this.loc.Toolbars.TabLayout, this.options.showLayoutButton],
        ["previewToolButton", this.loc.Wizards.Preview, this.options.showPreviewButton],
    ]

    for (var i in buttons) {
        var toolButtonCell = toolBarTable.addCell(this.ToolButton(buttons[i][0], buttons[i][1],
            (this.options.cloudMode && buttons[i][0] == "previewToolButton") ? true : false));
        toolButtonCell.className = toolButoonCellClass;
        toolButtonCell.style.display = buttons[i][2] ? "" : "none";
    }

    if (this.options.cloudMode && this.options.buttons.previewToolButton) {
        var previewToolButton = this.options.buttons.previewToolButton;
        previewToolButton.progress = this.ProgressMini();
        previewToolButton.progress.style.visibility = "hidden";
        previewToolButton.caption.style.padding = "0 2px 0 7px";
        previewToolButton.style.padding = "0 3px 0 12px";
        previewToolButton.innerTable.addCell(this.options.buttons.previewToolButton.progress);
    }

    var freeCell = toolBarTable.addCell();
    freeCell.style.width = "100%";
    freeCell.className = toolButoonCellClass;

    if (!this.options.fullScreenMode) {
        var resizeButton = this.StatusPanelButton("resizeDesigner", null, "ResizeWindow.png", this.loc.PropertyMain.Resize, null, 30, 30);
        toolBarTable.addCell(resizeButton).className = toolButoonCellClass;
        resizeButton.allwaysEnabled = true;
    }

    //Localization
    if (this.options.jsMode && this.options.showLocalization) {
        var locControl = document.createElement("div");
        this.localizationControl = locControl;
        var locCell = toolBarTable.addCell(locControl);
        locCell.className = toolButoonCellClass;
        locControl.style.margin = "0 2px 0 2px";
        locControl.key = "en";

        var locButton = this.StatusPanelButton("localizationButton", "EN", null, null, null, 30, 30);
        locControl.appendChild(locButton);
        locButton.allwaysEnabled = true;

        var locMenu = this.VerticalMenu("localizationMenu", locButton, "Down", null, this.GetStyles("MenuStandartItem"));
        locMenu.rightToLeft = true;

        locButton.action = function () { locMenu.changeVisibleState(!locMenu.visible); }

        locControl.action = function () { }

        locControl.setKey = function (key) {
            this.key = key;
            if (key) locButton.caption.innerHTML = key.toUpperCase();
        }

        locControl.addItems = function (items) {
            locMenu.addItems(items);
        }

        locMenu.action = function (menuItem) {
            locMenu.changeVisibleState(false)
            locControl.setKey(menuItem.key);
            locControl.action();
        }

        locMenu.onshow = function () {
            for (var i in this.items) {
                if (this.items[i].caption)
                    this.items[i].setSelected(locControl.key == this.items[i].key);
            }
        }
    }

    //About Button
    var aboutButton = this.StatusPanelButton("aboutButton", null, "AboutIcon.png", this.loc.MainMenu.menuHelpAboutProgramm.replace("&", "").replace("...", ""), null, 30, 30)
    aboutButton.style.margin = "0 2px 0 2px";
    var aboutCell = toolBarTable.addCell(aboutButton);
    aboutCell.className = toolButoonCellClass;
    aboutButton.allwaysEnabled = true;
    aboutButton.style.display = this.options.showAboutButton ? "" : "none";

    //Show Toolbar button
    var showToolBarButton = this.StatusPanelButton("showToolBarButton", null, "ShowToolbar.png", null, null, 30, 30);
    showToolBarButton.allwaysEnabled = true;
    showToolBarButton.style.display = "none";
    showToolBarButton.style.margin = "0 2px 0 2px";
    toolBarTable.addCell(showToolBarButton).className = toolButoonCellClass;

    this.options.buttons["homeToolButton"].setSelected(true);
}