﻿
StiMobileDesigner.prototype.InitializeWizardFormDataSource = function (wizardForm) {
    var dataSourcePanel = this.WizardFormWorkPanel(wizardForm, "dataSource");
    dataSourcePanel.helpTextStandart = "<b>" + this.loc.Wizards.DataSource + "</b><br>" + this.loc.Wizards.infoDataSource;
    dataSourcePanel.helpTextMasterDetail = "<b>" + this.loc.Wizards.DataSource + "</b><br>" + this.loc.Wizards.infoDataSources;
    this.InitializeWizardFormStepItem(wizardForm, dataSourcePanel.name, this.loc.Wizards.DataSource);
    dataSourcePanel.dataSourceControls = {};
    dataSourcePanel.wizardForm = wizardForm;

    var newDataSourceButton = this.StandartSmallButton("dataFormNewDataSourceButton", null, this.loc.FormDictionaryDesigner.DataSourceNew, "DataSourceNew.png", null, null, true);
    newDataSourceButton.style.display = "inline-block";
    newDataSourceButton.style.margin = "4px";
    dataSourcePanel.appendChild(newDataSourceButton);
    
    newDataSourceButton.action = function () {
        this.jsObject.InitializeSelectConnectionForm(function (selectConnectionForm) {
            selectConnectionForm.changeVisibleState(true);

            wizardForm.onshow
        });
    };

    dataSourcePanel.itemsContent = document.createElement("div");
    dataSourcePanel.itemsContent.className = "wizardFormDataSourcesContent";
    dataSourcePanel.appendChild(dataSourcePanel.itemsContent);

    dataSourcePanel.buttonsContent = document.createElement("div");
    dataSourcePanel.buttonsContent.className = "wizardFormColumnsButtonsContent";
    dataSourcePanel.appendChild(dataSourcePanel.buttonsContent);
    var buttonsTable = this.CreateHTMLTable();
    dataSourcePanel.buttonsContent.appendChild(buttonsTable);
    buttonsTable.className = "wizardFormColumnsButtonsTable stiDesignerClearAllStyles";

    buttonsTable.addCell().style.width = "100%";

    //Button Relations
    dataSourcePanel.relationsButton = this.FormButton(null, "wizardFormDataSourceRelationsButton", this.loc.PropertyMain.Relations, null);
    dataSourcePanel.relationsButton.style.marginRight = "8px";
    buttonsTable.addCell(dataSourcePanel.relationsButton);
    dataSourcePanel.relationsButton.dataSourcePanel = dataSourcePanel;
    dataSourcePanel.relationsButton.action = function () {
        var wizardRelationsForm = this.jsObject.options.forms.wizardRelationsForm || this.jsObject.InitializeWizardRelationsForm();
        wizardRelationsForm.changeVisibleState(true);
    }

    dataSourcePanel.onShow = function () {
        this.update();
    }

    dataSourcePanel.update = function () {
        while (this.itemsContent.childNodes[0]) this.itemsContent.removeChild(this.itemsContent.childNodes[0]);
        this.dataSourceControls = {};
        var dataSources = this.wizardForm.dataSourcesFromServer;
        var dataSourcesOrder = this.wizardForm.reportOptions.dataSourcesOrder;
        if (this.wizardForm.typeReport == "MasterDetail")
            for (var index = 0; index < dataSourcesOrder.length; index++) {
                var alias = null;
                for (var k = 0; k < dataSources.length; k++) {
                    if (dataSources[k].name == dataSourcesOrder[index]) {
                        alias = dataSources[k].alias;
                        break;
                    }
                }
                this.createItem(dataSourcesOrder[index], alias);
            }
        for (var dataSourceIndex in dataSources) {
            if (!this.wizardForm.dataSources[dataSources[dataSourceIndex].name] || this.wizardForm.typeReport == "Standart")
                this.createItem(dataSources[dataSourceIndex].name, dataSources[dataSourceIndex].alias);
        }
        this.wizardForm.buttonNext.setEnabled(this.jsObject.GetCountObjects(wizardForm.dataSources) != 0);
        this.relationsButton.setEnabled(this.jsObject.GetCountObjects(wizardForm.reportOptions.relations) != 0);
        this.buttonsContent.style.display = wizardForm.typeReport == "Standart" ? "none" : "";
        this.itemsContent.className = wizardForm.typeReport == "Standart" ? "wizardFormDataSourcesContentWithoutButtons" : "wizardFormDataSourcesContent";
    }

    dataSourcePanel.createItem = function (dataSourceName, dataSourceAlias) {
        var dataSources = this.wizardForm.dataSourcesFromServer;
        var checkBox = this.jsObject.WizardFormCheckBox("WizardFormDataSource_" + dataSourceName, (dataSourceName == dataSourceAlias || !dataSourceAlias) ? dataSourceName : dataSourceName + " [" + dataSourceAlias + "]", dataSourceName);
        this.itemsContent.appendChild(checkBox);
        this.dataSourceControls[dataSourceName] = checkBox;
        checkBox.dataSourcePanel = this;
        checkBox.setChecked(this.wizardForm.dataSources[dataSourceName])

        checkBox.action = function () {
            var wizardForm = this.jsObject.options.forms.wizardForm || this.jsObject.InitializeWizardForm();
            if (wizardForm.typeReport == "Standart") {
                wizardForm.reportOptions.dataSourcesOrder = [];
                wizardForm.reportOptions.dataSourcesOrder.push(this.key);
                if (!this.isChecked) { this.setChecked(true); return; }
                wizardForm.buttonNext.setEnabled(true);
                wizardForm.dataSources = {}
                wizardForm.dataSources[this.key] = this.jsObject.EmptyDataSourceObject();
                for (var controlName in this.dataSourcePanel.dataSourceControls) this.dataSourcePanel.dataSourceControls[controlName].setChecked(this.key == controlName);
            }
            else {
                var numElement = this.jsObject.GetElementNumberInArray(this.key, wizardForm.reportOptions.dataSourcesOrder);
                if (numElement != -1) wizardForm.reportOptions.dataSourcesOrder.splice(numElement, 1);
                if (this.isChecked) {
                    wizardForm.reportOptions.dataSourcesOrder.push(this.key);
                    wizardForm.dataSources[this.key] = this.jsObject.EmptyDataSourceObject();

                    var relation = this.dataSourcePanel.dataSourceHaveRelationOnMainDataSource(this.key);
                    if (relation) wizardForm.reportOptions.relations[this.key] = { "name": relation.name, "nameInSource": relation.nameInSource, "checked": true };
                }
                else {
                    if (wizardForm.dataSources[this.key]) {
                        delete wizardForm.dataSources[this.key];
                        delete wizardForm.reportOptions.relations[this.key];
                        for (var relationKey in wizardForm.reportOptions.relations)
                            if (wizardForm.reportOptions.relations[relationKey].name == this.key) delete wizardForm.reportOptions.relations[relationKey];
                    }
                }
                wizardForm.buttonNext.setEnabled(this.jsObject.GetCountObjects(wizardForm.dataSources) != 0);
                this.dataSourcePanel.update();
            }
        }
    }

    dataSourcePanel.dataSourceHaveRelationOnMainDataSource = function (dataSourceName) {
        if (this.wizardForm.reportOptions.dataSourcesOrder.length <= 1) return false;
        var mainDataSourceName = wizardForm.reportOptions.dataSourcesOrder[0];
        var dataSource = this.wizardForm.getDataSourceByName(dataSourceName);
        if (dataSource) {
            relations = dataSource.relations;
            for (var i in relations) if (relations[i].parentDataSource == mainDataSourceName) return relations[i];
        }
        return false;
    }
}


StiMobileDesigner.prototype.EmptyDataSourceObject = function () {
    return {
        "columns": [],
        "columnsText": {},
        "sort": [],
        "filterMode": "And",
        "filterOn": true,
        "filters": [],
        "groups": [],
        "totals": {}
    }
}