﻿
StiMobileDesigner.prototype.InitializeWizardFormFilter = function (wizardForm) {
    var filterPanel = this.WizardFormWorkPanel(wizardForm, "filter");
    filterPanel.helpTextStandart = "<b>" + this.loc.PropertyMain.Filters + "</b><br>" + this.loc.Wizards.infoFilters;
    this.InitializeWizardFormStepItem(wizardForm, filterPanel.name, this.loc.PropertyMain.Filters);
    filterPanel.wizardForm = wizardForm;
    filterPanel.selectedColumnsItem = null;

    filterPanel.onShow = function () {
        this.update();
    }

    filterPanel.onHide = function () {
        if (this.jsObject.GetCountObjects(this.wizardForm.dataSources) != 0) this.apply();
    }

    filterPanel.update = function () {
        this.clear();
        var dataSourcesTabs = [];
        for (var dataSourceName in this.wizardForm.dataSources) dataSourcesTabs.push(dataSourceName);
        this.tabbedPane = this.jsObject.WizardFormTabbedPane("WizardFormFilterTabbedPane", dataSourcesTabs);
        this.appendChild(this.tabbedPane);
        for (var i in dataSourcesTabs) {
            var columnsItems = this.wizardForm.workPanels.columns.getColumnsItems(dataSourcesTabs[i]);
            var filterControl = this.jsObject.FilterControl("WizardFormFilterControl" + this.jsObject.newGuid().replace(/-/g, ''), columnsItems, null, this.jsObject.options.isTouchDevice ? 302 : 312);

            var currentTabPanel = this.tabbedPane.tabsPanels[dataSourcesTabs[i]];
            //currentTabPanel.style.padding = "1px";
            currentTabPanel.appendChild(this.jsObject.FormSeparator());
            currentTabPanel.appendChild(filterControl);
            currentTabPanel.filterControl = filterControl;
            var currentDataSource = this.wizardForm.dataSources[dataSourcesTabs[i]];
            filterControl.fill(currentDataSource.filters, currentDataSource.filterOn, currentDataSource.filterMode);
        }
    }

    filterPanel.apply = function () {
        for (var dataSourceName in this.tabbedPane.tabsPanels) {
            var filterControl = this.tabbedPane.tabsPanels[dataSourceName].filterControl;
            var filterResult = filterControl.getValue();
            var dataSource = this.wizardForm.dataSources[dataSourceName];

            dataSource.filters = filterResult.filters;
            dataSource.filterOn = filterResult.filterOn;
            dataSource.filterMode = filterResult.filterMode;
        }
    }
}



