

function StiMobileDesigner(parameters) {
    this.defaultParameters = {};
    this.options = parameters;

    this.options.buttons = {};
    this.options.controls = {};
    this.options.menus = {};
    this.options.forms = {};
    this.options.radioButtons = {};
    this.options.callbackFunctions = {};
    this.options.openDialogs = {};
    this.options.properties = {};
    this.options.propertiesGroups = {};
    this.options.dataBasesTreeOpeningArray = {};
    this.options.dataBasesTreeOpeningArrayTemp = {};
    this.options.paintPanelPadding = 30;
    this.options.previewPageNumber = 0;
    this.options.previewCountPages = 0;
    this.options.commands = [];
    this.options.touchZoom = {};
    this.options.startZoom = 0;
    this.options.oldDeltaPos = 0;
    this.options.timeUpdateCache = 30000;
    this.options.modifyRestrictions = true;
    this.options.mobileDesigner = document.getElementById(parameters.mobileDesignerId);

    this.options.requestUrl = parameters.requestUrl;
    this.options.requestAbsoluteUrl = parameters.requestAbsoluteUrl;
    this.options.isJava = parameters.isJava;
    this.options.head = document.getElementsByTagName("head")[0];
    this.options.isTouchDevice = parameters.interfaceType == "Auto" ? this.IsTouchDevice() : parameters.interfaceType == "Touch";
    this.options.canOpenFiles = window.File && window.FileReader && window.FileList && window.Blob;    
    this.options.menuAnimDuration = parameters.showAnimation ? 150 : 0;
    this.options.formAnimDuration = parameters.showAnimation ? 200 : 0;
    this.options.xOffset = 0.5;
    this.options.yOffset = 0.5;
    this.options.containers = {};
    this.options.routes = JSON.parse(parameters.routes);
    this.options.designerIsFocused = true;
    this.options.fontSizes = this.GetFontSizes();
    this.options.monthesCollection = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    this.options.dayOfWeekCollection = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
    this.options.themeColors = { Blue: "#19478a", Carmine: "#912c2f", Green: "#0b6433", Orange: "#b73a1c", Purple: "#8653a5", Teal: "#23645c", Violet: "#6d3069" };
    this.options.propertyControlWidth = this.options.propertiesGridWidth - this.options.propertiesGridLabelWidth - 35;
    this.options.propertyNumbersControlWidth = Math.max(this.options.propertyControlWidth - 100, 40);
    this.options.showPanelPropertiesAndDictionary = this.options.showDictionary || this.options.showPropertiesGrid;
    this.options.mvcMode = true;
    
    if (parameters.loc) {
        var loc = JSON.parse(parameters.loc);
        this.loc = loc.Localization || loc;
        delete this.options.loc;
    }
    
    //Data Tree
    this.options.dataTree = this.DataTree();
    this.options.mobileDesigner.jsObject = this;
    this.options.mainPanel = document.getElementById(this.options.mobileDesigner.id + "_MainPanel");

    //Initialize Controls
    var jsObject = this;
    this.PrepareStyles();
    this.CreateMetaTag();
    this.InitializeDesigner();
    this.InitializeToolBar();
    this.InitializeWorkPanel();
    this.InitializeHomePanel();  
    this.InitializeStatusPanel();
    this.InitializePropertiesPanel();
    this.InitializePagesPanel();
    this.InitializePaintPanel();
    this.InitializeToolTip();
        
    this.addEvent(document, 'mousemove', function (event) {
        jsObject.DocumentMouseMove(event);
    });

    this.addEvent(document, 'touchmove', function (event) {
        jsObject.DocumentTouchMove(event);
    });

    this.addEvent(document, 'touchend', function (event) {
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);

        jsObject.DocumentTouchEnd(event);

        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    });

    this.addEvent(document, 'mouseup', function (event) {
        if (this.isTouchEndTimer) return;
        jsObject.DocumentMouseUp(event);
    });

    if (this.options.runWizardAfterLoad) {
        var fileMenu = this.options.menus.fileMenu || this.InitializeFileMenu();
        fileMenu.changeVisibleState(true);
    }

    this.SendCommandLoadReport();
}