
StiMobileDesigner.prototype.ParseReport = function(reportInObject) {
    if (reportInObject == null) return null;
    return JSON.parse(reportInObject);
}

StiMobileDesigner.prototype.LoadReport = function (reportObject, undoRedo) {
    if (reportObject == null) {
        this.options.report = null;
        if (this.options.processImage) this.options.processImage.hide();
        return;
    }

    this.SetEnabledAllControls(true);

    if (!undoRedo) {
        this.options.workPanel.showPanel(this.options.homePanel);
        this.options.buttons.homeToolButton.setSelected(true);
    }

    if (!this.options.runWizardAfterLoad) this.options.workPanel.changeVisibleState(true);

    this.options.homePanel.updateControls();
    this.options.report = this.InitializeReportObject();
    if (reportObject.encryptedPassword != null) this.options.report.encryptedPassword = reportObject.encryptedPassword;
    this.options.reportIsModified = false;
    this.options.report.zoom = this.StrToDouble(reportObject.zoom);
    this.options.controls.zoomScale.setZoomPosition();
    this.options.report.properties = reportObject.properties;
    this.options.report.info = reportObject.info;
    this.options.buttons.unitButton.updateCaption(this.options.report.properties.reportUnit);
    this.options.buttons.undoButton.setEnabled(false);
    this.options.buttons.redoButton.setEnabled(false);
    this.options.report.gridSize = this.StrToDouble(reportObject.gridSize);
    this.options.report.dictionary = reportObject.dictionary;
    this.options.dictionaryTree.build(reportObject.dictionary);
    this.options.report.stylesCollection = reportObject.stylesCollection;
    this.options.report.pages = {};
    this.options.paintPanel.clear();
    if (this.options.showPreviewButton) this.options.buttons.previewToolButton.style.display = "";

    for (var indexPage in reportObject.pages) {
        var page = this.CreatePage(reportObject.pages[indexPage]);
        page.repaint();
        this.options.paintPanel.addPage(page);
        this.options.report.pages[page.properties.name] = page;
        this.options.report.pages[page.properties.name].components = {};

        for (var numComponent in reportObject.pages[indexPage].components) {
            if (ComponentCollection[reportObject.pages[indexPage].components[numComponent].typeComponent]) {
                var component = this.CreateComponent(reportObject.pages[indexPage].components[numComponent]);
                if (component) {
                    component.repaint();
                    this.options.report.pages[page.properties.name].components[component.properties.name] = component;
                }
            }
        }

        page.addComponents();
        if (page.properties.pageIndex == 0) {
            this.options.paintPanel.showPage(page);
            this.options.currentPage.setSelected();
        }
    }

    if (this.GetCountObjects(reportObject.pages) == 0) {
        this.SetEnabledAllControls(false);
        var errorMessageForm = this.options.forms.errorMessageForm || this.InitializeErrorMessageForm();
        errorMessageForm.show(this.loc.Errors.Error);
    }
    this.options.pagesPanel.pagesContainer.updatePages();
    clearTimeout(this.options.timerUpdateCache);

    var jsObject = this;
    this.options.timerUpdateCache = setTimeout(function () {
        jsObject.SendCommandUpdateCache();
    }, this.options.timeUpdateCache);

    clearTimeout(this.options.timerAutoSave);
    var this_ = this;
    if (this.options.report.info.enableAutoSaveMode && this.options.report.info.autoSaveInterval) {
        this.options.timerAutoSave = setInterval(function () {
            if (this_.options.report) {
                this_.ActionSaveReport(function () { this_.SendCommandCloseReport(); });
            }
        }, this.StrToInt(this.options.report.info.autoSaveInterval) * 60000);
    }

    if (!this.options.cloudMode) {
        var reportFile = this.options.report.properties.reportFile;
        if (reportFile != null) reportFile = reportFile.substring(reportFile.lastIndexOf("/")).substring(reportFile.lastIndexOf("\\"));
        var reportName = reportFile || Base64.decode(this.options.report.properties.reportName.replace("Base64Code;", ""));
        this.SetWindowTitle(reportName ? reportName + " - " + this.loc.FormDesigner.title : this.loc.FormDesigner.title);
    }

    var processImage = this.options.processImage || this.InitializeProcessImage();
    processImage.hide();
    if (this.options.reportTree) {
        this.options.reportTree.reset();
        this.options.reportTree.build();
    }
}

StiMobileDesigner.prototype.CloseReport = function () {
    this.options.workPanel.showPanel(this.options.homePanel);
    this.options.buttons.homeToolButton.setSelected(true);
    this.options.paintPanel.clear();
    this.options.pagesPanel.pagesContainer.clear();
    this.options.dictionaryTree.clear();
    this.options.report = null;
    this.options.selectedObject = null;
    this.options.reportGuid = null;
    this.options.reportIsModified = false;
    this.options.previewPageNumber = 0;
    this.SetEnabledAllControls(false);
    this.options.homePanel.updateControls();
    this.options.propertiesPanel.updateControls();
    if (this.options.previewPanel) this.options.previewPanel.updateNavigationControls();
    if (this.options.showPreviewButton) this.options.buttons.previewToolButton.style.display = "none";
    if (this.options.layoutPanel) this.options.layoutPanel.updateControls();
    clearTimeout(this.options.timerUpdateCache);
    clearTimeout(this.options.timerAutoSave);
    if (!this.options.cloudMode) {
        this.SetWindowTitle(this.loc.FormDesigner.title);
    }
    if (this.options.reportTree) this.options.reportTree.clear();
}

StiMobileDesigner.prototype.ActionCloseReport = function () {
    if (this.options.reportIsModified) {
        var messageForm = this.MessageFormForSave();
        messageForm.changeVisibleState(true);
        messageForm.action = function (state) {
            if (state) {
                var jsObject = this.jsObject;
                jsObject.ActionSaveReport(function () { jsObject.SendCommandCloseReport(); });
            }
            else { this.jsObject.SendCommandCloseReport(); }
        }
    }
    else this.SendCommandCloseReport();
}

StiMobileDesigner.prototype.ActionNewReport = function () {
    this.options.workPanel.showPanel(this.options.homePanel);
    this.options.buttons.homeToolButton.setSelected(true);

    if (this.options.report != null) {
        if (this.options.reportIsModified) {
            var messageForm = this.MessageFormForSave();
            messageForm.changeVisibleState(true);
            messageForm.action = function (state) {
                if (state) {
                    var jsObject = this.jsObject;
                    jsObject.ActionSaveReport(function () { jsObject.SendCommandCreateReport(); });
                }
                else { this.jsObject.SendCommandCloseReport(); this.jsObject.SendCommandCreateReport(); }
            }
        }
        else { this.SendCommandCloseReport(); this.SendCommandCreateReport(); }
    }
    else { this.SendCommandCreateReport(); }
}

StiMobileDesigner.prototype.ActionOpenReport = function () {
    this.options.workPanel.showPanel(this.options.homePanel);
    this.options.buttons.homeToolButton.setSelected(true);
    this.InitializeOpenDialog("openReport", this.StiHandleOpenReport, ".mrt,.mrz,.mrx");
    if (this.options.report != null && this.options.reportIsModified) {
        var messageForm = this.MessageFormForSave();
        messageForm.changeVisibleState(true);
        messageForm.action = function (state) {
            if (state) {
                var jsObject = this.jsObject;
                this.jsObject.ActionSaveReport(function () { jsObject.options.openDialogs.openReport.action(); });
            }
            else {
                this.jsObject.options.openDialogs.openReport.action();
            }
        }
    }
    else { this.options.openDialogs.openReport.action(); }
}

StiMobileDesigner.prototype.ActionSaveReport = function (nextFunc) {
    if (this.options.showSaveDialog && !this.options.report.properties.reportFile) {
        var saveReportForm = this.options.forms.saveReport || this.InitializeSaveReportForm();
        saveReportForm.show(false, nextFunc);
    }
    else {
        this.SendCommandSaveReport();
        if (nextFunc) nextFunc();
    }
}

StiMobileDesigner.prototype.ActionSaveAsReport = function () {
    if (this.options.showSaveDialog) {
        var saveReportForm = this.options.forms.saveReport || this.InitializeSaveReportForm();
        saveReportForm.show(true);
    }
    else {
        this.SendCommandSaveAsReport();
    }

}

StiMobileDesigner.prototype.InitializeReportObject = function () {
    var report = {
        jsObject: this,
        typeComponent: "StiReport",
        properties: {},
        info: this.CopyObject(this.options.defaultDesignerOptions)
    };
    report.setSelected = function () { this.jsObject.SetSelectedObject(this); }


    return report;
}