﻿
StiMvcViewer.prototype.InitializeButton = function (button) {
    button.jsObject = this;
    button.buttonName = button.getAttribute("buttonName");
    button.isParametersButton = button.getAttribute("isParametersButton") == "True";
    button.captionText = document.getElementById(button.id + "Caption");
    button.toolTip = button.getAttribute("toolTipObject") ? button.getAttribute("toolTipObject").split(";") : null;
    button.image = document.getElementById(button.id + "Image");
    button.imageContainer = document.getElementById(button.id + "ImageContainer");
    button.imageContainerInner = document.getElementById(button.id + "ImageContainerInner");
    button.menu = document.getElementById(button.id + "Menu");
    button.thisMenu = (button.getAttribute("menuName") != "") ? document.getElementById(this.options.mvcViewer.id + button.getAttribute("menuName")) : null;
    if (button.menu) button.menu.parentButton = button;
    if (button.thisMenu) {
        if (!("items" in button.thisMenu)) button.thisMenu.items = {};
        button.thisMenu.items[button.buttonName] = button;
    }
    this.options.buttons[button.buttonName] = button;
    button.isDisable = false;
    button.isSelected = false;
    button.isOver = false;

    button.setSelected = function (state) {
        this.isSelected = state;
        this.className = this.isOver ? "stiOverButton" : (state ? "stiSelectedButton" : "stiButton");
    }

    button.setEnabled = function (state) {
        this.isDisable = !state;
        if (!state) this.className = "stiDisabledButton";
        this.image.src = (state) ? this.image.getAttribute("source") : this.image.getAttribute("sourceDisabled");
    }

    button.action = function () {
        if (this.toolTip && this.jsObject.options.showTooltips) this.jsObject.options.toolTip.hide();
        if (this.menu) {
            if (this.menu.style.display == "none") this.menu.show(); else this.menu.hide();
        }
        else {
            if (this.jsObject.options.currentMenu) this.jsObject.options.currentMenu.hide();
            if (this.thisMenu) if (this.thisMenu.menuName == "SaveMenu") { this.jsObject.clickExport(this.buttonName); return; }
            this.jsObject.postViewerEvent(this.buttonName);
        }
    }

    button.onmouseover = function () {
        if (this.isDisable || this.isOver || this.jsObject.options.isTouchDevice) return;
        this.className = "stiOverButton";
        this.isOver = true;
        if (this.toolTip && this.jsObject.options.showTooltips)
            this.jsObject.options.toolTip.showWithDelay(
                        this.toolTip[0],
                        this.toolTip[1],
                        this.toolTip.length > 2 ? this.toolTip[2] : this.jsObject.FindPosX(this, "stiToolBarInnerContent") + 3,
                        this.toolTip.length > 2 ? this.toolTip[3] : this.jsObject.options.toolbar.offsetHeight - 2
                    );
    }

    button.onmouseout = function (event) {
        if (this.toolTip && !this.jsObject.options.isTouchDevice && this.jsObject.options.showTooltips) this.jsObject.options.toolTip.hideWithDelay();
        if (this.isDisable || this.jsObject.options.isTouchDevice) return;
        this.className = this.isSelected ? "stiSelectedButton" : (this.isParametersButton ? "stiParametersButton" : "stiButton");
        this.isOver = false;
    }

    button.onmousedown = function () {
        if (this.jsObject.options.isTouchDevice || this.isDisable) return;
        this.className = "stiPressedButton";
        this.jsObject.options.buttonWasPressed = true;
    }

    button.ontouchstart = function () {
        if (this.isDisable) return;
        this.jsObject.options.fingerIsMoved = false;
        this.jsObject.options.buttonWasPressed = true;
    }

    button.onmouseup = function () {
        if (this.jsObject.options.isTouchDevice || this.isDisable) return;
        this.jsObject.TouchEndButton(this, false);
    }

    button.ontouchend = function () { this.jsObject.TouchEndButton(this, true); }
}

StiMvcViewer.prototype.TouchEndButton = function (button, flag) {
    if (button.jsObject.options.fingerIsMoved || button.isDisable) return;

    if (flag) {
        button.className = "stiPressedButton";
        if ('preventDefault' in event) event.preventDefault();
        setTimeout("js" + button.jsObject.options.mvcViewer.id + ".TouchEndButton(" + button.id + ", false)", 200);
        return;
    }
    
    button.className = button.isParametersButton
        ? (button.isOver ? "stiParametersButtonOver" : "stiParametersButton")
        : (button.isOver ? "stiOverButton" : "stiButton")    
    button.action();
}