﻿
StiMvcViewer.prototype.InitializeExportCheckBox = function (checkBox) {
    checkBox.jsObject = this;
    checkBox.parentTable = document.getElementById(checkBox.id + "ParentTable");
    checkBox.parentTable.rows[0].cells[1].checkBox = checkBox;
    checkBox.checkBoxName = checkBox.parentTable.getAttribute("checkBoxName");

    checkBox.exportForm = document.getElementById(this.options.mvcViewer.id + "ExportForm");
    if (!checkBox.exportForm.controls) checkBox.exportForm.controls = new Object();
    checkBox.exportForm.controls[checkBox.checkBoxName] = checkBox;

    checkBox.reset = function () {
        this.checked = this.parentTable.getAttribute("defaultChecked") == "True";
        this.setEnabledState(this.parentTable.getAttribute("defaultEnabled") == "True");
    }

    checkBox.setEnabledState = function (state) {
        this.parentTable.className = state ? "stiEnabledExportControl" : "stiDisabledExportControl";
        this.disabled = !state
    }

    checkBox.changeVisibleState = function (state) {
        this.parentTable.style.display = state ? "" : "none";
    }

    checkBox.getValue = function () {
        return !this.disabled ? this.checked : false;
    }

    checkBox.onclick = function () {
        if (this.checkBoxName == "PdfACompliance") {
            this.exportForm.controls["StandardPDFFonts"].setEnabledState(!this.checked);
            this.exportForm.controls["EmbeddedFonts"].setEnabledState(!this.checked);
            this.exportForm.controls["UseUnicode"].setEnabledState(!this.checked);
        }
        if (this.checkBoxName == "UseDigitalSignature") {
            this.exportForm.controls["GetCertificateFromCryptoUI"].setEnabledState(this.checked);
            this.exportForm.controls["SubjectNameString"].setEnabledState(!this.checked ? false : !this.exportForm.controls["GetCertificateFromCryptoUI"].checked);
        }
        if (this.checkBoxName == "GetCertificateFromCryptoUI") { this.exportForm.controls["SubjectNameString"].setEnabledState(!this.checked); }
        if (this.checkBoxName == "ExportDataOnly") {
            this.exportForm.controls["ExportObjectFormatting"].setEnabledState(this.checked);
            this.exportForm.controls["UseOnePageHeaderFooter"].setEnabledState(!this.checked);
        }
        if (this.checkBoxName == "UseDefaultSystemEncoding") { this.exportForm.controls["EncodingDifFile"].setEnabledState(!this.checked); }
    }

    checkBox.parentTable.rows[0].cells[1].onclick = function () {
        if (this.checkBox.disabled) return;
        this.checkBox.checked = !this.checkBox.checked;
        checkBox.onclick();
    }
}