﻿
StiMvcViewer.prototype.InitializeExportDropDownList = function (dropDownList) {
    dropDownList.jsObject = this;
    dropDownList.parentTable = document.getElementById(dropDownList.id + "ParentTable");
    dropDownList.dropDownListName = dropDownList.parentTable.getAttribute("dropDownListName");

    dropDownList.exportForm = document.getElementById(this.options.mvcViewer.id + "ExportForm");
    if (!dropDownList.exportForm.controls) dropDownList.exportForm.controls = new Object();
    dropDownList.exportForm.controls[dropDownList.dropDownListName] = dropDownList;

    dropDownList.setEnabledState = function (state) {
        this.parentTable.className = state ? "stiEnabledExportControl" : "stiDisabledExportControl";
        this.disabled = !state
    }

    dropDownList.reset = function () {
        this.setEnabledState(this.parentTable.getAttribute("defaultEnabled") == "True");
        this.value = this.options[this.parentTable.getAttribute("defaultIndexItem")].value;

        //Exceptions
        if (this.exportForm.exportFormat == "SaveCsv" && this.dropDownListName == "EncodingTextOrCsvFile") { this.value = this.options[0].value; }
    }

    dropDownList.changeVisibleState = function (state) {
        this.parentTable.style.display = state ? "" : "none";
    }
}