﻿
StiMvcViewer.prototype.InitializeExportRadioButton = function (radioButton) {
    radioButton.jsObject = this;
    radioButton.parentTable = document.getElementById(radioButton.id + "ParentTable");
    radioButton.parentTable.rows[0].cells[1].radioButton = radioButton;
    radioButton.radioButtonName = radioButton.parentTable.getAttribute("radioButtonName");
    radioButton.groupName = radioButton.parentTable.getAttribute("groupName");

    radioButton.exportForm = document.getElementById(this.options.mvcViewer.id + "ExportForm");
    if (!radioButton.exportForm.controls) radioButton.exportForm.controls = new Object();
    radioButton.exportForm.controls[radioButton.radioButtonName] = radioButton;

    radioButton.setCheckedState = function (state) {
        if (state)
            for (var index in this.exportForm.controls) {
                groupName = this.exportForm.controls[index].groupName;
                if (groupName)
                    if (groupName == this.groupName) this.exportForm.controls[index].setCheckedState(false);
            }

        this.checked = state;
    }

    radioButton.setEnabledState = function (state) {
        this.parentTable.className = state ? "stiEnabledExportControl" : "stiDisabledExportControl";
        this.disabled = !state
        if (!state) this.setCheckedState(false);
    }

    radioButton.reset = function () {
        if (this.groupName != "PagesRange") {
            this.checked = this.parentTable.getAttribute("defaultChecked") == "True";
            this.setEnabledState(this.parentTable.getAttribute("defaultEnabled") == "True");
            if (this.radioButtonName == "Monochrome" && this.exportForm.exportFormat == "SaveImagePcx") this.setEnabledState(true);
        }
        else {
            imageFormats = ["SaveImageBmp", "SaveImageGif", "SaveImageJpeg", "SaveImagePcx", "SaveImagePng", "SaveImageTiff"];

            if (this.radioButtonName == "PagesRangeAll") {
                this.setEnabledState(!(this.jsObject.isContainted(imageFormats, this.exportForm.exportFormat) && this.exportForm.exportFormat != "SaveImageTiff")); 
                this.setCheckedState(!this.disabled);
            }
            if (this.radioButtonName == "PagesRangeCurrentPage") {
                this.setEnabledState(this.jsObject.options.menuViewMode == "OnePage");
                this.setCheckedState(!this.disabled && !this.exportForm.controls["PagesRangeAll"].checked);
            }
            if (this.radioButtonName == "PagesRangePages") {
                this.setEnabledState(true);
                if (!this.disabled && !this.exportForm.controls["PagesRangeAll"].checked && !this.exportForm.controls["PagesRangeCurrentPage"].checked)
                    this.onclick();
            }
        }
    }

    radioButton.changeVisibleState = function (state) {
        this.parentTable.style.display = state ? "" : "none";
    }

    radioButton.onclick = function () {
        this.setCheckedState(true);
        if (this.groupName == "PagesRange") {
            this.exportForm.controls["PagesRangePagesTextBox"].setEnabledState(this.radioButtonName == "PagesRangePages");
            this.exportForm.controls["PagesRangePagesTextBox"].value = "";
            if (this.radioButtonName == "PagesRangePages") this.exportForm.controls["PagesRangePagesTextBox"].focus();
        }
        if (this.groupName == "SaveReport") {
            this.exportForm.controls["PasswordSaveReport"].setEnabledState(this.radioButtonName == "SaveReportMdx");
            this.exportForm.controls["PasswordSaveReport"].value = "";
            if (this.radioButtonName == "SaveReportMdx") this.exportForm.controls["PasswordSaveReport"].focus();
        }
    }

    radioButton.parentTable.rows[0].cells[1].onclick = function () {
        if (this.radioButton.disabled) return;
        this.radioButton.setCheckedState(true);
        radioButton.onclick();
    }
}