﻿
StiMvcViewer.prototype.InitializeExportTextBox = function (textBox) {
    textBox.jsObject = this;
    textBox.parentTable = document.getElementById(textBox.id + "ParentTable");
    textBox.textBoxName = textBox.parentTable.getAttribute("textBoxName");

    textBox.exportForm = document.getElementById(this.options.mvcViewer.id + "ExportForm");
    if (!textBox.exportForm.controls) textBox.exportForm.controls = new Object();
    textBox.exportForm.controls[textBox.textBoxName] = textBox;

    textBox.setEnabledState = function (state) {
        this.parentTable.className = state ? "stiEnabledExportControl" : "stiDisabledExportControl";
        this.disabled = !state;
    }

    textBox.reset = function () {
        this.value = this.parentTable.getAttribute("defaultValue");
        this.setEnabledState(this.parentTable.getAttribute("defaultEnabled") == "True");
    }

    textBox.changeVisibleState = function (state) {
        this.parentTable.style.display = state ? "" : "none";
    }
}