﻿
StiMvcViewer.prototype.InitializeForm = function (form) {
    form.jsObject = this;
    form.formName = form.getAttribute("formName");
    this.options.forms[form.formName] = form;
    form.header = document.getElementById(form.id + "Header");
    form.disabledPanel = document.getElementById(form.id + "DisabledPanel");
    form.viewerDisabledPanel = document.getElementById(this.options.mvcViewer.id + "DisabledPanel");
    form.header.thisForm = form;
    form.inDrag = false;
    form.exportFormat = null;

    form.show = function () {
        if (this.formName == "ExportForm") this.resetControls();
        else this.jsObject.options.forms["ExportForm"].setEnabled(false);
        //this.style.display = "";
        this.setPosition();
        this.viewerDisabledPanel.style.display = "";
    }

    form.hide = function () {
        this.style.display = "none";
        this.jsObject.options.forms["ExportForm"].setEnabled(true);
        if (this.formName == "ExportForm") {
            this.jsObject.options.forms["DigitalSignatureForm"].hide();
            this.jsObject.options.forms["DocumentSecurityForm"].hide();
            this.viewerDisabledPanel.style.display = "none";
        }
    }

    form.setEnabled = function (state) {
        this.disabledPanel.style.display = !state ? "" : "none";
    }

    form.resetControls = function () {
        controls = this.jsObject.options.forms["ExportForm"].controls;
        exportFormatControlsString = this.jsObject.options.forms["ExportForm"].getAttribute(this.jsObject.options.forms["ExportForm"].exportFormat);
        exportFormatControls = exportFormatControlsString ? exportFormatControlsString.split(",") : [];

        for (var controlName in controls) {
            controls[controlName].changeVisibleState(this.jsObject.isContainted(exportFormatControls, controlName))
            if ("reset" in controls[controlName]) {
                if (this.formName != "ExportForm") {
                    formControls = this.getAttribute("ControlsCollection").split(",");
                    if (this.jsObject.isContainted(formControls, controlName)) controls[controlName].reset();
                }
                else {
                    controls[controlName].reset();
                }
            }
        }
    }

    form.setPosition = function () {
        var left, top;
        if (this.formName == "ExportForm") {
            body = document.getElementsByTagName('BODY')[0];
            scrollTop = document.documentElement.scrollTop == 0 ? body.scrollTop : document.documentElement.scrollTop;
            scrollLeft = document.documentElement.scrollLeft == 0 ? body.scrollLeft : document.documentElement.scrollLeft;
            documentHeight = document.documentElement.clientHeight == 0 ? body.clientHeight : document.documentElement.clientHeight;
            documentWidth = document.documentElement.clientWidth == 0 ? body.clientWidth : document.documentElement.clientWidth;
            this.style.left = (scrollLeft + documentWidth / 2 - this.offsetWidth / 2) + "px";
            this.style.top = (scrollTop + documentHeight / 2 - this.offsetHeight / 2) + "px";
        }
        else {
            this.style.left = (this.jsObject.options.forms["ExportForm"].offsetLeft + 70) + "px";
            this.style.top = (this.jsObject.options.forms["ExportForm"].offsetTop + 70) + "px";
        }
    }

    //Mouse Events
    form.header.onmousedown = function (event) {
        if (!event) return;
        form = this.thisForm;
        document.onmouseup = function () { form.inDrag = false };
        document.onmousemove = function (event) { form.move(form, event); };
        mouseStartX = event.clientX;
        mouseStartY = event.clientY;
        formStartX = this.thisForm.jsObject.FindPosX(this.thisForm, "stiMainPanel");
        formStartY = this.thisForm.jsObject.FindPosY(this.thisForm, "stiMainPanel");
        this.thisForm.inDrag = [mouseStartX, mouseStartY, formStartX, formStartY];
    }

    form.move = function (form, evnt) {
        if (!form.isDisable) {
            mouseCurrentX = evnt.clientX;
            mouseCurrentY = evnt.clientY;
            form.style.left = form.inDrag[2] + (mouseCurrentX - form.inDrag[0]) + "px";
            form.style.top = form.inDrag[3] + (mouseCurrentY - form.inDrag[1]) + "px";
        }
    }

    form.applySettings = function () {
        this.hide();
        controls = this.jsObject.options.forms["ExportForm"].controls;

        settings = {};
        settings["PagesRange"] = controls["PagesRangeAll"].checked
            ? "All"
            : (controls["PagesRangeCurrentPage"].checked ? this.jsObject.options.pageNumber + 1 : controls["PagesRangePagesTextBox"].value);
        settings["SaveReportFormat"] = controls["SaveReportMdc"].checked ? "Mdc" : (controls["SaveReportMdz"].checked ? "Mdz" : "Mdx");
        settings["SaveReportPassword"] = controls["PasswordSaveReport"].value;
        settings["AddPageBreaks"] = controls["AddPageBreaks"].getValue();
        settings["Zoom"] = controls["Zoom_"].value;
        settings["ImageFormat"] = controls["ImageFormat"].value;
        settings["ExportMode"] = controls["ExportMode"].value;
        settings["ImageResolution"] = controls["ImageResolution"].value;
        settings["ImageCompressionMethod"] = controls["ImageCompressionMethod"].value;
        settings["ImageQuality"] = controls["ImageQuality"].value;
        settings["ContinuousPages"] = controls["ContinuousPages"].getValue();
        settings["StandardPDFFonts"] = controls["StandardPDFFonts"].getValue();
        settings["EmbeddedFonts"] = controls["EmbeddedFonts"].getValue();
        settings["UseUnicode"] = controls["UseUnicode"].getValue();
        settings["Compressed"] = controls["Compressed"].getValue();
        settings["ExportRtfTextAsImage"] = controls["ExportRtfTextAsImage"].getValue();
        settings["PdfACompliance"] = controls["PdfACompliance"].getValue();
        settings["TxtKillSpaceLines"] = controls["KillSpaceLines"].getValue();
        settings["TxtPutFeedPageCode"] = controls["PutFeedPageCode"].getValue();
        settings["TxtDrawBorder"] = controls["DrawBorder"].getValue();
        settings["TxtCutLongLines"] = controls["CutLongLines"].getValue();
        settings["TxtBorderType"] = controls["Simple"].checked ? "Simple" : (controls["UnicodeSingle"].checked ? "UnicodeSingle" : "UnicodeDouble");
        settings["ZoomX"] = controls["ZoomX"].value;
        settings["ZoomY"] = controls["ZoomY"].value;
        settings["Encoding"] = controls["EncodingTextOrCsvFile"].value;
        settings["EncodingValue"] = controls["EncodingDifFile"].value;
        settings["CodePage"] = controls["EncodingDbfFile"].value;
        settings["ImageCutEdges"] = controls["CutEdges"].getValue();
        settings["MultipleFiles"] = controls["MultipleFiles"].getValue();
        settings["ImageType"] = controls["Color"].checked ? "Color" : (controls["Grayscale"].checked ? "Grayscale" : "Monochrome");
        settings["ExportDataOnly"] = controls["ExportDataOnly"].getValue();
        settings["UseDefaultSystemEncoding"] = controls["UseDefaultSystemEncoding"].getValue();
        settings["RtfExportMode"] = controls["Table"].checked ? "Table" : "Frame";
        settings["UsePageHeadersAndFooters"] = controls["UsePageHeadersFooters"].getValue();
        settings["RemoveEmptySpace"] = controls["RemoveEmptySpace"].getValue();
        settings["Separator"] = controls["Separator"].value;
        settings["SkipColumnHeaders"] = controls["SkipColumnHeaders"].getValue();
        settings["ExportObjectFormatting"] = controls["ExportObjectFormatting"].getValue();
        settings["UseOnePageHeaderAndFooter"] = controls["UseOnePageHeaderFooter"].getValue();
        settings["ExportEachPageToSheet"] = controls["ExportEachPageToSheet"].getValue();
        settings["ExportPageBreaks"] = controls["ExportPageBreaks"].getValue();
        settings["OpenAfterExport"] = controls["OpenAfterExport"].getValue();

        settings["DigitalSignature"] = {};
        settings["DigitalSignature"]["UseDigitalSignature"] = controls["UseDigitalSignature"].getValue();
        settings["DigitalSignature"]["GetCertificateFromCryptoUI"] = controls["GetCertificateFromCryptoUI"].getValue();
        settings["DigitalSignature"]["SubjectNameString"] = controls["SubjectNameString"].value;

        settings["DocumentSecurity"] = {};
        settings["DocumentSecurity"]["UserPassword"] = controls["UserPassword"].value;
        settings["DocumentSecurity"]["OwnerPassword"] = controls["OwnerPassword"].value;
        settings["DocumentSecurity"]["AllowPrintDocument"] = controls["AllowPrintDocument"].getValue();
        settings["DocumentSecurity"]["AllowModifyContents"] = controls["AllowModifyContents"].getValue();
        settings["DocumentSecurity"]["AllowCopyTextAndGraphics"] = controls["AllowCopyTextAndGraphics"].getValue();
        settings["DocumentSecurity"]["AllowAddOrModifyTextAnnotations"] = controls["AllowAddOrModifyTextAnnotations"].getValue();
        settings["DocumentSecurity"]["EncryptionKeyLength"] = controls["EncryptionKeyLength"].value;

        return settings;
    }
}