﻿
StiMvcViewer.prototype.InitializeMenu = function (menu) {
    menu.jsObject = this;
    menu.menuName = menu.getAttribute("menuName");
    menu.headerTriangle = document.getElementById(menu.id + "HeaderTriangle");
    menu.itemsPanel = document.getElementById(menu.id + "ItemsPanel");
    menu.itemsTable = document.getElementById(menu.id + "ItemsTable");
    menu.itemsPanel.thisMenu = menu;
    menu.scrollBar = document.getElementById(menu.id + "ScrollBar");
    menu.scrollBarButton = document.getElementById(menu.id + "ScrollBarButton");

    //Show
    menu.show = function () {
        var html = document.getElementsByTagName("HTML")[0];
        var body = document.getElementsByTagName("body")[0];
        var htmlScrollWidthBefore = html.scrollWidth;
        var bodyScrollWidthBefore = body.scrollWidth;
        if (this.jsObject.options.currentMenu != null && this.jsObject.options.currentMenu != this) this.jsObject.options.currentMenu.hide();
        this.jsObject.options.currentMenu = this;
        this.style.display = "";
        this.parentButton.setSelected(true);

        this.headerTriangle.style.left = (this.jsObject.options.rightToLeft ? this.offsetWidth - 55 : 15) + "px";
        this.style.left = (this.jsObject.options.rightToLeft)
                ? (this.jsObject.FindPosX(this.parentButton, "stiToolBarInnerContent") - this.jsObject.options.toolbar.scrollLeft - this.offsetWidth +
                    (this.jsObject.options.theme != "Office2013" ? (42 + this.parentButton.offsetWidth / 2) : (5 + this.parentButton.offsetWidth))) + "px"
                : (this.jsObject.FindPosX(this.parentButton, "stiToolBarInnerContent") - this.jsObject.options.toolbar.scrollLeft +
                    (this.jsObject.options.theme != "Office2013" ? (this.parentButton.offsetWidth / 2 - 30) : 5)) + "px";
        this.style.top = (this.jsObject.FindPosY(this.parentButton, "stiToolBarInnerContent") + this.parentButton.offsetHeight +
            (this.jsObject.options.theme != "Office2013" ? 16 : 7)) + "px";
        this.itemsPanel.style.marginRight = (this.menuName == "SaveMenu" && this.jsObject.options.isTouchDevice) ? "8px" : "0px";
        this.scrollBar.style.display = (this.menuName == "SaveMenu" && this.jsObject.options.isTouchDevice) ? "" : "none";
        this.updateScrollBar();
        var deltaWidth = 0;
        if (html.scrollWidth) deltaWidth = html.scrollWidth - htmlScrollWidthBefore;
        if (body.scrollWidth && deltaWidth == 0) deltaWidth = body.scrollWidth - bodyScrollWidthBefore;
        if (deltaWidth != 0 && !this.jsObject.options.rightToLeft) this.moveTo(deltaWidth);
    }

    menu.moveTo = function (px) {
        this.style.left = (this.jsObject.FindPosX(this.parentButton, "stiToolBarInnerContent") - this.jsObject.options.toolbar.scrollLeft +
            (this.jsObject.options.theme != "Office2013" ? (this.parentButton.offsetWidth / 2 - 30) : 5) - px) + "px";
        if (this.jsObject.options.theme != "Office2013") this.headerTriangle.style.left = (15 + px) + "px";
    }

    //Hide
    menu.hide = function () {
        this.style.display = "none";
        this.jsObject.options.currentMenu = null;
        this.parentButton.setSelected(false);
    }

    menu.onmousedown = function () {
        if (this.jsObject.options.isTouchDevice) return;
        this.jsObject.options.buttonWasPressed = true;
    }

    menu.ontouchstart = function () {
        this.jsObject.options.buttonWasPressed = true;
    }

    menu.updateScrollBar = function () {
        this.scrollBarButton.style.top = ((this.itemsPanel.scrollTop / this.itemsTable.offsetHeight) * this.scrollBar.offsetHeight) + "px";
        this.scrollBarButton.style.height = this.scrollBar.offsetHeight / (this.itemsTable.offsetHeight / this.scrollBar.offsetHeight) + "px";
    }

    menu.itemsPanel.ontouchmove = function () { this.thisMenu.updateScrollBar(); }
    menu.itemsPanel.onscroll = function () { this.thisMenu.updateScrollBar(); }
}