﻿
//Button
StiMvcViewer.prototype.parameterButton = function (buttonType, parameter) {
    button = document.createElement("Div");
    button.parameter = parameter;
    button.buttonType = buttonType;
    button.isDisable = false;
    button.isOver = false;

    button.style.height = "38px";
    button.style.width = "38px";
    button.style.textAlign = "center";
    button.className = "stiParametersButton";

    image = document.createElement("Div");
    image.style.height = "20px";
    image.style.width = "20px";
    image.style.margin = "9px 0 0 9px";
    image.className = "sti" + buttonType + "Image";
    button.appendChild(image);
    button.img = image;

    button.setEnabledState = function (state) {
        this.isDisable = !state;
        this.className = "stiParametersButton" + (state ? "" : "Disabled");
        this.img.className = "sti" + buttonType + "Image" + (state ? "" : "Disabled");
    }

    button.onmouseover = function () {
        if (this.isDisable || this.parameter.jsObject.options.isTouchDevice) return;
        this.className = "stiParametersButtonOver";
        this.isOver = true;
    }

    button.onmouseout = function () {
        if (this.isDisable || this.parameter.jsObject.options.isTouchDevice) return;
        this.className = "stiParametersButton"
        this.isOver = false;
    }

    button.onmousedown = function () {
        if (this.parameter.jsObject.options.isTouchDevice || this.isDisable) return;
        this.className = "stiPressedButton";
        if (this.buttonType == "DropDownButton") this.parameter.jsObject.options.parametersPanel.dropDownButtonWasClicked = true;
        if (this.buttonType == "DateTimeButton") this.parameter.jsObject.options.parametersPanel.dateTimeButtonWasClicked = true;
    }

    button.ontouchstart = function () {
        if (this.isDisable) return;
        this.parameter.jsObject.options.fingerIsMoved = false;
        if (this.buttonType == "DropDownButton") this.parameter.jsObject.options.parametersPanel.dropDownButtonWasClicked = true;
        if (this.buttonType == "DateTimeButton") this.parameter.jsObject.options.parametersPanel.dateTimeButtonWasClicked = true;        
    }

    button.onmouseup = function () {
        if (this.isDisable) return;
        if (this.parameter.jsObject.options.isTouchDevice || this.isDisable) return;
        this.parameter.jsObject.TouchEndParametersButton(this, false);
    }

    button.ontouchend = function () {
        if (this.isDisable) return;
        this.parameter.jsObject.TouchEndParametersButton(this, true);
    }

    return button;
}

StiMvcViewer.prototype.TouchEndParametersButton = function (button, flag) {
    if (button.parameter.jsObject.options.fingerIsMoved || button.isDisable) return;
    //debugger;
    if (flag) {
        button.className = "stiPressedButton";
        if ('preventDefault' in event) event.preventDefault();
        setTimeout("js" + button.parameter.jsObject.options.mvcViewer.id + ".TouchEndParametersButton(" + button.id + ", false)", 200);
        return;
    }

    button.className = button.isOver ? "stiParametersButtonOver" : "stiParametersButton";
    button.action();
}

//TextBox
StiMvcViewer.prototype.parameterTextBox = function (parameter) {
    textBox = document.createElement("Input");
    textBox.className = "stiParametersTextBoxes";
    textBox.parameter = parameter;

    if (parameter.params.type == "Char") textBox.maxLength = 1;

    if (textBox.parameter.basicType == "Range") {
        textBox.style.width = "140px";
        if (textBox.parameter.type == "Guid" || textBox.parameter.type == "String") textBox.style.width = "190px";
        if (textBox.parameter.type == "DateTime") textBox.style.width = "160px";
        if (textBox.parameter.type == "Char") textBox.style.width = "60px";
    }
    else {
        if (textBox.parameter.type == "Guid") textBox.style.width = "265px"; else textBox.style.width = "210px";
    }

    textBox.setEnabledState = function (state) {
        this.disabled = !state;
    }

    textBox.setReadOnlyState = function (state) {
        this.readOnly = state;
        this.className = state ? "stiParametersTextBoxesReadOnly" : "stiParametersTextBoxes";
        this.setAttribute("unselectable", state ? "on" : "off");
        this.setAttribute("onselectstart", state ? "return false" : "");
    }

    return textBox;
}

//CheckBox
StiMvcViewer.prototype.parameterCheckBox = function (parameter) {
    checkBox = document.createElement("Div");
    checkBox.checked = false;
    checkBox.isDisable = false;
    checkBox.className = "stiParametersCheckBoxIsNotChecked";
    checkBox.parameter = parameter;

    checkBox.onchecked = function () { return; }

    checkBox.pressed = function () {
        if (this.isDisable) return;
        this.checked = !this.checked;
        this.className = this.checked ? "stiParametersCheckBoxIsChecked" : "stiParametersCheckBoxIsNotChecked";
        this.onchecked();
    }

    checkBox.onmousedown = function () { if (!this.parameter.jsObject.options.isTouchDevice) this.pressed(); }
    checkBox.ontouchstart = function () { this.pressed(); }

    checkBox.setChecked = function (state) {
        this.checked = state;
        this.className = !this.isDisable
            ? (state ? "stiParametersCheckBoxIsChecked" : "stiParametersCheckBoxIsNotChecked")
            : (state ? "stiParametersCheckBoxIsCheckedDisabled" : "stiParametersCheckBoxIsNotCheckedDisabled")
    }

    checkBox.setEnabledState = function (state) {
        this.isDisable = !state;
        this.className = this.checked
            ? (state ? "stiParametersCheckBoxIsChecked" : "stiParametersCheckBoxIsCheckedDisabled")
            : (state ? "stiParametersCheckBoxIsNotChecked" : "stiParametersCheckBoxIsNotCheckedDisabled")
    }

    return checkBox;
}