﻿
//Menu
StiMvcViewer.prototype.parameterMenu = function (parameter) {
    menuParent = document.createElement("Div");
    menuParent.className = "stiParametersMenu";
    menuParent.parameter = parameter;

    table = document.createElement("Table");
    table.style.width = (parameter.offsetWidth - 5) + "px";
    table.className = "stiParametersMenuInnerTable";
    menuParent.appendChild(table);
    table.cellPadding = 0;
    table.cellSpacing = 0;
    tbody = document.createElement("TBODY");
    table.appendChild(tbody);
    menuParent.innerTable = tbody;

    menuParent.onmousedown = function () {
        this.parameter.jsObject.options.parametersPanel.dropDownButtonWasClicked = true;
    }

    menuParent.ontouchstart = function () {
        this.parameter.jsObject.options.parametersPanel.dropDownButtonWasClicked = true;
    }

    return menuParent;
}

//MenuItem
StiMvcViewer.prototype.parameterMenuItem = function (parameter) {
    menuItem = document.createElement("Div");
    menuItem.parameter = parameter;    
    menuItem.isOver = false;
    menuItem.className = "stiParametersMenuItem";

    table = document.createElement("Table");
    table.className = "stiInnerTable";
    menuItem.appendChild(table);
    table.cellPadding = 0;
    table.cellSpacing = 0;
    tbody = document.createElement("TBODY");
    table.appendChild(tbody);
    row = document.createElement("TR");
    tbody.appendChild(row);

    menuItem.onmouseover = function () {
        if (!this.parameter.jsObject.options.isTouchDevice) {
            this.className = "stiParametersMenuItemOver";
            this.isOver = true;
        }
    }
    menuItem.onmouseout = function () {
        if (!this.parameter.jsObject.options.isTouchDevice) {
            this.className = "stiParametersMenuItem";
            this.isOver = false;
        }
    }

    menuItem.onmousedown = function () {
        if (this.parameter.jsObject.options.isTouchDevice) return;
        this.className = "stiParametersMenuItemPressed";
    }

    menuItem.ontouchstart = function () {
        this.parameter.jsObject.options.fingerIsMoved = false;
    }

    menuItem.onmouseup = function () {
        if (this.parameter.jsObject.options.isTouchDevice) return;
        this.parameter.jsObject.TouchEndMenuItem(this, false);
    }

    menuItem.ontouchend = function () {
        this.parameter.jsObject.TouchEndMenuItem(this, true);
    }

    cellItem = document.createElement("TD");
    cellItem.style.padding = "0 5px 0 5px";
    menuItem.innerContainer = cellItem;
    row.appendChild(cellItem);

    return menuItem;
}

StiMvcViewer.prototype.TouchEndMenuItem = function (menuItem, flag) {
    if (menuItem.parameter.jsObject.options.fingerIsMoved) return;

    if (flag) {
        menuItem.className = "stiParametersMenuItemPressed";
        if ('preventDefault' in event) event.preventDefault();
        setTimeout("js" + menuItem.parameter.jsObject.options.mvcViewer.id + ".TouchEndMenuItem(" + menuItem.id + ", false)", 200);
        return;
    }

    menuItem.className = menuItem.isOver ? "stiParametersMenuItemOver" : "stiParametersMenuItem";
    if (menuItem.action != null) menuItem.action();
}

//MenuSeparator
StiMvcViewer.prototype.parameterMenuSeparator = function () {
    separator = document.createElement("Div");
    separator.className = "stiParametersMenuSeparator";

    return separator;
}

//Menu For Value
StiMvcViewer.prototype.parameterMenuForValue = function (parameter) {
    menuParent = this.parameterMenu(parameter);

    for (var index in parameter.params.items) {
        row = document.createElement("TR");
        menuParent.innerTable.appendChild(row);
        cell = document.createElement("TD");
        cell.style.border = "0px";
        cell.style.padding = "0px";
        row.appendChild(cell);

        menuItem = this.parameterMenuItem(parameter);
        cell.appendChild(menuItem);
        menuItem.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "Item" + index;
        menuItem.parameter = parameter;
        menuItem.key = parameter.params.items[index].key;
        menuItem.value = parameter.params.items[index].value;
        menuItem.innerContainer.innerHTML =
            (menuItem.value != "" && parameter.params.type != "DateTime" && parameter.params.type != "TimeSpan" && parameter.params.type != "Bool")
                ? menuItem.value
                : this.getStringKey(menuItem.key, menuItem.parameter);

        menuItem.action = function () {
            this.parameter.params.key = this.key;
            if (this.parameter.params.type != "Bool")
                this.parameter.controls.firstTextBox.value =
                    (this.parameter.params.type == "DateTime" || this.parameter.params.type == "TimeSpan")
                        ? this.parameter.jsObject.getStringKey(this.key, this.parameter)
                        : (this.parameter.params.allowUserValues ? this.key : (this.value != "" ? this.value : this.key));
            else
                this.parameter.controls.boolCheckBox.setChecked(this.key == "True");

            this.parameter.changeVisibleStateMenu(false);
        }
    }

    return menuParent;
}

//Menu For Range
StiMvcViewer.prototype.parameterMenuForRange = function (parameter) {
    menuParent = this.parameterMenu(parameter);

    for (var index in parameter.params.items) {
        row = document.createElement("TR");
        menuParent.innerTable.appendChild(row);
        cell = document.createElement("TD");
        cell.style.border = "0px";
        cell.style.padding = "0px";
        row.appendChild(cell);

        menuItem = this.parameterMenuItem(parameter);
        cell.appendChild(menuItem);
        menuItem.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "Item" + index;
        menuItem.parameter = parameter;
        menuItem.value = parameter.params.items[index].value;
        menuItem.key = parameter.params.items[index].key;
        menuItem.keyTo = parameter.params.items[index].keyTo;
        menuItem.innerContainer.innerHTML = menuItem.value + " [" + this.getStringKey(menuItem.key, menuItem.parameter) +
            " - " + this.getStringKey(menuItem.keyTo, menuItem.parameter) + "]";

        menuItem.action = function () {
            this.parameter.params.key = this.key;
            this.parameter.params.keyTo = this.keyTo;            
            this.parameter.controls.firstTextBox.value = this.parameter.jsObject.getStringKey(this.key, this.parameter);
            this.parameter.controls.secondTextBox.value = this.parameter.jsObject.getStringKey(this.keyTo, this.parameter);
            this.parameter.changeVisibleStateMenu(false);
        }
    }

    return menuParent;
}

//Menu For ListNotEdit
StiMvcViewer.prototype.parameterMenuForNotEditList = function (parameter) {
    menuParent = this.parameterMenu(parameter);
    menuParent.menuItems = {};

    for (var index in parameter.params.items) {
        row = document.createElement("TR");
        menuParent.innerTable.appendChild(row);
        cell = document.createElement("TD");
        cell.style.border = "0px";
        cell.style.padding = "0px";
        row.appendChild(cell);

        menuItem = this.parameterMenuItem(parameter);
        cell.appendChild(menuItem);
        menuItem.action = null;
        menuItem.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "Item" + index;
        menuItem.parameter = parameter;
        menuItem.value = parameter.params.items[index].value;
        menuItem.key = parameter.params.items[index].key;
        menuParent.menuItems[index] = menuItem;

        innerTable = document.createElement("Table");
        menuItem.innerContainer.appendChild(innerTable);
        innerTableBody = document.createElement("Tbody");
        innerTable.appendChild(innerTableBody);
        innerRow = document.createElement("TR");
        innerTableBody.appendChild(innerRow);
        cellCheck = document.createElement("TD");
        innerRow.appendChild(cellCheck);

        checkBox = this.parameterCheckBox(parameter); ;
        cellCheck.appendChild(checkBox);
        checkBox.menuParent = menuParent;
        checkBox.setChecked(parameter.params.items[index].isChecked);
        menuItem.checkBox = checkBox;

        checkBox.onchecked = function () {
            this.parameter.params.items = {};
            this.parameter.controls.firstTextBox.value = "";

            for (var index in this.menuParent.menuItems) {
                this.parameter.params.items[index] = {};
                this.parameter.params.items[index].key = this.menuParent.menuItems[index].key;
                this.parameter.params.items[index].value = this.menuParent.menuItems[index].value;
                this.parameter.params.items[index].isChecked = this.menuParent.menuItems[index].checkBox.checked;

                if (this.parameter.params.items[index].isChecked) {
                    if (this.parameter.controls.firstTextBox.value != "") this.parameter.controls.firstTextBox.value += ";";
                    this.parameter.controls.firstTextBox.value += this.menuParent.menuItems[index].value != "" ? this.menuParent.menuItems[index].value : this.parameter.jsObject.getStringKey(this.menuParent.menuItems[index].key, this.parameter);
                }
            }
        }

        cellText = document.createElement("TD");
        cellText.style.whiteSpace = "nowrap";
        innerRow.appendChild(cellText);        
        cellText.innerHTML = menuItem.value != "" ? menuItem.value : this.getStringKey(menuItem.key, menuItem.parameter);

        if (index == this.getCountObjects(parameter.params.items) - 1) {
            closeButton = this.parameterMenuItem(parameter);
            closeButton.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "ItemClose";
            closeButton.innerContainer.innerHTML = this.options.parametersPanel.getAttribute("Word_Close");
            closeButton.action = function () { this.parameter.changeVisibleStateMenu(false); }
            cell.appendChild(this.parameterMenuSeparator());
            cell.appendChild(closeButton);
        }
    }

    return menuParent;
}

//Menu For ListEdit
StiMvcViewer.prototype.parameterMenuForEditList = function (parameter) {
    menuParent = this.parameterMenu(parameter);

    //New Item Method
    menuParent.newItem = function (item, parameter) {
        menuItem = parameter.jsObject.parameterMenuItem(parameter);
        cell.appendChild(menuItem);
        menuItem.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "Item" + parameter.jsObject.newGuid().replace(/-/g, '');
        menuItem.onmouseover = null;
        menuItem.onmousedown = null;
        menuItem.ontouchend = null;
        menuItem.action = null;
        menuItem.parameter = parameter;
        menuItem.value = item.value;
        menuItem.key = item.key;

        innerTable = document.createElement("Table");
        menuItem.innerContainer.appendChild(innerTable);
        innerTableBody = document.createElement("Tbody");
        innerTable.appendChild(innerTableBody);
        innerRow = document.createElement("TR");
        innerTableBody.appendChild(innerRow);

        //Text Box
        cellTextBox = document.createElement("TD");
        cellTextBox.style.padding = "0 1px 0 0";
        innerRow.appendChild(cellTextBox);
        textBox = parameter.jsObject.parameterTextBox(parameter);
        textBox.thisMenu = menuParent;
        cellTextBox.appendChild(textBox);
        menuItem.textBox = textBox;
        textBox.setReadOnlyState(parameter.params.type == "DateTime");
        textBox.value = parameter.jsObject.getStringKey(menuItem.key, menuItem.parameter);

        //DateTime Button
        if (parameter.params.type == "DateTime") {
            cellForDatePicker = document.createElement("TD");
            cellForDatePicker.style.padding = "0px";
            cellForDatePicker.style.position = "absolute";
            innerRow.appendChild(cellForDatePicker);

            cellDateTimeButton = document.createElement("TD");
            cellDateTimeButton.style.padding = "0 1px 0 1px";
            innerRow.appendChild(cellDateTimeButton);
            dateTimeButton = parameter.jsObject.parameterButton("DateTimeButton", parameter);
            dateTimeButton.id = menuItem.id + "DateTimeButton";
            dateTimeButton.datePickerCell = cellForDatePicker;
            dateTimeButton.parameter = parameter;
            dateTimeButton.thisItem = menuItem;
            cellDateTimeButton.appendChild(dateTimeButton);

            dateTimeButton.action = function () {
                this.parameter.jsObject.options.parametersPanel.appendChild(this.parameter.jsObject.options.datePicker);
                this.parameter.jsObject.options.datePicker.show(this.thisItem.key, this.thisItem.textBox);
                this.parameter.jsObject.options.datePicker.style.top =
                    (41 + this.parameter.jsObject.FindPosY(this, "stiParametersPanel") - this.parameter.menu.scrollTop) + "px";
                this.parameter.jsObject.options.datePicker.style.left =
                    (42 + this.parameter.jsObject.FindPosX(this, "stiParametersPanel") - this.parameter.jsObject.options.datePicker.offsetWidth) + "px";
            }
        }

        //Guid Button
        if (parameter.params.type == "Guid") {
            cellGuidButton = document.createElement("TD");
            cellGuidButton.style.padding = "0 1px 0 1px";
            innerRow.appendChild(cellGuidButton);
            guidButton = parameter.jsObject.parameterButton("GuidButton", parameter);
            guidButton.id = menuItem.id + "GuidButton";
            guidButton.thisItem = menuItem;
            guidButton.thisMenu = menuParent;
            cellGuidButton.appendChild(guidButton);

            guidButton.action = function () {
                this.thisItem.textBox.value = this.parameter.jsObject.newGuid();
                this.thisMenu.updateItems();
            }
        }

        //Remove Button
        cellRemoveButton = document.createElement("TD");
        cellRemoveButton.style.padding = "0 1px 0 1px";
        innerRow.appendChild(cellRemoveButton);
        removeButton = parameter.jsObject.parameterButton("RemoveItemButton", parameter);
        removeButton.id = menuItem.id + "RemoveButton";
        removeButton.itemsContainer = this.itemsContainer;
        removeButton.thisItem = menuItem;
        removeButton.thisMenu = menuParent;
        cellRemoveButton.appendChild(removeButton);
        removeButton.action = function () {
            this.itemsContainer.removeChild(this.thisItem);
            this.thisMenu.updateItems();
        }

        return menuItem;
    }

    //Update Items
    menuParent.updateItems = function () {
        this.parameter.params.items = {};
        this.parameter.controls.firstTextBox.value = "";
        for (index = 0; index < this.itemsContainer.childNodes.length; index++) {
            itemMenu = this.itemsContainer.childNodes[index];
            this.parameter.params.items[index] = {};
            this.parameter.params.items[index].key =
                (this.parameter.params.type == "DateTime" || this.parameter.params.type == "TimeSpan")
                ? itemMenu.key
                : itemMenu.textBox.value;
            this.parameter.params.items[index].value = itemMenu.value;
            if (this.parameter.controls.firstTextBox.value != "") this.parameter.controls.firstTextBox.value += ";";
            this.parameter.controls.firstTextBox.value += this.parameter.jsObject.getStringKey(this.parameter.params.items[index].key, this.parameter);
        }

        if (this.parameter.menu.innerTable.offsetHeight > 400) this.parameter.menu.style.height = "350px;"
        else this.parameter.menu.style.height = this.parameter.menu.innerTable.offsetHeight + "px";
    }

    rowUp = document.createElement("TR");
    menuParent.innerTable.appendChild(rowUp);
    cellUp = document.createElement("TD");
    rowUp.appendChild(cellUp);

    //New Item Button
    newItemButton = this.parameterMenuItem(parameter);
    cellUp.appendChild(newItemButton);
    newItemButton.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "ItemNew";
    newItemButton.innerContainer.innerHTML = this.options.parametersPanel.getAttribute("Word_NewItem");
    newItemButton.thisMenu = menuParent;
    newItemButton.action = function () {
        item = {};
        if (this.parameter.params.type == "DateTime") {
            item.key = this.parameter.jsObject.getNowDateTimeObject();
            item.value = this.parameter.jsObject.dateTimeObjectToString(item.key, this.parameter);
        }
        else {
            if (this.parameter.params.type == "Bool") {
                item.key = "False";
                item.value = "False";
            }
            else {
                item.key = "";
                item.value = "";
            }
        }
        newItem = this.thisMenu.newItem(item, this.parameter);
        this.thisMenu.itemsContainer.appendChild(newItem);
        if ("textBox" in newItem) newItem.textBox.focus();
        this.thisMenu.updateItems();
    }

    //Add Items
    rowItems = document.createElement("TR");
    menuParent.innerTable.appendChild(rowItems);
    cellItems = document.createElement("TD");
    rowItems.appendChild(cellItems);
    menuParent.itemsContainer = cellItems;

    for (var index in parameter.params.items) {
        cellItems.appendChild(menuParent.newItem(parameter.params.items[index], parameter));
    }

    rowDown = document.createElement("TR");
    menuParent.innerTable.appendChild(rowDown);
    cellDown = document.createElement("TD");
    rowDown.appendChild(cellDown);

    //Remove All Button
    removeAllButton = this.parameterMenuItem(parameter);
    cellDown.appendChild(removeAllButton);
    removeAllButton.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "ItemRemoveAll";
    removeAllButton.innerContainer.innerHTML = this.options.parametersPanel.getAttribute("Word_RemoveAll"); ;
    removeAllButton.thisMenu = menuParent;
    removeAllButton.action = function () {
        while (this.thisMenu.itemsContainer.childNodes[0]) {
            this.thisMenu.itemsContainer.removeChild(this.thisMenu.itemsContainer.childNodes[0]);
        }
        this.thisMenu.updateItems();
    }

    //Close Button
    cellDown.appendChild(this.parameterMenuSeparator());
    closeButton = this.parameterMenuItem(parameter);
    cellDown.appendChild(closeButton);
    closeButton.id = parameter.jsObject.options.mvcViewer.id + parameter.params.name + "ItemClose";
    closeButton.innerContainer.innerHTML = this.options.parametersPanel.getAttribute("Word_Close"); ;
    closeButton.action = function () { this.parameter.changeVisibleStateMenu(false); }

    return menuParent;
}