﻿
StiMvcViewer.prototype.InitializeReportPanel = function (reportPanel) {
    reportPanel.jsObject = this;
    this.options.reportPanel = reportPanel;

    reportPanel.addPage = function (pageContent, pageIndex) {
        var page = document.createElement("DIV");
        reportPanel.appendChild(page);
        var pageSizes = this.jsObject.options.pageSizes[pageIndex];
        var marginsPx = this.jsObject.options.pageMargins[pageIndex].split(" ");
        var margins = [];
        for (var i in marginsPx) {
            margins.push(parseInt(marginsPx[i].replace("px", "")));
        }

        page.pageWidth = parseInt(pageSizes.width);
        page.pageHeight = parseInt(pageSizes.height);
        this.jsObject.options.pagesWidth = page.pageWidth;
        this.jsObject.options.pagesHeight = page.pageHeight;
        page.style.minWidth = (page.pageWidth - margins[1] - margins[3]) + "px";
        page.style.overflow = "hidden";
        page.style.margin = "10px";
        page.style.display = "inline-block";
        page.style.verticalAlign = "top";
        page.style.padding = this.jsObject.options.pageMargins[pageIndex];
        if (this.jsObject.options.pageBorderColor) page.style.border = "1px solid " + this.jsObject.options.pageBorderColor;
        page.style.color = "#000000";
        page.style.background = this.jsObject.options.pageBackgrounds[pageIndex];
        page.innerHTML = pageContent;
    }

    reportPanel.clear = function () {
        while (this.childNodes[0]) {
            this.removeChild(this.childNodes[0]);
        }
    }

    reportPanel.ontouchstart = function () {
        if (this.jsObject.options.allowTouchZoom) {
            this.jsObject.options.firstZoomDistance = 0;
            this.jsObject.options.secondZoomDistance = 0;
            this.jsObject.options.zoomStep = 0;
        }
    }

    reportPanel.ontouchmove = function (event) {
        if (typeof event !== "undefined" && event.touches.length > 1 && this.jsObject.options.allowTouchZoom) {
            event.preventDefault();
            this.jsObject.options.zoomStep++;

            if (this.jsObject.options.firstZoomDistance == 0)
                this.jsObject.options.firstZoomDistance = Math.sqrt(Math.pow(event.touches[0].pageX - event.touches[1].pageX, 2) + Math.pow(event.touches[0].pageY - event.touches[1].pageY, 2));

            if (this.jsObject.options.zoomStep > 2 && this.jsObject.options.secondZoomDistance == 0) {
                this.jsObject.options.secondZoomDistance = Math.sqrt(Math.pow(event.touches[0].pageX - event.touches[1].pageX, 2) + Math.pow(event.touches[0].pageY - event.touches[1].pageY, 2));

                this.jsObject.SetZoom(this.jsObject.options.secondZoomDistance > this.jsObject.options.firstZoomDistance);
            }
        }
    }

    reportPanel.getZoomByPageWidth = function () {
        if (this.jsObject.options.pageSizes.length == 0 || this.jsObject.options.pageSizes[0].width == 0) return 100;
        var newZoom = ((this.offsetWidth - (this.jsObject.options.bookmarks ? this.jsObject.options.bookmarks.offsetWidth : 0)) *
            this.jsObject.options.zoom) / (this.jsObject.options.pageSizes[0].width + 20);
        return newZoom;
    }

    reportPanel.getZoomByPageHeight = function () {
        if (this.jsObject.options.pageSizes.length == 0 || this.jsObject.options.pageSizes[0].height == 0) return 100;
        var newPagesHeight = window.innerHeight - (this.jsObject.options.toolbar ? this.jsObject.options.toolbar.offsetHeight : 0) -
            (this.jsObject.options.parametersPanel ? this.jsObject.options.parametersPanel.offsetHeight : 0) - 50;
        var newZoom = (newPagesHeight * this.jsObject.options.zoom) / (this.jsObject.options.pageSizes[0].height + 20);
        return newZoom;
    }
}