﻿
StiMvcViewer.prototype.InitializeToolBar = function (toolbar) {
    toolbar.jsObject = this;
    toolbar.mainTable = document.getElementById(toolbar.id + "Table");
    toolbar.innerCell = document.getElementById(toolbar.id + "InnerCell");
    toolbar.innerTable = document.getElementById(toolbar.id + "InnerTable");
    toolbar.shortType = false;
    toolbar.minWidth = 0;

    this.options.toolbar = toolbar;
    this.options.buttons["PageControlText"] = document.getElementById(this.options.mvcViewer.id + "PageControlText");
    this.options.buttons["PageControlCountLabel"] = document.getElementById(this.options.mvcViewer.id + "PageControlCountLabel");
    if (this.options.buttons["PageControlText"] != null) {
        this.options.buttons["PageControlText"].jsObject = this;
        this.options.buttons["PageControlCountLabel"].jsObject = this;
    }

    zoomMenu = document.getElementById(this.options.mvcViewer.id + "ZoomMenu");
    if (zoomMenu) toolbar.zoomItems = zoomMenu.items;

    toolbar.changeToolBarState = function () {
        options = this.jsObject.options;
        buttons = options.buttons;

        if (buttons["FirstPage"]) buttons["FirstPage"].setEnabled(options.pageNumber > 0 && options.menuViewMode == "OnePage");
        if (buttons["PrevPage"]) buttons["PrevPage"].setEnabled(options.pageNumber > 0 && options.menuViewMode == "OnePage");
        if (buttons["NextPage"]) buttons["NextPage"].setEnabled(options.pageNumber < options.pagesCount - 1 && options.menuViewMode == "OnePage");
        if (buttons["LastPage"]) buttons["LastPage"].setEnabled(options.pageNumber < options.pagesCount - 1 && options.menuViewMode == "OnePage");
        if (buttons["ViewMode"])
            if (buttons["ViewMode"].captionText)
                buttons["ViewMode"].captionText.innerHTML = buttons["ViewMode"].getAttribute(options.menuViewMode) + "&nbsp;";
        if (buttons["Zoom"])
            if (buttons["Zoom"].captionText) buttons["Zoom"].captionText.innerHTML = options.zoom + "%&nbsp;";
        if (buttons["PageControlCountLabel"]) buttons["PageControlCountLabel"].innerHTML = options.pagesCount;
        if (buttons["PageControlText"]) {
            buttons["PageControlText"].value = options.pageNumber + 1;
            buttons["PageControlText"].disabled = (options.pagesCount <= 1 || options.menuViewMode == "WholeReport");
        }
        for (var index in toolbar.zoomItems)
            if (toolbar.zoomItems[index].buttonName != "ZoomOnePage" && toolbar.zoomItems[index].buttonName != "ZoomPageWidth")
                toolbar.zoomItems[index].image.style.display = (toolbar.zoomItems[index].buttonName == "Zoom" + options.zoom) ? "" : "none";
        if (buttons["Bookmarks"]) buttons["Bookmarks"].setEnabled(options.haveBookmarks);
    }

    if (this.options.buttons["PageControlText"]) {
        this.options.buttons["PageControlText"].onkeypress = function (event) {
            if (event.keyCode == 13) {
                this.jsObject.postViewerEvent("GoToPage");
                return false;
            }
        }

        this.options.buttons["PageControlText"].getCorrectValue = function () {
            value = parseInt(this.value);
            if (value < 1 || !value) value = 1;
            if (value > this.jsObject.options.pagesCount) value = this.jsObject.options.pagesCount;
            return value;
        }
    }

    toolbar.haveScroll = function () {
        return (this.scrollWidth > this.offsetWidth)
    }
    
    toolbar.getMinWidth = function () {
        a = this.innerCell.offsetWidth;
        b = this.innerTable.offsetWidth
        c = this.mainTable.offsetWidth;

        return c - (a - b) + 50;
    }

    toolbar.minWidth = toolbar.getMinWidth();

    toolbar.changeShortType = function () {
        if (this.shortType && this.jsObject.options.mvcViewer.offsetWidth < this.minWidth) return;
        this.shortType = this.jsObject.options.mvcViewer.offsetWidth < this.minWidth;

        shortButtons = ["Print", "Save", "Zoom", "ViewMode", "Design"];

        for (var index in shortButtons) {
            button = this.jsObject.options.buttons[shortButtons[index]];
            if (button) {
                if (button.captionText) button.captionText.style.display = this.shortType ? "none" : "";
                if (button.imageContainer) button.imageContainer.className = this.shortType ? "stiImageCellButtonWithOutCaption" : "stiImageCellButtonWithCaption";
                if (button.imageContainerInner) button.imageContainerInner.style.textAlign = this.shortType ? "center" : "right";
            }
        }
    }

    window.onresize = function () {
        toolbar.changeShortType();
    }
}