/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.StiExportManager;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.enums.StiParametersPanelPosition;
import com.stimulsoft.web.enums.StiToolbarDisplayMode;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webviewer.StiWebViewerOptions;
import com.stimulsoft.webviewer.StiWebViewerRender;
import com.stimulsoft.webviewer.enums.StiFirstDayOfWeek;
import com.stimulsoft.webviewer.enums.StiWebViewerTheme;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class StiWebDesigner {
    protected static final Logger LOG = Logger.getLogger(StiWebDesigner.class.getName());
    public static final String ACTION_GET_REPORT_TEMPLATE = "ReportTemplate";
    public static final String ACTION_OPEN_REPORT_TEMPLATE = "OpenReportTemplate";
    public static final String ACTION_SAVE_REPORT_TEMPLATE = "SaveReportTemplate";
    public static final String ACTION_SAVE_AS_REPORT_TEMPLATE = "SaveAsReportTemplate";
    public static final String ACTION_GET_NEW_REPORT_DATA = "GetNewReportData";
    public static final String ACTION_DESIGNER_EVENT = "DesignerEvent";
    public static final String ACTION_REFRESH_SESSION = "RefreshSession";
    public static final String ACTION_EXIST_DESIGNER = "ExitDesigner";
    public static final String ACTION_GET_REPORT = "GetReport";
    public static final String ACTION_EXPORT_REPORT = "ExportReport";
    public static final String ACTION_PREVIEW_REPORT = "PreviewReport";
    private static final String SESSION_ATTRIBUTE_CACHED_REPORT = "webdesigner_cached_report";
    private static final String SESSION_ATTRIBUTE_PARAMETERS = "webdesigner_params";
    public static final String SESSION_ATTRIBUTE_HANDLER = "webdesigner_handler";

    public static String createViewer(StiWebDesignerOptions options, URL url, ServletContext context, String id) throws ParserConfigurationException, IOException {
        StiWebViewerOptions viewerOptions = new StiWebViewerOptions();
        viewerOptions.setViewerIDInternal(id + "Viewer");
        viewerOptions.getAppearance().setCustomCss(options.getAppearance().getCustomCss());
        viewerOptions.getAppearance().setPageBorderColor(StiColor.fromArgb((int)198, (int)198, (int)198));
        viewerOptions.getAppearance().setBackgroundColor(StiColor.fromArgb((int)241, (int)241, (int)241));
        viewerOptions.setTheme(StiWebViewerTheme.valueOf((String)options.getTheme().toString()));
        viewerOptions.getAppearance().setFullScreenMode(true);
        viewerOptions.getToolbar().setShowDesignButton(false);
        viewerOptions.getToolbar().setShowAboutButton(false);
        viewerOptions.getToolbar().setShowFullScreenButton(false);
        viewerOptions.getAppearance().setDatePickerFirstDayOfWeek(StiFirstDayOfWeek.valueOf((String)options.getAppearance().getDatePickerFirstDayOfWeek().toString()));
        viewerOptions.getServer().setPassQueryParametersForResources(options.getServer().isPassQueryParametersForResources());
        viewerOptions.getServer().setUseCompression(options.getServer().isUseCompression());
        viewerOptions.getAppearance().setShowTooltips(options.getAppearance().isShowTooltips());
        viewerOptions.getAppearance().setShowTooltipsHelp(options.getAppearance().isShowTooltipsHelp());
        viewerOptions.getServer().setUseRelativeUrls(options.getServer().isUseRelativeUrls());
        viewerOptions.getAppearance().setInterfaceType(options.getAppearance().getInterfaceType());
        viewerOptions.getAppearance().setReportDisplayMode(options.getAppearance().getReportDisplayMode());
        viewerOptions.getAppearance().setShowPageShadow(false);
        viewerOptions.getToolbar().setDisplayMode(StiToolbarDisplayMode.Separated);
        viewerOptions.getAppearance().setParametersPanelPosition(StiParametersPanelPosition.Left);
        viewerOptions.getAppearance().setParametersPanelColumnsCount(1);
        viewerOptions.setLocalization(options.getLocalization());
        StiWebViewerRender viewer = new StiWebViewerRender(viewerOptions, url);
        viewer.setReportDesignerMode(true);
        String result = viewer.getViewer(url, context);
        return result;
    }

    public void storeReport(HttpServletRequest httpContext, StiReport report, String viewerId) throws IOException, StiException {
        String reportGuid = viewerId + SESSION_ATTRIBUTE_CACHED_REPORT;
        httpContext.getSession().removeAttribute(viewerId + SESSION_ATTRIBUTE_PARAMETERS);
        if (report != null) {
            httpContext.getSession().setAttribute(reportGuid, (Object)report);
        }
    }

    public static String getActionCommandName(HttpServletRequest httpContext, JSONObject jsonObject) throws JSONException {
        return (String)jsonObject.get("command");
    }

    public static Object getObjectFromCache(HttpServletRequest httpContext, String objectId) {
        Object undoArray = httpContext.getSession().getAttribute(objectId);
        return undoArray;
    }

    public static StiReport getReportObject_new(HttpServletRequest httpContext, JSONObject parameters) {
        return null;
    }

    public static StiReport getReportObject(HttpServletRequest httpContext, HashMap<String, Object> parameters) throws JSONException {
        String reportGuid = (String)parameters.get("reportGuid");
        StiReport report = (StiReport)httpContext.getSession().getAttribute(reportGuid);
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            if (parameters.containsKey("reportName")) {
                report.setReportName((String)parameters.get("reportName"));
            }
        }
        return report;
    }

    public static StiReport saveReportObject(HttpServletRequest httpContext, StiReport report, String reportGuid) {
        if (report != null) {
            httpContext.getSession().setAttribute(reportGuid, (Object)report);
        }
        return report;
    }

    public static StiReport getReportObject(HttpServletRequest httpContext, StiRequestParams requestParams) {
        if (requestParams != null && requestParams.id != null) {
            return (StiReport)httpContext.getSession().getAttribute(requestParams.id);
        }
        return null;
    }

    public static String getReportSnapshotResult(HttpServletRequest httpContext, HashMap<String, Object> jParameters) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        return StiWebDesigner.getReportSnapshotResult(httpContext, null, jParameters);
    }

    public static String getReportSnapshotResult(HttpServletRequest httpContext, StiReport report, HashMap<String, Object> parameters) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        HashMap<String, Object> callbackResult = new HashMap<String, Object>();
        callbackResult.put("command", parameters.get("command"));
        StiReport newReport = report;
        if (newReport == null) {
            newReport = StiWebDesigner.getReportObject(httpContext, parameters);
        }
        StiWebDesigner.getReportSnapshotCallbackResult(callbackResult, httpContext, newReport, parameters);
        return new JSONObject(callbackResult).toString();
    }

    public static void setupDesign(StiReport report) {
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            report.setIsSerializing(false);
            report.setIsRendered(false);
        }
    }

    public static StiWebDesigerHandler getHandler(HttpServletRequest request, StiRequestParams requestParams) throws JSONException {
        return (StiWebDesigerHandler)request.getSession().getAttribute(requestParams.id + SESSION_ATTRIBUTE_HANDLER);
    }

    public static HashMap<String, Object> getReportSnapshotCallbackResult(HashMap<String, Object> callbackResult, HttpServletRequest httpContext, StiReport report, HashMap<String, Object> parameters) throws StiException, IOException, SAXException, StiDeserializationException, JSONException {
        StiReportEdit.getPreviewPages(report, parameters, callbackResult);
        return callbackResult;
    }

    public static HashMap<String, Object> getNewReportCallbackResult(HashMap<String, Object> callbackResult, HttpServletRequest httpContext, StiReport report, HashMap<String, Object> parameters) throws JSONException, ParserConfigurationException, IOException, TransformerException {
        String reportGuid = StiWebDesigner.getNewGuid();
        StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
        callbackResult.put("reportGuid", reportGuid);
        String command = (String)parameters.get("command");
        if ("CreateReport".equals(command)) {
            callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        }
        return callbackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String previewAs(StiReport mainReport, JSONObject parameters, HttpServletResponse response) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String result = null;
        try {
            if ("pdf".equals(parameters.getString("format"))) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", false).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtml(report, (OutputStream)stream, settings);
                result = new String(stream.toByteArray(), "UTF-8");
            }
        }
        finally {
            stream.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void previewReport(StiReport mainReport, String format, HttpServletResponse response) throws IOException, SAXException, StiDeserializationException, StiException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            if ("pdf".equals(format)) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", true).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtml(report, (OutputStream)stream, settings);
                StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)new String(stream.toByteArray(), "UTF-8"));
            }
        }
        finally {
            stream.close();
        }
    }

    public static String getNewGuid() {
        return StiGuid.newGuidString().substring(0, 16);
    }

    public static StiRequestParams createRequestParams(StiWebDesignerOptions options, String id, String clientGuid) {
        StiRequestParams requestParams = new StiRequestParams();
        requestParams.action = StiAction.GetReport;
        requestParams.component = StiComponentType.Designer;
        requestParams.id = id;
        requestParams.cache.timeout = 1;
        requestParams.cache.clientGuid = clientGuid;
        requestParams.server.useRelativeUrls = options.getServer().isUseRelativeUrls();
        requestParams.server.useCompression = options.getServer().isUseCompression();
        requestParams.server.passQueryParametersForResources = options.getServer().isPassQueryParametersForResources();
        return requestParams;
    }
}

