/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerCommands;
import com.stimulsoft.webdesigner.StiWebDesignerHelper;
import com.stimulsoft.webdesigner.helper.StiDesignerResourcesHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webviewer.StiWebViewerActions;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;

public class StiWebDesignerActions {
    public static StiWebActionResult getReportResult(HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        StiRequestParams requestParams = StiWebDesignerActions.getRequestParams(httpContext, jsonParams);
        return StiWebDesignerActions.processRequestResult(requestParams, StiWebDesigner.getReportObject(httpContext, requestParams), null, httpContext, jsonParams);
    }

    public static StiWebActionResult getReportResult(StiReport report, HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        StiRequestParams requestParams = StiWebDesignerActions.getRequestParams(httpContext, jsonParams);
        return StiWebDesignerActions.processRequestResult(requestParams, report, null, httpContext, jsonParams);
    }

    public static StiWebActionResult saveReportResult(HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        return StiWebDesignerActions.processRequestResult(null, null, null, httpContext, jsonParams);
    }

    public static StiWebActionResult previewReportResult(HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        return StiWebDesignerActions.previewReportResult(null, null, httpContext, jsonParams);
    }

    public static StiWebActionResult previewReportResult(StiReport report, HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        return StiWebDesignerActions.previewReportResult(null, report, httpContext, jsonParams);
    }

    public static StiWebActionResult previewReportResult(StiRequestParams requestParams, StiReport report, HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        if (report != null) {
            report = StiReportEdit.cloneReport(report, true);
        }
        return StiWebDesignerActions.processRequestResult(requestParams, report, null, httpContext, jsonParams);
    }

    public static StiWebActionResult exportReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings, HttpServletRequest httpContext, StringBuffer jsonParams) throws IOException, JSONException, NoSuchAlgorithmException, StiException {
        if (requestParams == null) {
            requestParams = StiWebDesignerActions.getRequestParams(httpContext, jsonParams);
        }
        if (report == null) {
            report = StiWebDesignerHelper.getReportObject(httpContext, requestParams);
        }
        if (settings == null) {
            settings = StiWebDesignerHelper.getExportSettings(requestParams);
        }
        return StiWebViewerActions.exportReportResult((StiRequestParams)requestParams, (StiReport)report, (StiExportSettings)settings, (HttpServletRequest)httpContext);
    }

    public static StiWebActionResult designerEventResult(HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        return StiWebDesignerActions.processRequestResult(null, null, null, httpContext, jsonParams);
    }

    public static StiWebActionResult designerEventResult(StiReport report, HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        return StiWebDesignerActions.processRequestResult(null, report, null, httpContext, jsonParams);
    }

    private static StiWebActionResult processRequestResult(StiRequestParams requestParams, StiReport report, String errorMessage, HttpServletRequest httpContext, StringBuffer jsonParams) throws Exception {
        if (requestParams == null) {
            requestParams = StiWebDesignerActions.getRequestParams(httpContext, jsonParams);
        }
        if (requestParams.component == StiComponentType.Viewer) {
            return (StiWebActionResult)StiWebViewerActions.viewerEventResult((StiRequestParams)requestParams, (StiReport)report, (HttpServletRequest)httpContext);
        }
        if (requestParams.component == StiComponentType.Designer) {
            StiWebActionResult result = null;
            if (report == null && requestParams.action != StiAction.OpenReport) {
                report = StiWebDesignerHelper.getActionReportObject(requestParams, httpContext);
            }
            switch (requestParams.action) {
                case Resource: {
                    result = StiDesignerResourcesHelper.get(requestParams);
                    break;
                }
                case GetReport: {
                    report = StiWebDesignerCommands.getReportForDesigner(requestParams, report, httpContext);
                    break;
                }
                case OpenReport: {
                    if (report != null) break;
                    try {
                        report = StiWebDesignerCommands.loadReportFromContent(requestParams);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errorMessage = e.getMessage();
                    }
                    break;
                }
                case PreviewReport: {
                    requestParams.report = report;
                    break;
                }
                case Exit: {
                    result = new StiWebActionResult();
                }
            }
            if (!StiValidationUtil.isNullOrEmpty((String)errorMessage)) {
                result = StiWebActionResult.errorResult((StiRequestParams)requestParams, (String)errorMessage);
            }
            if (result == null) {
                result = StiWebDesignerCommands.commandResult(requestParams, report, httpContext);
            }
            boolean isResourceAction = requestParams.action == StiAction.Resource;
            return new StiWebActionResult(result.getData(), result.getFileName(), result.getContentType(), !StiValidationUtil.isNullOrEmpty((String)result.getFileName()) && !isResourceAction, isResourceAction);
        }
        return new StiWebActionResult();
    }

    public static StiRequestParams getRequestParams(HttpServletRequest httpContext, StringBuffer jsonParams) throws IOException, JSONException {
        return StiRequestParamsHelper.get((HttpServletRequest)httpContext, (StringBuffer)jsonParams);
    }
}

