/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.StiEncryption;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.helper.StiBarCodeHelper;
import com.stimulsoft.webdesigner.helper.StiChartHelper;
import com.stimulsoft.webdesigner.helper.StiCrossTabHelper;
import com.stimulsoft.webdesigner.helper.StiCultureHelper;
import com.stimulsoft.webdesigner.helper.StiDesignerResourcesHelper;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiReportCheckHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiTableHelper;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import com.stimulsoft.webdesigner.helper.StiWebDesignerOptionsHelper;
import com.stimulsoft.webdesigner.helper.StiWizardHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class StiWebDesignerCommands {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.webdesigner.StiWebDesignerCommands");

    public static StiReport getReportForDesigner(StiRequestParams requestParams, StiReport currentReport, HttpServletRequest httpContext) throws Exception {
        if (currentReport == null) {
            currentReport = StiWebDesignerCommands.getNewReport(requestParams);
        }
        HashMap<String, Object> designerOptions = StiWebDesignerOptionsHelper.getDesignerOptions(httpContext);
        StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(designerOptions, currentReport);
        currentReport.getInfo().setZoom(1.0);
        if (StiValidationUtil.isNullOrEmpty((String)currentReport.getReportFile())) {
            currentReport.setReportFile(!StiValidationUtil.isNullOrEmpty((String)currentReport.getReportName()) ? currentReport.getReportName() + ".mrt" : "Report.mrt");
        }
        return currentReport;
    }

    public static StiReport getNewReport(StiRequestParams requestParams) throws JSONException {
        StiReport newReport = StiReport.newInstance();
        if (requestParams != null) {
            newReport.setReportUnit((StiReportUnitType)requestParams.getEnum("defaultUnit", StiReportUnitType.class, (Enum)StiReportUnitType.Centimeters));
        }
        ((StiPage)newReport.getPages().get(0)).setPaperSize(StiPaperKind.Custom);
        ((StiPage)newReport.getPages().get(0)).setPageWidth(newReport.getUnit().ConvertFromHInches(827.0));
        ((StiPage)newReport.getPages().get(0)).setPageHeight(newReport.getUnit().ConvertFromHInches(1169.0));
        newReport.getInfo().setZoom(1.0);
        return newReport;
    }

    public static StiReport loadReportFromContent(StiRequestParams requestParams) throws Exception {
        StiReport report = null;
        byte[] bytes = requestParams.data;
        if (requestParams.designer.password != null) {
            if ((char)bytes[0] != 'm' || (char)bytes[1] != 'r' || (char)bytes[2] != 'x') {
                throw new Exception("This file is a not '.mrx' format.");
            }
            int[] dest = new int[bytes.length - 3];
            for (int i = 3; i < bytes.length; ++i) {
                dest[i - 3] = bytes[i] >= 0 ? bytes[i] : 256 + bytes[i];
            }
            dest = StiEncryption.decrypt((int[])dest, (String)requestParams.designer.password);
            try {
                byte[] dest2 = new byte[dest.length];
                for (int i = 0; i < dest.length; ++i) {
                    dest2[i] = (byte)dest[i];
                }
                byte[] unpacked = StiGZipHelper.unpack((byte[])dest2);
                report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
            }
            catch (Exception ee) {
                throw new Exception("File decryption error: wrong key.");
            }
        } else if (StiWebDesignerCommands.isPackedFile(bytes)) {
            byte[] unpacked = StiGZipHelper.unpack((byte[])bytes);
            report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
        } else {
            report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(bytes));
        }
        StiWebDesigner.setupDesign(report);
        report.getInfo().setZoom(1.0);
        if (requestParams.designer.fileName != null) {
            report.setReportFile(requestParams.designer.fileName);
        }
        report.setCalculationMode(StiCalculationMode.Interpretation);
        return report;
    }

    private static boolean isPackedFile(byte[] bytes) {
        if (bytes == null || bytes.length < 3) {
            return false;
        }
        return StiWebDesignerCommands.isPackedFile(bytes[0], bytes[1], bytes[2]);
    }

    private static boolean isPackedFile(int first, int second, int third) {
        if (first == 31 && second == 139 && third == 8) {
            return true;
        }
        return first == 80 && second == 75 && third == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StiWebActionResult commandResult(StiRequestParams requestParams, StiReport currentReport, HttpServletRequest httpContext) throws UnsupportedEncodingException {
        HashMap<String, Object> callbackResult = new HashMap<String, Object>();
        if (currentReport != null) {
            if (requestParams == null || requestParams.action != StiAction.PreviewReport) {
                currentReport.getInfo().setForceDesigningMode(true);
            }
            currentReport.getInfo().setZoom(1.0);
        }
        try {
            HashMap param = requestParams.all;
            StiDesignerCommand command = requestParams.designer.command;
            callbackResult.put("command", command);
            if (param.get("callbackFunctionId") != null) {
                callbackResult.put("callbackFunctionId", param.get("callbackFunctionId"));
            }
            if (currentReport == null && command != StiDesignerCommand.CloseReport && command != StiDesignerCommand.CreateReport && command != StiDesignerCommand.GetReportFromData && command != StiDesignerCommand.OpenReport && command != StiDesignerCommand.WizardResult && command != StiDesignerCommand.UpdateCache && command != StiDesignerCommand.GetReportForDesigner && command != StiDesignerCommand.UpdateImagesArray && command != StiDesignerCommand.Synchronization) {
                param.put("command", "SessionCompleted");
                callbackResult.put("command", "SessionCompleted");
            }
            if (command == StiDesignerCommand.Synchronization) {
                if (currentReport == null) {
                    callbackResult.put("command", "SynchronizationError");
                } else {
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                }
            } else if (command == StiDesignerCommand.UpdateCache) {
                callbackResult.put("command", "UpdateCache");
            } else if (command == StiDesignerCommand.GetReportForDesigner) {
                HashMap attachedItems = null;
                if (currentReport != null) {
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport, attachedItems));
                }
            } else if (command == StiDesignerCommand.CreateReport) {
                StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                callbackResult.put("needClearAfterOldReport", param.get("needClearAfterOldReport"));
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.OpenReport) {
                try {
                    currentReport.getInfo().setForceDesigningMode(true);
                    StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                    String reportObjectStr = StiReportEdit.writeReportInObject(currentReport);
                    if (reportObjectStr != null) {
                        callbackResult.put("reportObject", reportObjectStr);
                        callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                    } else {
                        callbackResult.put("errorMessage", "Loading report error: Json parser error!");
                    }
                    if (requestParams.designer.password != null) {
                        callbackResult.put("encryptedPassword", requestParams.designer.password);
                    }
                }
                catch (Exception e) {
                    callbackResult.put("reportGuid", null);
                    callbackResult.put("reportObject", null);
                    callbackResult.put("error", "Loading report error. " + e.getMessage());
                }
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.CloseReport) {
                currentReport = null;
            } else if (command == StiDesignerCommand.SaveAsReport || command == StiDesignerCommand.SaveReport) {
                StiWebDesigerHandler handler = StiWebDesigner.getHandler(httpContext, requestParams);
                handler.onSaveReportTemplate(currentReport, requestParams, httpContext);
            } else if (command == StiDesignerCommand.MoveComponent || command == StiDesignerCommand.ResizeComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.changeRectComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.createComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.removeComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.AddPage) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.addPage(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemovePage) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.removePage(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SendProperties) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.readAllPropertiesFromString(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.ChangeUnit) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.changeUnit(currentReport, (String)param.get("reportUnit"));
                callbackResult.put("reportUnit", param.get("reportUnit"));
                callbackResult.put("gridSize", currentReport.getInfo().getGridSize());
                StiReportEdit.getAllComponentsPositions(currentReport, callbackResult);
            } else if (command == StiDesignerCommand.RebuildPage) {
                callbackResult.put("pageName", param.get("pageName"));
                callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(currentReport, currentReport.getPages().get((String)param.get("pageName"))));
            } else if (command == StiDesignerCommand.LoadReportToViewer) {
                try {
                    List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, requestParams.report, false);
                    callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String viewerClientGuid = String.format("%s_%s", requestParams.id + "Viewer", param.get("viewerClientGuid"));
                String viewerReportGuid = String.format("%s_%s", viewerClientGuid, "template");
                StiCacheHelper.removeReport((String)viewerClientGuid, (HttpServletRequest)httpContext);
                StiCacheHelper.saveReport((StiReport)requestParams.report, (String)viewerReportGuid, (HttpServletRequest)httpContext);
            } else if (command == StiDesignerCommand.SetToClipboard) {
                StiReportEdit.setToClipboard(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetFromClipboard) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.getFromClipboard(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.Undo) {
                currentReport = StiReportEdit.getUndoStep(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.Redo) {
                currentReport = StiReportEdit.getRedoStep(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RenameComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.renameComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.WizardResult) {
                HashMap wizardResult = (HashMap)param.get("wizardResult");
                currentReport = StiWizardHelper.getReportFromWizardOptions(currentReport, (HashMap)wizardResult.get("reportOptions"), (HashMap)wizardResult.get("dataSources"));
                StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                HashMap attachedItems = null;
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport, attachedItems));
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.GetConnectionTypes) {
                StiDictionaryHelper.getConnectionTypes(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.CreateOrEditConnection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditConnection(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.DeleteConnection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteConnection(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditRelation) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditRelation(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteRelation) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteRelation(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditColumn) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditColumn(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteColumn) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteColumn(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditParameter) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditParameter(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteParameter) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteParameter(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditDataSource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditDataSource(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.DeleteDataSource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteDataSource(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditBusinessObject) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditBusinessObject(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteBusinessObject) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteBusinessObject(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteBusinessObjectCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteBusinessObjectCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.EditBusinessObjectCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.editBusinessObjectCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditVariable) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditVariable(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteVariable) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteVariable(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.EditVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.editVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditResource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport, true);
            } else if (command == StiDesignerCommand.DeleteResource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport, true);
            } else if (command == StiDesignerCommand.SynchronizeDictionary) {
                StiDictionaryHelper.synchronizeDictionary(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetAllConnections) {
                StiDictionaryHelper.getAllConnections(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.RetrieveColumns) {
                StiDictionaryHelper.retrieveColumns(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.UpdateStyles) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.updateStyles(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.AddStyle) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.addStyle(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveStyle) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.removeStyle(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateStyleCollection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.createStyleCollection(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.StartEditChartComponent) {
                StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                if (component != null) {
                    StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                    callbackResult.put("properties", StiChartHelper.getChartProperties((StiChart)component));
                }
            } else if (command == StiDesignerCommand.CanceledEditComponent) {
                StiReportEdit.canceledEditComponent(httpContext, requestParams, currentReport, param);
            } else if (command == StiDesignerCommand.AddSeries) {
                StiChartHelper.addSeries(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveSeries) {
                StiChartHelper.removeSeries(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SeriesMove) {
                StiChartHelper.seriesMove(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.AddConstantLineOrStrip) {
                StiChartHelper.addConstantLineOrStrip(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveConstantLineOrStrip) {
                StiChartHelper.removeConstantLineOrStrip(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.ConstantLineOrStripMove) {
                StiChartHelper.constantLineOrStripMove(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetLabelsContent) {
                StiChartHelper.getLabelsContent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetStylesContent) {
                StiChartHelper.getStylesContent(currentReport, param, callbackResult, false);
            } else if (command == StiDesignerCommand.SetLabelsType) {
                StiChartHelper.setLabelsType(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SetChartStyle) {
                StiChartHelper.setChartStyle(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SetChartPropertyValue) {
                StiChartHelper.setChartPropertyValue(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SendContainerValue) {
                StiChartHelper.setContainerValue(currentReport, param, callbackResult);
            } else if (command != StiDesignerCommand.GetReportFromData) {
                if (command == StiDesignerCommand.ItemResourceSave) {
                    if (currentReport != null) {
                        // empty if block
                    }
                } else if (command == StiDesignerCommand.CloneItemResourceSave) {
                    if (currentReport != null) {
                        // empty if block
                    }
                } else if (command == StiDesignerCommand.GetDatabaseData) {
                    StiDictionaryHelper.getDatabaseData(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ApplySelectedData) {
                    StiDictionaryHelper.applySelectedData(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.CreateTextComponent) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.createTextComponentFromDictionary(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.CreateDataComponent) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.createDataComponentFromDictionary(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.SetReportProperties) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.setReportProperties(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.PageMove) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.pageMove(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.TestConnection) {
                    StiDictionaryHelper.testConnection(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
                } else if (command == StiDesignerCommand.RunQueryScript) {
                    StiDictionaryHelper.runQueryScript(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ViewData) {
                    StiDictionaryHelper.viewData(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ApplyDesignerOptions) {
                    currentReport.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
                    StiWebDesignerOptionsHelper.applyDesignerOptionsToReport((HashMap)param.get("designerOptions"), currentReport);
                    if (param.get("reportFile") != null) {
                        currentReport.setReportFile((String)param.get("reportFile"));
                    }
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                } else if (command == StiDesignerCommand.GetSqlParameterTypes) {
                    StiDictionaryHelper.getSqlParameterTypes(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.AlignToGridComponents) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.alignToGridComponents(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ChangeArrangeComponents) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.changeArrangeComponents(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.UpdateSampleTextFormat) {
                    StiFormatService service = StiTextFormatHelper.getFormatService((HashMap)param.get("textFormat"));
                    if (!service.getIsFormatStringFromVariable()) {
                        callbackResult.put("sampleText", service.Format(service.getSample()));
                    }
                    service = null;
                } else if (command == StiDesignerCommand.StartEditCrossTabComponent) {
                    StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                    if (component != null) {
                        StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                    }
                } else if (command == StiDesignerCommand.UpdateCrossTabComponent) {
                    StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                    if (component != null && component instanceof StiCrossTab) {
                        StiCrossTabHelper crossTabHelper = new StiCrossTabHelper((StiCrossTab)component);
                        crossTabHelper.executeJSCommand((HashMap)param.get("updateParameters"), callbackResult);
                        crossTabHelper.restorePositions();
                        crossTabHelper = null;
                    }
                } else if (command == StiDesignerCommand.GetCrossTabColorStyles) {
                    callbackResult.put("colorStyles", StiCrossTabHelper.getColorStyles());
                } else if (command == StiDesignerCommand.DuplicatePage) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.duplicatePage(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.UpdateEvents) {
                    StiReportEdit.updateEvents(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.SetEventValue) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.setEventValue(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.GetChartStylesContent) {
                    StiChartHelper.getStylesContent(currentReport, param, callbackResult, true);
                } else if (command != StiDesignerCommand.GetGaugeStylesContent && command != StiDesignerCommand.GetMapStylesContent) {
                    if (command == StiDesignerCommand.GetCrossTabStylesContent) {
                        callbackResult.put("stylesContent", StiCrossTabHelper.getColorStyles());
                    } else if (command == StiDesignerCommand.GetTableStylesContent) {
                        callbackResult.put("stylesContent", StiTableHelper.getTableStyles());
                    } else if (command == StiDesignerCommand.ChangeTableComponent) {
                        StiComponent table = currentReport.GetComponentByName((String)param.get("tableName"));
                        if (table != null && table instanceof StiTable) {
                            StiTableHelper tableHelper = new StiTableHelper((StiTable)table, StiReportEdit.strToDouble((String)param.get("zoom")));
                            tableHelper.executeJSCommand((HashMap)param.get("changeParameters"), callbackResult);
                            tableHelper = null;
                        }
                    } else {
                        if (command == StiDesignerCommand.UpdateImagesArray) {
                            callbackResult.put("images", StiDesignerResourcesHelper.getImagesArray(requestParams, null));
                            return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
                        }
                        if (command == StiDesignerCommand.OpenStyle) {
                            StiStylesHelper.openStyle(requestParams, currentReport, callbackResult);
                        } else if (command == StiDesignerCommand.CopyStyle) {
                            StiStylesHelper.copyStyle(httpContext, requestParams, currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.PasteStyle) {
                            StiStylesHelper.pasteStyle(httpContext, requestParams, currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.DuplicateStyle) {
                            StiStylesHelper.duplicateStyle(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.ApplyStyleProperties) {
                            HashMap styleProperties = (HashMap)param.get("styleProperties");
                            StiBaseStyle style = currentReport.getStyles().get((String)param.get("styleOldName"));
                            if (style != null) {
                                StiStylesHelper.applyStyleProperties(style, styleProperties);
                            }
                        } else if (command == StiDesignerCommand.CreateStyleFromComponent) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiStylesHelper.createStyleFromComponent(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.ChangeSizeComponents) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiReportEdit.changeSizeComponents(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.CreateFieldOnDblClick) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiDictionaryHelper.createFieldOnDblClick(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.GetParamsFromQueryString) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiDictionaryHelper.getParamsFromQueryString(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.CreateMovingCopyComponent) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiReportEdit.createMovingCopyComponent(httpContext, requestParams, currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.GetReportCheckItems) {
                            List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, currentReport, true);
                            callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                        } else if (command == StiDesignerCommand.GetCheckPreview) {
                            StiReportCheckHelper.getCheckPreview(httpContext, requestParams, currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.ActionCheck) {
                            StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                            StiReportCheckHelper.actionCheck(httpContext, requestParams, currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.CheckExpression) {
                            StiReportCheckHelper.checkExpression(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.GetGlobalizationStrings) {
                            callbackResult.put("globalizationStrings", StiCultureHelper.getReportGlobalizationStrings(currentReport));
                            callbackResult.put("cultures", StiCultureHelper.getItems());
                        } else if (command == StiDesignerCommand.AddGlobalizationStrings) {
                            StiCultureHelper.addReportGlobalizationStrings(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.RemoveGlobalizationStrings) {
                            StiCultureHelper.removeReportGlobalizationStrings(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.GetCultureSettingsFromReport) {
                            StiCultureHelper.getCultureSettingsFromReport(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.SetCultureSettingsToReport) {
                            StiCultureHelper.setCultureSettingsToReport(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.ApplyGlobalizationStrings) {
                            StiCultureHelper.applyGlobalizationStrings(currentReport, param, callbackResult);
                        } else if (command == StiDesignerCommand.StartEditGaugeComponent) {
                            StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                            if (component == null) {
                                // empty if block
                            }
                        } else if (command != StiDesignerCommand.GetResourceContent && command != StiDesignerCommand.ConvertResourceContent && command != StiDesignerCommand.GetResourceText && command != StiDesignerCommand.SetResourceText && command != StiDesignerCommand.GetResourceViewData) {
                            if (command == StiDesignerCommand.UpdateGaugeComponent) {
                                StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                            } else if (command == StiDesignerCommand.GetImagesGallery) {
                                StiDictionaryHelper.getImagesGallery(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.CreateImageComponent) {
                                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                                StiReportEdit.createImageComponentFromDictionary(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.GetSampleConnectionString) {
                                StiDictionaryHelper.getSampleConnectionString(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (HttpServletRequest)httpContext));
                            } else if (command != StiDesignerCommand.CreateDatabaseFromResource && command != StiDesignerCommand.GetRichTextGallery && command != StiDesignerCommand.GetRichTextContent) {
                                if (command == StiDesignerCommand.DeleteAllDataSources) {
                                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                                    StiDictionaryHelper.deleteAllDataSources(currentReport, param, callbackResult);
                                } else if (command != StiDesignerCommand.LoadReportFromCloud) {
                                    if (command == StiDesignerCommand.StartEditBarCodeComponent) {
                                        StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                                        if (component != null) {
                                            StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                                            callbackResult.put("barCode", StiBarCodeHelper.getBarCodeJSObject((StiBarCode)component));
                                        }
                                    } else if (command == StiDesignerCommand.GetBarCodeSamples) {
                                        StiBarCodeHelper.getBarCodeSamples(currentReport, param, callbackResult);
                                    } else if (command == StiDesignerCommand.ApplyBarCodeProperties) {
                                        StiBarCodeHelper.applyBarCodeProperties(currentReport, param, callbackResult);
                                    } else if (command == StiDesignerCommand.DownloadReport) {
                                        String reportFile = !StiValidationUtil.isNullOrWhiteSpace((String)requestParams.designer.fileName) ? requestParams.designer.fileName : "Report.mrt";
                                        String password = requestParams.designer.password;
                                    } else if (command == StiDesignerCommand.DownloadStyles) {
                                        StiReport tempReport = new StiReport();
                                        String styles = requestParams.getString("stylesCollection");
                                        if (styles != null) {
                                            ArrayList stylesCollection = new ArrayList();
                                            StiRequestParamsHelper.parseParameters((Object)new JSONArray(styles), null, stylesCollection);
                                            StiStylesHelper.writeStylesToReport(tempReport, stylesCollection);
                                            return new StiWebActionResult(tempReport.getStyles().saveToString(), "application/octet-stream", "Styles.sts");
                                        }
                                    } else if (command == StiDesignerCommand.GetVariableItemsFromDataColumn) {
                                        StiDictionaryHelper.getVariableItemsFromDataColumn(currentReport, param, callbackResult);
                                    } else if (command == StiDesignerCommand.MoveDictionaryItem) {
                                        StiDictionaryHelper.moveDictionaryItem(currentReport, param, callbackResult);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (currentReport != null) {
                StiCacheHelper.saveReportInternal((StiRequestParams)requestParams, (StiReport)currentReport, (HttpServletRequest)httpContext);
                return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
            }
            StiCacheHelper.removeReportInternal((StiRequestParams)requestParams, (HttpServletRequest)httpContext);
            return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackResult.put("error", e.getMessage() != null ? e.getMessage() : e.toString());
            return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
        }
    }
}

