/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesignerCommands;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.StiWebDesignerRender;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StiWebDesignerHelper {
    public static StiExportSettings getExportSettings(StiRequestParams requestParams) {
        return StiExportsHelper.getExportSettings((StiRequestParams)requestParams);
    }

    public String getWebDesigner(URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), context, request, handler, servletContext);
    }

    public String getWebDesigner(StiWebDesignerOptions options, URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner("WebDesigner1" + StiGuid.newGuidStringPlain(), options, context, request, handler, servletContext);
    }

    public String getWebDesigner(String designerID, URL context, HttpServletRequest request, StiWebDesigerHandler handler, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebDesigner(designerID, new StiWebDesignerOptions(), context, request, handler, servletContext);
    }

    public String getWebDesigner(String designerID, StiWebDesignerOptions options, URL context, HttpServletRequest request, StiWebDesigerHandler handler, Object servletContext) throws ParserConfigurationException, IOException, StiException {
        if (options == null) {
            options = new StiWebDesignerOptions();
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)designerID)) {
            options.setDesignerID(designerID);
        } else {
            options.setDesignerID("WebDesigner1" + StiGuid.newGuidStringPlain());
        }
        StiWebDesignerRender designer = new StiWebDesignerRender(options, context, request);
        return designer.getDesigner(context, handler, request, servletContext);
    }

    private static HashMap<String, String> getCssConstants(StringBuffer cssText) {
        HashMap<String, String> constants = new HashMap<String, String>();
        int startIndex = cssText.indexOf("@");
        String constantsStr = cssText.substring(startIndex, cssText.lastIndexOf(";") - startIndex);
        String[] constantsArray = constantsStr.split(";");
        for (int i = 0; i < constantsArray.length; ++i) {
            String[] tmpArray = constantsArray[i].split("=");
            if (tmpArray.length != 2) continue;
            constants.put(tmpArray[0].trim(), tmpArray[1]);
        }
        return constants;
    }

    public static StiReport getActionReportObject(HttpServletRequest httpContext, StringBuffer jsonParams) throws IOException, JSONException, SAXException, StiDeserializationException {
        StiRequestParams requestParams = StiWebDesignerHelper.getRequestParams(httpContext, jsonParams);
        return StiWebDesignerHelper.getActionReportObject(requestParams, httpContext);
    }

    public static StiRequestParams getRequestParams(HttpServletRequest httpContext, StringBuffer jsonParams) throws IOException, JSONException {
        StiRequestParams requestParams = StiRequestParamsHelper.get((HttpServletRequest)httpContext, (StringBuffer)jsonParams);
        return requestParams;
    }

    public static StiReport getActionReportObject(StiRequestParams requestParams, HttpServletRequest httpContext) throws JSONException, IOException, SAXException, StiDeserializationException {
        if (requestParams.action == StiAction.OpenReport) {
            // empty if block
        }
        StiReport currentReport = StiWebDesignerHelper.getReportObject(httpContext, requestParams);
        if (requestParams.action == StiAction.CreateReport) {
            StiReport newReport = StiWebDesignerCommands.getNewReport(requestParams);
            if (currentReport != null) {
                StiReportEdit.copyReportDictionary(currentReport, newReport);
            }
            return newReport;
        }
        if (requestParams.action == StiAction.PreviewReport) {
            return StiReportEdit.cloneReport(currentReport, true);
        }
        return currentReport;
    }

    public static StiReport getReportObject(HttpServletRequest httpContext, StiRequestParams requestParams) {
        return StiCacheHelper.getReportInternal((StiRequestParams)requestParams, (HttpServletRequest)httpContext);
    }
}

