/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.globalization.StiGlobalizationContainer;
import com.stimulsoft.report.globalization.StiGlobalizationItem;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class StiCultureHelper {
    public static ArrayList<HashMap<String, String>> getItems() {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (StiValidationUtil.isEmpty((String)locale.getDisplayName())) continue;
            HashMap<String, String> cultureProps = new HashMap<String, String>();
            cultureProps.put("name", locale.getDisplayName());
            cultureProps.put("displayName", locale.getLanguage() + "-" + locale.getCountry() + "  (" + locale.getDisplayName() + ")");
            result.add(cultureProps);
        }
        Collections.sort(result, new Comparator<HashMap<String, String>>(){

            @Override
            public int compare(HashMap<String, String> o1, HashMap<String, String> o2) {
                return o1.get("name").compareTo(o2.get("name"));
            }
        });
        return result;
    }

    private static HashMap<String, Object> getGlobalizationContainerObject(StiGlobalizationContainer globContainer, StiReport report) {
        HashMap<String, Object> containerObject = new HashMap<String, Object>();
        containerObject.put("cultureName", globContainer.getCultureName());
        HashMap<String, String> items = new HashMap<String, String>();
        for (StiGlobalizationItem item : globContainer.getItems()) {
            items.put(item.getPropertyName(), item.getText());
        }
        containerObject.put("items", items);
        containerObject.put("reportItems", globContainer.getAllStringsForReport(report));
        return containerObject;
    }

    public static ArrayList<HashMap<String, Object>> getReportGlobalizationStrings(StiReport report) {
        report.getGlobalizationStrings().fillItemsFromReport();
        ArrayList<HashMap<String, Object>> globStrings = new ArrayList<HashMap<String, Object>>();
        for (StiGlobalizationContainer globContainer : report.getGlobalizationStrings()) {
            globStrings.add(StiCultureHelper.getGlobalizationContainerObject(globContainer, report));
        }
        return globStrings;
    }

    public static void addReportGlobalizationStrings(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiGlobalizationContainer container = new StiGlobalizationContainer((String)param.get("cultureName"));
        container.fillItemsFromReport(report);
        report.getGlobalizationStrings().add((Object)container);
        HashMap<String, Object> containerObject = StiCultureHelper.getGlobalizationContainerObject(container, report);
        callbackResult.put("globalizationStrings", containerObject);
    }

    public static void removeReportGlobalizationStrings(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        int index = Integer.parseInt(String.valueOf(param.get("index")));
        if (report.getGlobalizationStrings().size() > index) {
            report.getGlobalizationStrings().remove(index);
            callbackResult.put("success", true);
        }
    }

    public static void getCultureSettingsFromReport(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        int index = Integer.parseInt(String.valueOf(param.get("index")));
        if (report.getGlobalizationStrings().size() > index) {
            StiGlobalizationContainer container = (StiGlobalizationContainer)report.getGlobalizationStrings().get(index);
            container.getItems().clear();
            container.fillItemsFromReport(report);
            HashMap<String, Object> containerObject = StiCultureHelper.getGlobalizationContainerObject(container, report);
            callbackResult.put("globalizationStrings", containerObject);
        }
    }

    public static void setCultureSettingsToReport(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws StiException, ParserConfigurationException, IOException, TransformerException {
        report.localizeReport((String)param.get("cultureName"));
        StiGlobalizationContainer container = new StiGlobalizationContainer((String)param.get("cultureName"));
        callbackResult.put("reportItems", container.getAllStringsForReport(report));
        report.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        callbackResult.put("reportGuid", param.get("reportGuid"));
        callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
    }

    public static void applyGlobalizationStrings(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        int index = (Integer)param.get("index");
        if (report.getGlobalizationStrings().size() > index) {
            StiGlobalizationContainer container = (StiGlobalizationContainer)report.getGlobalizationStrings().get(index);
            boolean haveItem = false;
            for (StiGlobalizationItem item : container.getItems()) {
                if (!item.getPropertyName().equals(param.get("propertyName"))) continue;
                item.setText((String)param.get("propertyValue"));
                haveItem = true;
                break;
            }
            if (!haveItem) {
                container.getItems().add((Object)new StiGlobalizationItem((String)param.get("propertyName"), (String)param.get("propertyValue")));
            }
        }
    }
}

