/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StiPreviewHelper {
    public static List<Object> getPages(StiReport report, int pageNumber, double zoom) throws StiException, IOException {
        StiHtmlExportService service = new StiHtmlExportService();
        service.setRenderAsDocument(false);
        service.setStyles(new ArrayList());
        service.setClearOnFinish(false);
        service.setRenderStyles(false);
        ArrayList<Object> pages = new ArrayList<Object>();
        if (pageNumber != -1) {
            HashMap<String, String> pageAttr = new HashMap<String, String>();
            Map<String, String> res = StiPreviewHelper.renderPageParameters(report, pageNumber, zoom);
            pageAttr.put("content", StiPreviewHelper.renderReportPage(service, report, pageNumber, zoom));
            pageAttr.put("margins", res.get("pageMargins"));
            pageAttr.put("sizes", res.get("pageSizes"));
            pageAttr.put("background", res.get("pageBackgrounds"));
            pages.add(pageAttr);
        } else {
            for (int id = 0; id < report.getRenderedPages().size(); ++id) {
                HashMap<String, String> pageAttr = new HashMap<String, String>();
                Map<String, String> res = StiPreviewHelper.renderPageParameters(report, id, zoom);
                pageAttr.put("content", StiPreviewHelper.renderReportPage(service, report, id, zoom));
                pageAttr.put("margins", res.get("pageMargins"));
                pageAttr.put("sizes", res.get("pageSizes"));
                pageAttr.put("background", res.get("pageBackgrounds"));
                pages.add(pageAttr);
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        StiHtmlTextWriter htmlWriter = new StiHtmlTextWriter(writer);
        service.setHtmlWriter(htmlWriter);
        if (service.getTableRender() != null) {
            service.getTableRender().renderStylesTable(true, false, false);
        }
        htmlWriter.flush();
        writer.flush();
        String htmlTextStyles = new String(stream.toByteArray(), "UTF8");
        writer.close();
        pages.add(htmlTextStyles);
        String chartScript = service.getChartScript();
        pages.add(chartScript);
        return pages;
    }

    private static String renderReportPage(StiHtmlExportService service, StiReport report, int pageIndex, double zoom) throws StiException, IOException {
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        settings.setPageRange(new StiPagesRange(pageIndex));
        settings.setZoom(zoom);
        settings.setImageFormat(StiImageFormat.Png);
        settings.setExportMode(StiHtmlExportMode.Table);
        settings.setExportQuality(StiHtmlExportQuality.High);
        settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.ReportOnly);
        settings.setRemoveEmptySpaceAtBottom(false);
        settings.setChartType(StiHtmlChartType.AnimatedVector);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        service.exportHtml(report, (OutputStream)stream, settings);
        String htmlText = new String(stream.toByteArray(), "UTF-8");
        stream.close();
        return htmlText;
    }

    private static Map<String, String> renderPageParameters(StiReport report, int pageNumber, double zoom) {
        StiPage page = (StiPage)report.getRenderedPages().get(pageNumber);
        String pageMargins = String.format("%spx %spx %spx %spx", Math.round(report.getUnit().ConvertToHInches(page.getMargins().getTop()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getRight()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getBottom()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getLeft()) * zoom));
        String pageSizes = String.format("%s;%s", Math.round(report.getUnit().ConvertToHInches(page.getPageWidth()) * zoom), Math.round(report.getUnit().ConvertToHInches(page.getPageHeight()) * zoom));
        StiColor color = StiBrush.ToColor((StiBrush)page.getBrush());
        String pageBackgrounds = color.toHTML();
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("pageMargins", pageMargins);
        res.put("pageSizes", pageSizes);
        res.put("pageBackgrounds", pageBackgrounds);
        return res;
    }
}

