/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiParserException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.check.StiCheckEngine;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.StiAction;
import com.stimulsoft.report.check.report.StiReportRenderingMessageCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class StiReportCheckHelper {
    private static HashMap<String, Object> checkItem(StiCheck check) {
        HashMap<String, Object> checkObject = new HashMap<String, Object>();
        checkObject.put("actions", StiReportCheckHelper.getActions(check));
        checkObject.put("defaultStateEnabled", check.isDefaultStateEnabled());
        checkObject.put("element", check.getElement() != null ? check.getElement().getClass().getName().substring(check.getElement().getClass().getName().lastIndexOf(46) + 1) : null);
        checkObject.put("elementName", check.getElementName());
        checkObject.put("enabled", check.getEnabled());
        checkObject.put("longMessage", check.getLongMessage());
        checkObject.put("objectType", check.getObjectType());
        checkObject.put("previewVisible", check.getPreviewVisible());
        checkObject.put("shortMessage", check.getShortMessage());
        checkObject.put("status", check.getStatus());
        return checkObject;
    }

    private static HashMap<String, String> checkActionItem(StiAction action) {
        HashMap<String, String> actionObject = new HashMap<String, String>();
        actionObject.put("name", action.getName());
        actionObject.put("description", action.getDescription());
        return actionObject;
    }

    private static ArrayList<HashMap<String, String>> getActions(StiCheck check) {
        ArrayList<HashMap<String, String>> actions = new ArrayList<HashMap<String, String>>();
        for (StiAction action : check.getActions()) {
            actions.add(StiReportCheckHelper.checkActionItem(action));
        }
        return actions;
    }

    private static void removeCheck(StiCheck check, List<StiCheck> checks) {
        if (checks != null && checks.contains(check)) {
            checks.remove(check);
        }
    }

    public static ArrayList<HashMap<String, Object>> getChecksJSCollection(List<StiCheck> checks) {
        ArrayList<HashMap<String, Object>> checkItems = new ArrayList<HashMap<String, Object>>();
        if (checks != null) {
            for (StiCheck check : checks) {
                checkItems.add(StiReportCheckHelper.checkItem(check));
            }
        }
        return checkItems;
    }

    private static void updateCurrentReport(StiReport report, HashMap parameters, HashMap callbackResult) throws ParserConfigurationException, IOException, TransformerException {
        callbackResult.put("selectedObjectName", parameters.get("selectedObjectName"));
        report.getInfo().setZoom(StiReportEdit.strToDouble((String)parameters.get("zoom")));
        if (parameters.containsKey("reportFile")) {
            report.setReportFile((String)parameters.get("reportFile"));
        }
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        callbackResult.put("reportGuid", parameters.get("reportGuid"));
    }

    private static Map<String, BufferedImage> createImage(StiCheck check) {
        if (!check.getPreviewVisible()) {
            return null;
        }
        return check.createPreviewImage();
    }

    private static int getErrorsCount(List<StiCheck> checks) {
        int errorsCount = 0;
        for (StiCheck check : checks) {
            if (check.getStatus() != StiCheckStatus.Error) continue;
            ++errorsCount;
        }
        return errorsCount;
    }

    private static void buildReportRenderingMessages(StiReport report, List<StiCheck> checks) {
        StiReport stiReport = report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        if (report.getReportRenderingMessages() != null && report.getReportRenderingMessages().size() > 0) {
            for (String message : report.getReportRenderingMessages()) {
                StiReportRenderingMessageCheck check = new StiReportRenderingMessageCheck();
                check.SetMessage(message);
                checks.add((StiCheck)check);
            }
        }
    }

    public static List<StiCheck> checkReport(HttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, boolean createReportCopy) throws StiException, IOException, SAXException, StiDeserializationException {
        StiCheckEngine engine = new StiCheckEngine();
        List checks = engine.checkReport(report);
        if (StiReportCheckHelper.getErrorsCount(checks) == 0) {
            StiReport reportForViewer = report;
            if (createReportCopy) {
                reportForViewer = StiReportEdit.cloneReport(report, false);
                reportForViewer.getRenderedPages().add(new StiPage(reportForViewer));
            }
            reportForViewer.Render(false);
            StiReportCheckHelper.buildReportRenderingMessages(reportForViewer, checks);
        }
        return checks;
    }

    public static void getCheckPreview(HttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap<String, Object> parameters, HashMap<String, Object> callbackResult) throws StiException, IOException, SAXException, StiDeserializationException {
        StiCheck check;
        Map<String, BufferedImage> images;
        List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, report, true);
        int checkIndex = Integer.parseInt(String.valueOf(parameters.get("checkIndex")));
        if (checks != null && checkIndex < checks.size() && (images = StiReportCheckHelper.createImage(check = checks.get(checkIndex))) != null && images.size() > 0) {
            BufferedImage img = images.containsKey("highlightedElementImage") ? images.get("highlightedElementImage") : images.get("elementImage");
            StiImage image = new StiImage(StiImageHelper.imageToBase64((BufferedImage)img, (StiImageFormat)StiImageFormat.Png));
            callbackResult.put("previewImage", StiReportEdit.imageToBase64(image));
        }
    }

    public static void actionCheck(HttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap<String, Object> parameters, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException, StiException, SAXException, StiDeserializationException {
        StiCheck check;
        List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, report, true);
        int checkIndex = Integer.parseInt(parameters.get("checkIndex").toString());
        int actionIndex = Integer.parseInt(parameters.get("actionIndex").toString());
        if (checks != null && checkIndex < checks.size() && (check = checks.get(checkIndex)).getActions() != null && actionIndex < check.getActions().size()) {
            StiAction action = (StiAction)check.getActions().get(actionIndex);
            boolean needUpdateReport = false;
            action.invoke(report, check.getElement(), check.getElementName());
            needUpdateReport = true;
            if (needUpdateReport) {
                StiReportCheckHelper.removeCheck(check, checks);
                callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                StiReportCheckHelper.updateCurrentReport(report, parameters, callbackResult);
            }
        }
    }

    public static void checkExpression(StiReport report, HashMap<String, Object> parameters, HashMap<String, Object> callbackResult) {
        StiParserException pex = StiParser.checkExpression((String)StiEncodingHelper.decodeString((String)parameters.get("expressionText")), (StiComponent)report.GetComponentByName((String)parameters.get("componentName")));
        callbackResult.put("checkResult", StiEncodingHelper.encode(pex != null ? pex.BaseMessage : "OK"));
    }
}

