/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.table.StiTableCell;
import com.stimulsoft.report.components.table.enums.StiTablceCellType;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class StiTableHelper {
    private StiTable table;
    private double zoom;

    public StiTableHelper(StiTable table, double zoom) {
        this.table = table;
        this.zoom = zoom;
    }

    public void executeJSCommand(HashMap<String, Object> parameters, HashMap<String, Object> callbackResult) throws ParserConfigurationException, IOException, TransformerException, JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String command = (String)parameters.get("command");
        result.put("command", command);
        ArrayList cellsNames = (ArrayList)parameters.get("cells");
        this.setSelectedCurrentCells(cellsNames);
        if ("changeColumnsOrRowsCount".equals(command)) {
            if ("columnCount".equals(parameters.get("propertyName"))) {
                this.table.setColumnCount(((Integer)parameters.get("countValue")).intValue());
            } else if ("rowCount".equals(parameters.get("propertyName"))) {
                this.table.setRowCount(((Integer)parameters.get("countValue")).intValue());
            } else if ("headerRowsCount".equals(parameters.get("propertyName"))) {
                this.table.setHeaderRowsCount(((Integer)parameters.get("countValue")).intValue());
            } else if ("footerRowsCount".equals(parameters.get("propertyName"))) {
                this.table.setFooterRowsCount(((Integer)parameters.get("countValue")).intValue());
            }
        } else if ("convertTo".equals(command)) {
            this.convertTableCell(parameters, result);
        } else if ("joinCells".equals(command)) {
            this.joinCells(this.getSelectedCellsByNames(cellsNames));
        } else if ("insertColumnToLeft".equals(command)) {
            this.table.InsertColumnToLeft(this.getFirstIndexX(this.getSelectedCellsByNames(cellsNames)));
        } else if ("insertColumnToRight".equals(command)) {
            this.table.InsertColumnToRight(this.getLastIndexX(this.getSelectedCellsByNames(cellsNames)));
        } else if ("deleteColumn".equals(command)) {
            this.table.DeleteColumns(this.getFirstIndexX(this.getSelectedCellsByNames(cellsNames)), this.getLastIndexX(this.getSelectedCellsByNames(cellsNames)));
        } else if ("insertRowAbove".equals(command)) {
            this.table.InsertRowAbove(this.getFirstIndexY(this.getSelectedCellsByNames(cellsNames)));
        } else if ("insertRowBelow".equals(command)) {
            this.table.InsertRowBelow(this.getLastIndexY(this.getSelectedCellsByNames(cellsNames)) + 1);
        } else if ("deleteRow".equals(command)) {
            this.table.DeleteRows(this.getFirstIndexY(this.getSelectedCellsByNames(cellsNames)), this.getLastIndexY(this.getSelectedCellsByNames(cellsNames)));
        } else if ("applyStyle".equals(command)) {
            // empty if block
        }
        if (!"convertTo".equals(parameters.get("command"))) {
            result.put("cells", this.getTableCellsForJS());
            result.put("tableProperties", StiReportEdit.getComponentMainProperties((StiComponent)this.table, this.zoom));
            if (!"changeColumnsOrRowsCount".equals(command)) {
                result.put("selectedCells", this.getSelectedCellNames());
            }
            if ("changeColumnsOrRowsCount".equals(command) || "insertRowAbove".equals(command) || "insertRowBelow".equals(command) || "deleteRow".equals(command)) {
                result.put("rebuildProps", StiReportEdit.getPropsRebuildPage(this.table.getReport(), this.table.getPage()));
            }
        }
        result.put("pageName", this.table.getPage().getName());
        result.put("tableName", this.table.getName());
        callbackResult.put("result", result);
    }

    private int getFirstIndexX(StiComponentsCollection selectedComponents) {
        Stack<Integer> allX = new Stack<Integer>();
        for (int index1 = 0; index1 < selectedComponents.size(); ++index1) {
            int row;
            int index;
            StiComponent selCell = (StiComponent)selectedComponents.get(index1);
            if (((IStiTableCell)selCell).getJoin()) {
                index = this.table.getComponents().indexOf((Object)selCell);
                row = index / this.table.getColumnCount();
                allX.push(index - row * this.table.getColumnCount());
                index = this.table.getComponents().indexOf((Object)((IStiTableCell)selCell).GetJoinComponentByIndex(0));
                row = index / this.table.getColumnCount();
                allX.push(index - row * this.table.getColumnCount());
                continue;
            }
            index = this.table.getComponents().indexOf((Object)selCell);
            row = index / this.table.getColumnCount();
            allX.push(index - row * this.table.getColumnCount());
        }
        int firstIndexX = (Integer)allX.pop();
        while (allX.size() > 0) {
            int index = (Integer)allX.pop();
            if (firstIndexX <= index) continue;
            firstIndexX = index;
        }
        return firstIndexX;
    }

    private int getLastIndexX(StiComponentsCollection selectedComponents) {
        int index;
        Stack<Integer> allX = new Stack<Integer>();
        for (int index1 = 0; index1 < selectedComponents.size(); ++index1) {
            index = this.table.getComponents().indexOf(selectedComponents.get(index1));
            int row = index / this.table.getColumnCount();
            allX.push(index - row * this.table.getColumnCount());
        }
        int lastIndexX = (Integer)allX.pop();
        while (allX.size() > 0) {
            index = (Integer)allX.pop();
            if (lastIndexX >= index) continue;
            lastIndexX = index;
        }
        return lastIndexX;
    }

    private int getFirstIndexY(StiComponentsCollection selectedComponents) {
        Stack<Integer> allY = new Stack<Integer>();
        for (int index1 = 0; index1 < selectedComponents.size(); ++index1) {
            int index;
            StiTableCell selCell = (StiTableCell)selectedComponents.get(index1);
            if (selCell.getJoin()) {
                index = this.table.getComponents().indexOf((Object)selCell.GetJoinComponentByIndex(0));
                allY.push(index / this.table.getColumnCount());
                continue;
            }
            index = this.table.getComponents().indexOf((Object)selCell);
            allY.push(index / this.table.getColumnCount());
        }
        int firstIndexY = (Integer)allY.pop();
        while (allY.size() > 0) {
            int index = (Integer)allY.pop();
            if (firstIndexY <= index) continue;
            firstIndexY = index;
        }
        return firstIndexY;
    }

    private int getLastIndexY(StiComponentsCollection selectedComponents) {
        Stack<Integer> allY = new Stack<Integer>();
        for (int index1 = 0; index1 < selectedComponents.size(); ++index1) {
            StiComponent selCell = (StiComponent)selectedComponents.get(index1);
            int index = this.table.getComponents().indexOf((Object)selCell);
            allY.push(index / this.table.getColumnCount());
        }
        int lastIndexY = (Integer)allY.pop();
        while (allY.size() > 0) {
            int index = (Integer)allY.pop();
            if (lastIndexY >= index) continue;
            lastIndexY = index;
        }
        return lastIndexY;
    }

    private void joinCells(StiComponentsCollection selectedComponents) {
        Integer[] allX = new Integer[selectedComponents.size()];
        Integer[] allY = new Integer[selectedComponents.size()];
        for (int index1 = 0; index1 < selectedComponents.size(); ++index1) {
            int index = this.table.getComponents().indexOf(selectedComponents.get(index1));
            allY[index1] = index / this.table.getColumnCount();
            allX[index1] = index - allY[index1] * this.table.getColumnCount();
        }
        int lastIndexX = allX[0];
        int lastIndexY = allY[0];
        for (int index1 = 1; index1 < allX.length; ++index1) {
            if (lastIndexX < allX[index1]) {
                lastIndexX = allX[index1];
            }
            if (lastIndexY >= allY[index1]) continue;
            lastIndexY = allY[index1];
        }
        ((IStiTableCell)this.table.getComponents().get(lastIndexY * this.table.getColumnCount() + lastIndexX)).setJoin(true);
        ((StiComponent)this.table.getComponents().get(lastIndexY * this.table.getColumnCount() + lastIndexX)).setIsSelected(true);
    }

    private void setSelectedCurrentCells(ArrayList<String> cellsNames) throws JSONException {
        for (StiComponent cell : this.table.getComponents()) {
            cell.setIsSelected(false);
        }
        for (String cellName : cellsNames) {
            StiComponent cell = this.table.getComponents().get(cellName);
            if (cell == null) continue;
            cell.setIsSelected(true);
        }
    }

    private ArrayList<String> getSelectedCellNames() {
        ArrayList<String> cellNames = new ArrayList<String>();
        for (StiComponent cell : this.table.getComponents()) {
            if (!cell.getIsSelected()) continue;
            cellNames.add(cell.getName());
        }
        return cellNames;
    }

    private StiComponentsCollection getSelectedCellsByNames(ArrayList<String> cellsNames) throws JSONException {
        StiComponentsCollection cells = new StiComponentsCollection();
        for (int i = 0; i < cellsNames.size(); ++i) {
            StiComponent cell = this.table.getComponents().get(cellsNames.get(i));
            if (cell == null || !cell.getEnabled()) continue;
            cells.add(cell);
        }
        return cells;
    }

    public static ArrayList<HashMap<String, Object>> getTableStyles() {
        ArrayList<HashMap<String, Object>> styles = new ArrayList<HashMap<String, Object>>();
        return styles;
    }

    public static ArrayList getTableCellsProperties(StiTable table, double zoom) throws ParserConfigurationException, IOException, TransformerException {
        ArrayList<HashMap<String, Object>> tableCells = new ArrayList<HashMap<String, Object>>();
        for (StiComponent cell : table.getComponents()) {
            tableCells.add(StiReportEdit.getComponentMainProperties(cell, zoom));
        }
        return tableCells;
    }

    private ArrayList getTableCellsForJS() throws ParserConfigurationException, IOException, TransformerException {
        ArrayList<HashMap<String, Object>> tableCells = new ArrayList<HashMap<String, Object>>();
        for (StiComponent cell : this.table.getComponents()) {
            tableCells.add(StiReportEdit.getComponentMainProperties(cell, this.zoom));
        }
        return tableCells;
    }

    private void convertTableCell(HashMap<String, Object> parameters, HashMap result) throws ParserConfigurationException, IOException, TransformerException, JSONException {
        StiComponentsCollection cells = this.getSelectedCellsByNames((ArrayList)parameters.get("cells"));
        StiTablceCellType cellType = StiTablceCellType.valueOf((String)((String)parameters.get("cellType")));
        ArrayList<HashMap<String, Object>> resultCells = new ArrayList<HashMap<String, Object>>();
        for (StiComponent component : cells) {
            IStiTableCell cell = component instanceof IStiTableCell ? (IStiTableCell)component : null;
            if (cell == null) continue;
            int indexCell = this.table.getComponents().indexOf((Object)component);
            cell.setCellType(cellType);
            StiComponent newCell = (StiComponent)this.table.getComponents().get(indexCell);
            resultCells.add(StiReportEdit.getComponentMainProperties(newCell, this.zoom));
        }
        result.put("cells", resultCells);
    }
}

