/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.webdesigner.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class StiWebDesignerOptionsHelper {
    public static HashMap<String, Object> getDefaultDesignerOptions() {
        HashMap<String, Object> defaultOptions = new HashMap<String, Object>();
        defaultOptions.put("showHeaders", StiSettings.getBoolValue((String)"StiDesigner", (String)"ShowHeaders", (Boolean)true));
        defaultOptions.put("showRulers", StiSettings.getBoolValue((String)"StiDesigner", (String)"ShowRulers", (Boolean)true));
        defaultOptions.put("showOrder", StiSettings.getBoolValue((String)"StiDesigner", (String)"ShowOrder", (Boolean)false));
        defaultOptions.put("runDesignerAfterInsert", StiSettings.getBoolValue((String)"StiDesigner", (String)"RunDesignerAfterInsert", (Boolean)true));
        defaultOptions.put("useLastFormat", StiSettings.getBoolValue((String)"StiDesigner", (String)"UseLastFormat", (Boolean)true));
        defaultOptions.put("showDimensionLines", StiSettings.getBoolValue((String)"StiDesigner", (String)"ShowDimensionLines", (Boolean)true));
        defaultOptions.put("generateLocalizedName", StiSettings.getBoolValue((String)"StiDesigner", (String)"GenerateLocalizedName", (Boolean)false));
        defaultOptions.put("alignToGrid", StiSettings.getBoolValue((String)"StiDesigner", (String)"AlignToGrid", (Boolean)true));
        defaultOptions.put("showGrid", StiSettings.getBoolValue((String)"StiDesigner", (String)"ShowGrid", (Boolean)true));
        defaultOptions.put("gridMode", StiSettings.getStringValue((String)"StiDesigner", (String)"GridMode", (String)"Lines").toString());
        defaultOptions.put("gridSizeInch", StiSettings.getDoubleValue((String)"StiDesigner", (String)"GridSizeInch", (Double)0.1).toString());
        defaultOptions.put("gridSizeHundredthsOfInch", StiSettings.getDoubleValue((String)"StiDesigner", (String)"GridSizeHundredthsOfInch", (Double)10.0).toString());
        defaultOptions.put("gridSizeCentimetres", StiSettings.getDoubleValue((String)"StiDesigner", (String)"GridSizeCentimetres", (Double)0.2).toString());
        defaultOptions.put("gridSizeMillimeters", StiSettings.getDoubleValue((String)"StiDesigner", (String)"GridSizeMillimeters", (Double)2.0).toString());
        defaultOptions.put("gridSizePixels", StiSettings.getDoubleValue((String)"StiDesigner", (String)"GridSizePixels", (Double)8.0).toString());
        defaultOptions.put("quickInfoType", StiSettings.getStringValue((String)"StiDesigner", (String)"QuickInfoType", (String)"None").toString());
        defaultOptions.put("quickInfoOverlay", StiSettings.getBoolValue((String)"StiDesigner", (String)"QuickInfoOverlay", (Boolean)true));
        defaultOptions.put("autoSaveInterval", StiSettings.getIntValue((String)"StiDesigner", (String)"AutoSaveInterval", (Integer)15).toString());
        defaultOptions.put("enableAutoSaveMode", StiSettings.getBoolValue((String)"StiDesigner", (String)"EnableAutoSaveMode", (Boolean)false));
        return defaultOptions;
    }

    public static HashMap<String, Object> getDesignerOptions(HttpServletRequest httpContext) throws JSONException {
        Cookie[] cookies = httpContext.getCookies();
        Cookie mdo = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("StimulsoftMobileDesignerOptions")) continue;
                mdo = cookies[i];
                break;
            }
        }
        if (mdo != null) {
            String designerOptions = mdo.getValue();
            designerOptions = StiEncodingHelper.decodeString(designerOptions.replace("%3D", "="));
            return StiJSONHelper.jsonToHash((JSONObject)new JSONObject(designerOptions));
        }
        return StiWebDesignerOptionsHelper.getDefaultDesignerOptions();
    }

    public static void applyDesignerOptionsToReport(HashMap<String, Object> designerOptions, StiReport report) throws Exception {
        if (designerOptions == null) {
            return;
        }
        for (String key : designerOptions.keySet()) {
            StiReportEdit.setPropertyValue(report, StiReportEdit.upperFirstChar(key), report.getInfo(), designerOptions.get(key));
        }
    }
}

