/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.table.StiTableCell;
import com.stimulsoft.report.components.table.StiTableCellCheckBox;
import com.stimulsoft.report.components.table.StiTableCellImage;
import com.stimulsoft.report.components.table.enums.StiTablceCellType;
import com.stimulsoft.report.dictionary.StiDataBuilder;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.enums.StiReportLanguageType;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStylesCollection;
import com.stimulsoft.report.styles.StiStylesCreator;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiWizardHelper {
    private static ArrayList<String> getGroupsFromDataSource(String dataSourceName, HashMap<String, Object> dataSources) throws JSONException {
        HashMap dataSource = (HashMap)dataSources.get(dataSourceName);
        ArrayList groups = (ArrayList)dataSource.get("groups");
        return groups;
    }

    private static ArrayList<HashMap<String, Object>> getColumnsFromDataSource(String dataSourceName, HashMap<String, Object> dataSources) throws JSONException {
        HashMap dataSource = (HashMap)dataSources.get(dataSourceName);
        ArrayList columns = (ArrayList)dataSource.get("columns");
        return columns;
    }

    private static ArrayList<HashMap<String, Object>> getSortFromDataSource(String dataSourceName, HashMap<String, Object> dataSources) throws JSONException {
        HashMap dataSource = (HashMap)dataSources.get(dataSourceName);
        ArrayList sort = (ArrayList)dataSource.get("sort");
        return sort;
    }

    private static ArrayList<HashMap<String, Object>> getFiltersFromDataSource(String dataSourceName, HashMap<String, Object> dataSources) throws JSONException {
        HashMap dataSource = (HashMap)dataSources.get(dataSourceName);
        ArrayList filters = (ArrayList)dataSource.get("filters");
        return filters;
    }

    private static HashMap<String, Object> getTotalsFromDataSource(String dataSourceName, HashMap<String, Object> dataSources) throws JSONException {
        HashMap dataSource = (HashMap)dataSources.get(dataSourceName);
        HashMap totals = (HashMap)dataSource.get("totals");
        return totals;
    }

    private static double alignToMaxGrid(StiPage page, double value, boolean converted) {
        if (converted) {
            value = page.getUnit().ConvertFromHInches(value);
        }
        return StiAlignValue.alignToMaxGrid((double)value, (double)page.getGridSize(), (boolean)page.getReport().getInfo().getAlignToGrid());
    }

    private static double alignToGrid(StiPage page, double value, boolean converted) {
        if (converted) {
            value = page.getUnit().ConvertFromHInches(value);
        }
        return StiAlignValue.alignToGrid((double)value, (double)page.getGridSize(), (boolean)page.getReport().getInfo().getAlignToGrid());
    }

    public static StiReport getReportFromWizardOptions(StiReport createdReport, HashMap<String, Object> reportOptions, HashMap<String, Object> wizardDataSources) throws JSONException {
        ArrayList dataSourcesOrder = (ArrayList)reportOptions.get("dataSourcesOrder");
        HashMap relations = (HashMap)reportOptions.get("relations");
        createdReport.setScriptLanguage("C".equals(reportOptions.get("language")) ? StiReportLanguageType.CSharp : StiReportLanguageType.VB);
        StiReportEdit.changeUnit(createdReport, (String)reportOptions.get("unit"));
        StiPage page = (StiPage)createdReport.getPages().get(createdReport.getCurrentPage());
        page.setOrientation("Portrait".equals(reportOptions.get("orientation")) ? StiPageOrientation.Portrait : StiPageOrientation.Landscape);
        StiDataSourcesCollection dataSources = new StiDataSourcesCollection();
        for (String key : wizardDataSources.keySet()) {
            StiDataSource dataSource = createdReport.getDataSources().get(key);
            if (dataSource == null) continue;
            dataSources.add((Object)dataSource);
        }
        if (dataSources.size() == 0) {
            return createdReport;
        }
        boolean first = true;
        String titleText = "";
        for (int numDataSource = 0; numDataSource < dataSourcesOrder.size(); ++numDataSource) {
            StiDataSource dataSource = dataSources.get((String)dataSourcesOrder.get(numDataSource));
            if (dataSource == null) continue;
            if (!first) {
                titleText = titleText + ", ";
            }
            titleText = titleText + dataSource.getAlias();
            first = false;
        }
        StiReportTitleBand reportTitleBand = new StiReportTitleBand();
        reportTitleBand.setName("ReportTitle");
        reportTitleBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 50.0, true));
        page.getComponents().add((StiComponent)reportTitleBand);
        StiText reportTitleText = new StiText();
        reportTitleText.setHorAlignment(StiTextHorAlignment.Center);
        reportTitleText.setVertAlignment(StiVertAlignment.Center);
        reportTitleText.setFont(new StiFont("Arial", 20.0, StiFontStyle.Bold));
        reportTitleText.setName("ReportTitleText");
        reportTitleText.setText(titleText);
        reportTitleText.setTop(0.0);
        reportTitleText.setLeft(0.0);
        reportTitleText.setWidth(page.getWidth());
        reportTitleText.setHeight(reportTitleBand.getHeight());
        reportTitleBand.getComponents().add((StiComponent)reportTitleText);
        StiDataBand masterDataband = null;
        HashMap<String, StiAggregateFunctionService> aggrs = new HashMap<String, StiAggregateFunctionService>();
        for (StiAggregateFunctionService as : StiAggregateFunctionService.getList()) {
            aggrs.put(as.getServiceName(), as);
        }
        int dataSourceIndex = 0;
        for (int numDataSource = 0; numDataSource < dataSourcesOrder.size(); ++numDataSource) {
            StiFilterMode filterMode;
            String dataSourceName;
            StiDataSource dataSource = dataSources.get((String)dataSourcesOrder.get(numDataSource));
            if (dataSource == null) {
                return createdReport;
            }
            StiHeaderBand headerBand = null;
            StiDataBand dataBand = null;
            StiTable table = null;
            StiFooterBand footerBand = null;
            String correctDataSourceName = StiNameValidator.CorrectName((String)dataSource.getName());
            String string = dataSourceName = dataSources.size() == 1 ? "" : correctDataSourceName;
            if (dataSources.size() == 1) {
                dataSourceName = "";
            }
            ArrayList<HashMap<String, Object>> columnItems = StiWizardHelper.getColumnsFromDataSource(dataSource.getName(), wizardDataSources);
            ArrayList<String> groupItems = StiWizardHelper.getGroupsFromDataSource(dataSource.getName(), wizardDataSources);
            HashMap<String, Object> totalItems = StiWizardHelper.getTotalsFromDataSource(dataSource.getName(), wizardDataSources);
            if ("Data".equals(reportOptions.get("componentType"))) {
                headerBand = new StiHeaderBand();
                headerBand.setName("Header" + dataSourceName);
                headerBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 20.0, true));
                page.getComponents().add((StiComponent)headerBand);
            }
            for (int index = 0; index < groupItems.size(); ++index) {
                StiGroupHeaderBand groupHeaderBand = new StiGroupHeaderBand();
                groupHeaderBand.setName(String.format("GroupHeader%s%s", dataSourceName, index));
                groupHeaderBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 30.0, true));
                groupHeaderBand.getCondition().setValue("{" + correctDataSourceName + "." + groupItems.get(index) + "}");
                page.getComponents().add((StiComponent)groupHeaderBand);
                StiText groupHeaderText = new StiText();
                groupHeaderText.setText("{" + correctDataSourceName + "." + groupItems.get(index) + "}");
                groupHeaderText.setVertAlignment(StiVertAlignment.Center);
                groupHeaderText.setFont(new StiFont("Arial", 16.0, StiFontStyle.Bold));
                groupHeaderText.setName(String.format("GroupHeaderText%s%s", dataSourceName, index));
                groupHeaderText.setTop(0.0);
                groupHeaderText.setLeft(0.0);
                groupHeaderText.setWidth(page.getWidth());
                groupHeaderText.setHeight(groupHeaderBand.getHeight());
                groupHeaderText.setCanGrow(true);
                groupHeaderText.setWordWrap(true);
                groupHeaderBand.getComponents().add((StiComponent)groupHeaderText);
            }
            if ("Data".equals(reportOptions.get("componentType"))) {
                dataBand = new StiDataBand();
                dataBand.setName("Data" + dataSourceName);
                dataBand.setDataSourceName(dataSource.getName());
                dataBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 20.0, true));
                dataBand.setMasterComponent(masterDataband);
                page.getComponents().add((StiComponent)dataBand);
                StiReportEdit.setSortDataProperty((Object)dataBand, StiWizardHelper.getSortFromDataSource(dataSource.getName(), wizardDataSources));
                if (relations.containsKey(dataSource.getName()) && ((Boolean)((HashMap)relations.get(dataSource.getName())).get("checked")).booleanValue()) {
                    dataBand.setDataRelationName((String)((HashMap)relations.get(dataSource.getName())).get("nameInSource"));
                }
                if (dataSourceIndex == 0) {
                    masterDataband = dataBand;
                }
            } else {
                table = new StiTable();
                table.setName("Data" + dataSourceName);
                table.setRowCount(3);
                table.setHeaderRowsCount(1);
                table.setFooterRowsCount(1);
                table.setColumnCount(columnItems.size());
                table.setDataSourceName(dataSource.getName());
                page.getComponents().add((StiComponent)table);
                table.setHeight(page.getGridSize() * 9.0);
                table.setWidth(page.getWidth());
                table.setMasterComponent((StiComponent)masterDataband);
                table.AutoSizeCells();
                StiReportEdit.setSortDataProperty((Object)table, StiWizardHelper.getSortFromDataSource(dataSource.getName(), wizardDataSources));
                if (relations.containsKey(dataSource.getName()) && ((Boolean)((HashMap)relations.get(dataSource.getName())).get("checked")).booleanValue()) {
                    table.setDataRelationName((String)((HashMap)relations.get(dataSource.getName())).get("nameInSource"));
                }
                if (dataSourceIndex == 0) {
                    masterDataband = table;
                }
            }
            boolean filterOn = (Boolean)((HashMap)wizardDataSources.get(dataSource.getName())).get("filterOn");
            StiFilterMode stiFilterMode = filterMode = "And".equals(((HashMap)wizardDataSources.get(dataSource.getName())).get("filterMode")) ? StiFilterMode.And : StiFilterMode.Or;
            if ("Data".equals(reportOptions.get("componentType"))) {
                dataBand.setFilterMode(filterMode);
                StiReportEdit.setFilterDataProperty((Object)dataBand, StiWizardHelper.getFiltersFromDataSource(dataSource.getName(), wizardDataSources));
                dataBand.setFilterOn(filterOn);
            } else {
                table.setFilterMode(filterMode);
                StiReportEdit.setFilterDataProperty((Object)table, StiWizardHelper.getFiltersFromDataSource(dataSource.getName(), wizardDataSources));
                table.setFilterOn(filterOn);
            }
            for (int index = 0; index < groupItems.size(); ++index) {
                StiGroupFooterBand groupFooterBand = new StiGroupFooterBand();
                groupFooterBand.setName(String.format("GroupFooter%s%s", dataSourceName, index));
                groupFooterBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 10.0, true));
                page.getComponents().add((StiComponent)groupFooterBand);
            }
            if ("Data".equals(reportOptions.get("componentType"))) {
                footerBand = new StiFooterBand();
                footerBand.setName("Footer" + dataSourceName);
                footerBand.setHeight(StiWizardHelper.alignToMaxGrid(page, 20.0, true));
                page.getComponents().add((StiComponent)footerBand);
            }
            if (columnItems.size() > 0) {
                double columnWidth = StiWizardHelper.alignToGrid(page, page.getWidth() / (double)columnItems.size(), false);
                if (columnWidth * (double)columnItems.size() > page.getWidth() && columnWidth > createdReport.getInfo().getGridSize() * 2.0) {
                    columnWidth -= createdReport.getInfo().getGridSize();
                }
                double pos = 0.0;
                int indexHeaderText = 1;
                int indexDataText = 1;
                int indexFooterText = 1;
                if ("Table".equals(reportOptions.get("componentType"))) {
                    indexHeaderText = 0;
                    indexDataText = table.getColumnCount();
                    indexFooterText = table.getColumnCount() * 2;
                }
                for (int indexColum = 0; indexColum < columnItems.size(); ++indexColum) {
                    String totalStr;
                    StiDataColumn dataColumn;
                    StiDataColumn column;
                    int index;
                    String columnFullName = correctDataSourceName + "." + columnItems.get(indexColum);
                    double width = columnWidth;
                    if (indexColum + 1 == columnItems.size() && (width = StiWizardHelper.alignToGrid(page, page.getWidth() - pos, false)) <= 0.0) {
                        width = page.getGridSize();
                    }
                    if ("Data".equals(reportOptions.get("componentType"))) {
                        StiText headerText = new StiText();
                        headerText.setVertAlignment(StiVertAlignment.Center);
                        headerText.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                        headerText.setName(String.format("HeaderText%s%s", dataSourceName, indexHeaderText));
                        headerText.setTop(0.0);
                        headerText.setLeft(pos);
                        headerText.setWidth(width);
                        headerText.setHeight(headerBand.getHeight());
                        headerText.setCanGrow(true);
                        headerText.setWordWrap(true);
                        if (columnItems.size() > 1) {
                            headerText.setGrowToHeight(true);
                        }
                        index = columnFullName.lastIndexOf(46);
                        column = StiDataBuilder.getColumnFromPath((String)columnFullName, (StiDictionary)createdReport.getDictionary());
                        if (column != null) {
                            headerText.setText(column.getAlias());
                        } else if (index == -1) {
                            headerText.setText(columnFullName);
                        } else {
                            headerText.setText(columnFullName.substring(index + 1));
                        }
                        ++indexHeaderText;
                        headerBand.getComponents().add((StiComponent)headerText);
                        dataColumn = StiDataBuilder.getColumnFromPath((String)columnFullName, (StiDictionary)dataBand.getReport().getDictionary());
                        if (dataColumn != null && (dataColumn.getType() == StiSystemTypeEnum.SystemDrawingImage || dataColumn.getType() == StiSystemTypeEnum.SystemByteArray)) {
                            StiImage dataImage = new StiImage();
                            dataImage.setName(String.format("DataImage%s%s", dataSourceName, indexDataText));
                            dataImage.setTop(0.0);
                            dataImage.setLeft(pos);
                            dataImage.setWidth(width);
                            dataImage.setHeight(dataBand.getHeight());
                            dataImage.setDataColumn(columnFullName);
                            dataImage.setCanGrow(true);
                            if (columnItems.size() > 1) {
                                dataImage.setGrowToHeight(true);
                            }
                            dataBand.getComponents().add((StiComponent)dataImage);
                        } else if (dataColumn != null && dataColumn.getType() == StiSystemTypeEnum.SystemBoolean) {
                            StiCheckBox dataCheck = new StiCheckBox();
                            dataCheck.setName(String.format("DataCheck%s%s", dataSourceName, indexDataText));
                            dataCheck.setTop(0.0);
                            dataCheck.setLeft(pos);
                            dataCheck.setWidth(width);
                            dataCheck.setHeight(dataBand.getHeight());
                            dataCheck.getChecked().setValue("{" + columnFullName + "}");
                            if (columnItems.size() > 1) {
                                dataCheck.setGrowToHeight(true);
                            }
                            dataBand.getComponents().add((StiComponent)dataCheck);
                        } else {
                            StiText dataText = new StiText();
                            dataText.setName(String.format("DataText%s%s", dataSourceName, indexDataText));
                            dataText.setTextQuality(StiTextQuality.Wysiwyg);
                            dataText.setVertAlignment(StiVertAlignment.Center);
                            dataText.setTop(0.0);
                            dataText.setLeft(pos);
                            dataText.setWidth(width);
                            dataText.setHeight(dataBand.getHeight());
                            dataText.setText("{" + columnFullName + "}");
                            dataText.setCanGrow(true);
                            if (columnItems.size() > 1) {
                                dataText.setGrowToHeight(true);
                            }
                            dataText.setWordWrap(true);
                            dataBand.getComponents().add((StiComponent)dataText);
                        }
                        ++indexDataText;
                        totalStr = "";
                        if (totalItems.size() > 0 && totalItems.containsKey(columnItems.get(indexColum))) {
                            totalStr = (String)totalItems.get(columnItems.get(indexColum));
                            totalStr = aggrs.containsKey(totalStr) && ((StiAggregateFunctionService)aggrs.get(totalStr)).getRecureParam() ? totalStr + "(" + columnFullName + ")" : totalStr + "()";
                            StiText footerText = new StiText();
                            footerText.setVertAlignment(StiVertAlignment.Center);
                            footerText.setHorAlignment(StiTextHorAlignment.Right);
                            footerText.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                            footerText.setName(String.format("FooterText%s%s", dataSourceName, indexFooterText));
                            footerText.setTop(0.0);
                            footerText.setLeft(pos);
                            footerText.setWidth(width);
                            footerText.setHeight(footerBand.getHeight());
                            footerText.setCanGrow(true);
                            if (columnItems.size() > 1) {
                                footerText.setGrowToHeight(true);
                            }
                            footerText.setWordWrap(true);
                            footerText.setText("{" + totalStr + "}");
                            ++indexFooterText;
                            footerBand.getComponents().add((StiComponent)footerText);
                        }
                    } else {
                        StiTableCell dataCell;
                        StiTableCell headerCell = (StiTableCell)table.getComponents().get(indexHeaderText);
                        headerCell.setVertAlignment(StiVertAlignment.Center);
                        headerCell.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                        headerCell.setWordWrap(true);
                        index = columnFullName.lastIndexOf(46);
                        column = StiDataBuilder.getColumnFromPath((String)columnFullName, (StiDictionary)createdReport.getDictionary());
                        if (column != null) {
                            headerCell.setText(column.getAlias());
                        } else if (index == -1) {
                            headerCell.setText(columnFullName);
                        } else {
                            headerCell.setText(columnFullName.substring(index + 1));
                        }
                        ++indexHeaderText;
                        dataColumn = StiDataBuilder.getColumnFromPath((String)columnFullName, (StiDictionary)table.getReport().getDictionary());
                        if (dataColumn != null && (dataColumn.getType() == StiSystemTypeEnum.SystemDrawingImage || dataColumn.getType() == StiSystemTypeEnum.SystemByteArray)) {
                            ((IStiTableCell)table.getComponents().get(indexDataText)).setCellType(StiTablceCellType.Image);
                            dataCell = (StiTableCellImage)table.getComponents().get(indexDataText);
                            dataCell.setVertAlignment(StiVertAlignment.Center);
                            dataCell.setCanGrow(true);
                            dataCell.setDataColumn(columnFullName);
                        } else if (dataColumn != null && dataColumn.getType() == StiSystemTypeEnum.SystemBoolean) {
                            ((IStiTableCell)table.getComponents().get(indexDataText)).setCellType(StiTablceCellType.CheckBox);
                            dataCell = (StiTableCellCheckBox)table.getComponents().get(indexDataText);
                            dataCell.setCanGrow(true);
                            dataCell.getChecked().setValue("{" + columnFullName + "}");
                        } else {
                            dataCell = (StiTableCell)table.getComponents().get(indexDataText);
                            dataCell.setCanGrow(true);
                            dataCell.setVertAlignment(StiVertAlignment.Center);
                            dataCell.setText("{" + columnFullName + "}");
                            dataCell.setWordWrap(true);
                        }
                        ++indexDataText;
                        totalStr = "";
                        if (totalItems.size() > 0 && totalItems.containsKey(columnItems.get(indexColum))) {
                            totalStr = (String)totalItems.get(columnItems.get(indexColum));
                            totalStr = aggrs.containsKey(totalStr) && ((StiAggregateFunctionService)aggrs.get(totalStr)).getRecureParam() ? totalStr + "(" + columnFullName + ")" : totalStr + "()";
                            StiTableCell footerCell = (StiTableCell)table.getComponents().get(indexFooterText);
                            footerCell.setVertAlignment(StiVertAlignment.Center);
                            footerCell.setHorAlignment(StiTextHorAlignment.Right);
                            footerCell.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                            footerCell.setWordWrap(true);
                            footerCell.setText("{" + totalStr + "}");
                            ++indexFooterText;
                        }
                    }
                    pos += columnWidth;
                }
            }
            ++dataSourceIndex;
        }
        String[] theme = ((String)reportOptions.get("theme")).split("_");
        StiColor colorBase = StiColorEnum.Empty.color();
        String themeName = "";
        String themeColor = theme[0];
        if (!"None".equals(themeColor)) {
            int themePercent = Integer.parseInt(theme[1]);
            if ("Red".equals(theme[0])) {
                colorBase = StiColor.fromArgb((int)144, (int)60, (int)57);
                themeName = StiLocalization.getValue((String)"PropertyColor", (String)"Red");
            } else if ("Green".equals(theme[0])) {
                colorBase = StiColor.fromArgb((int)117, (int)140, (int)72);
                themeName = StiLocalization.getValue((String)"PropertyColor", (String)"Green");
            } else if ("Blue".equals(theme[0])) {
                colorBase = StiColor.fromArgb((int)69, (int)98, (int)135);
                themeName = StiLocalization.getValue((String)"PropertyColor", (String)"Blue");
            } else if ("Gray".equals(theme[0])) {
                colorBase = StiColor.fromArgb((int)75, (int)75, (int)75);
                themeName = StiLocalization.getValue((String)"PropertyColor", (String)"Gray");
            }
            StiStylesCreator creator = new StiStylesCreator(createdReport);
            String text = themeName + " " + theme[1] + "%";
            StiColor color = StiColorUtils.light((StiColor)colorBase, (int)((byte)(Math.abs((themePercent - 100) / 25) * 45)));
            List styles = creator.createStyles(text, color);
            StiStylesCollection stylesCollection = new StiStylesCollection();
            for (StiBaseStyle style : styles) {
                stylesCollection.add((Object)style);
            }
            if (stylesCollection != null) {
                for (StiBaseStyle style : stylesCollection) {
                    createdReport.getStyles().add((Object)style);
                }
                String nameStylesCollection = null;
                for (StiBaseStyle style : stylesCollection) {
                    nameStylesCollection = style.getCollectionName();
                }
                createdReport.applyStyleCollection(nameStylesCollection);
            }
        }
        return createdReport;
    }
}

