/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.servlet;

import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.servlet.StiServlet;
import com.stimulsoft.webdesigner.StiWebDesignerActions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StiWebDesignerActionServlet
extends StiServlet {
    private static final long serialVersionUID = 6328262305717281579L;
    protected static final Logger LOG = Logger.getLogger(StiWebDesignerActionServlet.class.getName());
    public static final String ACTION_PARAM = "a";
    public static final String AJAX_SERVLET_MAPPING = "stimulsoft_webdesigner_action";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processing(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processing(request, response);
    }

    private void processing(HttpServletRequest request, HttpServletResponse response) {
        try {
            String action = request.getParameter(ACTION_PARAM);
            StringBuffer jsonParams = new StringBuffer();
            try {
                String line = null;
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jsonParams.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (action != null) {
                response.setHeader("X-UA-Compatible", "IE=Edge");
                StiWebActionResult result = null;
                if ("DesignerEvent".equals(action)) {
                    result = StiWebDesignerActions.designerEventResult(request, jsonParams);
                } else if ("GetReport".equals(action)) {
                    result = StiWebDesignerActions.getReportResult(request, jsonParams);
                }
                if (result instanceof StiWebActionResult) {
                    StiWebActionResult res = result;
                    if (StiValidationUtil.equals((Object)"text/javascript", (Object)res.getContentType()) || StiValidationUtil.equals((Object)"text/css", (Object)res.getContentType())) {
                        response.setHeader("Cache-Control", "public, max-age=31536000");
                    }
                    result.writeFile(response);
                } else if (result instanceof String) {
                    StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)((String)result));
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                e.printStackTrace(ps);
            }
            catch (IOException e1) {
                LOG.log(Level.SEVERE, "", e);
            }
        }
    }
}

