﻿
StiMobileDesigner.prototype.BandsMenu = function () {
    var menu = this.BaseMenu("bandsMenu", this.options.buttons.insertBands, "Down");

    var bands = ["StiReportTitleBand", "StiReportSummaryBand", "StiPageHeaderBand", "StiPageFooterBand", "StiGroupHeaderBand",
        "StiGroupFooterBand", "StiHeaderBand", "StiFooterBand", "StiColumnHeaderBand", "StiColumnFooterBand", "StiDataBand", "StiHierarchicalBand",
        "StiChildBand", "StiEmptyBand", "StiOverlayBand"];

    var header = document.createElement("div");
    header.innerHTML = this.loc.Report.Bands;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var countInRow = 0;
    var count = 0;
    for (var index in bands) {
        if (this.options.visibilityBands[bands[index]]) {
            var bandsButton = this.ComponentButton(bands[index], this.loc.Components[bands[index]], bands[index] + ".png", "ComponentButton",
                this.loc.HelpComponents[bands[index]]);
            count++;
            countInRow++;
            innerTable.addCellInLastRow(bandsButton);
            if (countInRow == 4) {
                innerTable.addRow();
                countInRow = 0;
            }
        }
    }

    if (count == 0 && this.options.buttons["insertBands"]) this.options.buttons["insertBands"].style.display = "none";

    return menu;
}