﻿
StiMobileDesigner.prototype.ComponentsMenu = function () {
    var menu = this.BaseMenu("componentsMenu", this.options.buttons.insertComponents, "Down");

    var components = this.options.isJava ? ["StiText", "StiImage", "StiBarCode", "StiPanel", "StiClone", "StiCheckBox",
                                              "StiSubReport", "StiZipCode", "StiTable", "StiCrossTab"] :
    		["StiText", "StiTextInCells", "StiRichText", "StiImage", "StiBarCode", "StiPanel", "StiClone", "StiCheckBox",
        "StiSubReport", "StiZipCode", "StiTable", "StiCrossTab"];

    var header = document.createElement("div");
    header.innerHTML = this.loc.Report.Components;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var countInRow = 0;
    var count = 0;
    for (var index in components) {
        if (this.options.visibilityComponents[components[index]] || this.options.visibilityBands[components[index]] || this.options.visibilityCrossBands[components[index]]) {
            var componentsButton = this.ComponentButton(components[index], this.loc.Components[components[index]], components[index] + ".png", "ComponentButton",
                this.loc.HelpComponents[components[index]], components[index] == "StiTable");
            countInRow++;
            count++;
            innerTable.addCellInLastRow(componentsButton);
            if (countInRow == 4) {
                innerTable.addRow();
                countInRow = 0;
            }
        }
    }

    if (count == 0 && this.options.buttons["insertComponents"]) this.options.buttons["insertComponents"].style.display = "none";

    menu.onshow = function () { }
        
    return menu;
}