﻿
StiMobileDesigner.prototype.CrossBandsMenu = function () {
    var menu = this.BaseMenu("crossBandsMenu", this.options.buttons.insertCrossBands, "Down");

    var crossBands = ["StiCrossGroupHeaderBand", "StiCrossGroupFooterBand", "StiCrossHeaderBand", "StiCrossFooterBand", "StiCrossDataBand"];

    var header = document.createElement("div");
    header.innerHTML = this.loc.Report.CrossBands;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var count = 0;
    var countInRow = 0;
    for (var index in crossBands) {
        if (this.options.visibilityCrossBands[crossBands[index]]) {
            var crossBandsButton = this.ComponentButton(crossBands[index], this.loc.Components[crossBands[index]], crossBands[index] + ".png", "ComponentButton",
                this.loc.HelpComponents[crossBands[index]]);
            countInRow++;
            count++;
            innerTable.addCellInLastRow(crossBandsButton);
            if (countInRow == 3) {
                innerTable.addRow();
                countInRow = 0;
            }
        }
    }

    if (count == 0 && this.options.buttons["insertCrossBands"]) this.options.buttons["insertCrossBands"].style.display = "none";

    return menu;
}