﻿
StiMobileDesigner.prototype.ShapesMenu = function () {
    var menu = this.BaseMenu("shapesMenu", this.options.buttons.insertShapes, "Down");

    var components = ["StiShape", "StiHorizontalLinePrimitive", "StiVerticalLinePrimitive", "StiRectanglePrimitive", "StiRoundedRectanglePrimitive"];

    var header = document.createElement("div");
    header.innerHTML = this.loc.Report.Shapes;
    header.className = "stiDesignerMenuHeader";
    menu.innerContent.appendChild(header);
    menu.header = header;

    var innerTable = this.CreateHTMLTable();
    innerTable.cellSpacing = 1;
    innerTable.style.marginTop = "1px";
    menu.innerContent.appendChild(innerTable);

    var countInRow = 0;
    var count = 0;
    for (var index in components) {
        if (this.options.visibilityComponents[components[index]] || this.options.visibilityBands[components[index]] || this.options.visibilityCrossBands[components[index]]) {
            var componentsButton = this.ComponentButton(components[index], this.loc.Components[components[index]], components[index] + ".png", "ComponentButton",
                this.loc.HelpComponents[components[index]]);
            countInRow++;
            count++;
            innerTable.addCellInLastRow(componentsButton);
            if (countInRow == 3) {
                innerTable.addRow();
                countInRow = 0;
            }
        }
    }

    if (count == 0 && this.options.buttons["insertShapes"]) this.options.buttons["insertShapes"].style.display = "none";

    return menu;
}