/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.ForwardClientSocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardClient {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClient.class);
    private URI tunnelServerURI;
    private URI localServerURI;
    private EventLoopGroup group;
    private Channel channel;

    public ForwardClient(URI tunnelServerURI, URI localServerURI, EventLoopGroup group) {
        this.tunnelServerURI = tunnelServerURI;
        this.localServerURI = localServerURI;
        this.group = group;
    }

    public void start() throws URISyntaxException, SSLException, InterruptedException {
        String host;
        String scheme = this.tunnelServerURI.getScheme() == null ? "ws" : this.tunnelServerURI.getScheme();
        String string = host = this.tunnelServerURI.getHost() == null ? "127.0.0.1" : this.tunnelServerURI.getHost();
        final int port = this.tunnelServerURI.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : this.tunnelServerURI.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            logger.error("Only WS(S) is supported, uri: {}", (Object)this.tunnelServerURI);
            return;
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        WebSocketClientHandshaker newHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)this.tunnelServerURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders());
        final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(newHandshaker);
        final ForwardClientSocketClientHandler forwardClientSocketClientHandler = new ForwardClientSocketClientHandler(this.localServerURI);
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), websocketClientHandler, forwardClientSocketClientHandler});
            }
        });
        this.channel = b.connect(this.tunnelServerURI.getHost(), port).sync().channel();
        logger.info("forward client connect to server success, uri: " + this.tunnelServerURI);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }
}

