/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.LocalFrameHandler;
import com.alibaba.arthas.tunnel.client.RelayHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClientSocketClientHandler.class);
    private ChannelPromise handshakeFuture;
    private Channel localChannel;
    private URI localServerURI;

    public ForwardClientSocketClientHandler(URI localServerURI) {
        this.localServerURI = localServerURI;
    }

    public void channelActive(ChannelHandlerContext ctx) {
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        logger.info("WebSocket Client disconnected!");
    }

    public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt.equals(WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE)) {
            NioEventLoopGroup group = new NioEventLoopGroup();
            try {
                logger.info("ForwardClientSocketClientHandler star connect local arthas server");
                WebSocketClientHandshaker newHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)this.localServerURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders());
                final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(newHandshaker);
                final LocalFrameHandler localFrameHandler = new LocalFrameHandler();
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) {
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), websocketClientHandler, localFrameHandler});
                    }
                });
                this.localChannel = b.connect(this.localServerURI.getHost(), this.localServerURI.getPort()).sync().channel();
                localFrameHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ChannelPipeline pipeline = future.channel().pipeline();
                        pipeline.remove((ChannelHandler)localFrameHandler);
                        pipeline.addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                    }
                });
                localFrameHandler.handshakeFuture().sync();
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(this.localChannel)});
                logger.info("ForwardClientSocketClientHandler connect local arthas server success");
            }
            catch (Throwable e) {
                logger.error("ForwardClientSocketClientHandler connect local arthas server error", e);
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

