/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.ChannelUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;

public final class RelayHandler
extends ChannelInboundHandlerAdapter {
    private final Channel relayChannel;

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg);
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.relayChannel.isActive()) {
            ChannelUtils.closeOnFlush(this.relayChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

