/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.TunnelClientSocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClient {
    private static final Logger logger = LoggerFactory.getLogger(TunnelClient.class);
    private String tunnelServerUrl;
    private String localServerUrl = "ws://127.0.0.1:8563/ws";
    private int reconnectDelay = 5;
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private Channel channel;
    private volatile String id;

    public ChannelFuture start() throws IOException, InterruptedException, URISyntaxException {
        return this.connect(false);
    }

    public ChannelFuture connect(boolean reconnect) throws SSLException, URISyntaxException, InterruptedException {
        String host;
        QueryStringEncoder queryEncoder = new QueryStringEncoder(this.tunnelServerUrl);
        queryEncoder.addParam("method", "agentRegister");
        if (this.id != null) {
            queryEncoder.addParam("id", this.id);
        }
        URI agentRegisterURI = queryEncoder.toUri();
        logger.info("Try to register arthas agent, uri: {}", (Object)agentRegisterURI);
        String scheme = agentRegisterURI.getScheme() == null ? "ws" : agentRegisterURI.getScheme();
        String string = host = agentRegisterURI.getHost() == null ? "127.0.0.1" : agentRegisterURI.getHost();
        final int port = agentRegisterURI.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : agentRegisterURI.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Only WS(S) is supported. tunnelServerUrl: " + this.tunnelServerUrl);
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        WebSocketClientHandshaker newHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)agentRegisterURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders());
        final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(newHandshaker);
        final TunnelClientSocketClientHandler handler = new TunnelClientSocketClientHandler(this);
        Bootstrap bs = new Bootstrap();
        ((Bootstrap)((Bootstrap)bs.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).remoteAddress(agentRegisterURI.getHost(), port).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), websocketClientHandler, handler});
            }
        });
        ChannelFuture connectFuture = bs.connect();
        if (reconnect) {
            connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.cause() != null) {
                        logger.error("connect to tunnel server error, uri: {}", (Object)TunnelClient.this.tunnelServerUrl, (Object)future.cause());
                    }
                }
            });
        }
        this.channel = connectFuture.sync().channel();
        return handler.registerFuture();
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.eventLoopGroup.shutdownGracefully();
    }

    public String getTunnelServerUrl() {
        return this.tunnelServerUrl;
    }

    public void setTunnelServerUrl(String tunnelServerUrl) {
        this.tunnelServerUrl = tunnelServerUrl;
    }

    public String getLocalServerUrl() {
        return this.localServerUrl;
    }

    public void setLocalServerUrl(String localServerUrl) {
        this.localServerUrl = localServerUrl;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

