/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.ForwardClient;
import com.alibaba.arthas.tunnel.client.TunnelClient;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TunnelClientSocketClientHandler.class);
    private TunnelClient tunnelClient;
    private ChannelPromise registerPromise;

    public TunnelClientSocketClientHandler(TunnelClient tunnelClient) {
        this.tunnelClient = tunnelClient;
    }

    public ChannelFuture registerFuture() {
        return this.registerPromise;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.registerPromise = ctx.newPromise();
    }

    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            String text = textFrame.text();
            logger.info("receive TextWebSocketFrame: {}", (Object)text);
            QueryStringDecoder queryDecoder = new QueryStringDecoder(text);
            Map parameters = queryDecoder.parameters();
            List methodList = (List)parameters.get("method");
            String method = null;
            if (methodList != null && !methodList.isEmpty()) {
                method = (String)methodList.get(0);
            }
            if ("agentRegister".equals(method)) {
                List idList = (List)parameters.get("id");
                if (idList != null && !idList.isEmpty()) {
                    this.tunnelClient.setId((String)idList.get(0));
                }
                this.registerPromise.setSuccess();
            }
            if ("startTunnel".equals(method)) {
                QueryStringEncoder queryEncoder = new QueryStringEncoder(this.tunnelClient.getTunnelServerUrl());
                queryEncoder.addParam("method", "openTunnel");
                queryEncoder.addParam("clientConnectionId", (String)((List)parameters.get("clientConnectionId")).get(0));
                queryEncoder.addParam("id", (String)((List)parameters.get("id")).get(0));
                URI forwardUri = queryEncoder.toUri();
                logger.info("start ForwardClient, uri: {}", (Object)forwardUri);
                ForwardClient forwardClient = new ForwardClient(forwardUri, new URI(this.tunnelClient.getLocalServerUrl()), this.tunnelClient.getEventLoopGroup());
                forwardClient.start();
            }
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                logger.error("try to reconnect to tunnel server, uri: {}", (Object)TunnelClientSocketClientHandler.this.tunnelClient.getTunnelServerUrl());
                try {
                    TunnelClientSocketClientHandler.this.tunnelClient.connect(true);
                }
                catch (Throwable e) {
                    logger.error("reconnect error", e);
                }
            }
        }, (long)this.tunnelClient.getReconnectDelay(), TimeUnit.SECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.registerPromise.isDone()) {
            this.registerPromise.setFailure(cause);
        }
        ctx.fireExceptionCaught(cause);
    }
}

