/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.penguin.korean;

import com.twitter.penguin.korean.KoreanPosJava;
import com.twitter.penguin.korean.KoreanTokenJava;
import com.twitter.penguin.korean.TwitterKoreanProcessor;
import com.twitter.penguin.korean.phrase_extractor.KoreanPhraseExtractor;
import com.twitter.penguin.korean.tokenizer.KoreanTokenizer;
import com.twitter.penguin.korean.tokenizer.Sentence;
import com.twitter.penguin.korean.util.KoreanPos;
import java.util.LinkedList;
import java.util.List;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public final class TwitterKoreanProcessorJava {
    public static CharSequence normalize(CharSequence text2) {
        return TwitterKoreanProcessor.normalize(text2);
    }

    public static Seq<KoreanTokenizer.KoreanToken> tokenize(CharSequence text2) {
        return TwitterKoreanProcessor.tokenize(text2);
    }

    public static void addNounsToDictionary(List<String> words) {
        TwitterKoreanProcessor.addNounsToDictionary((Seq<String>)JavaConversions.asScalaBuffer(words));
    }

    public static List<KoreanTokenJava> tokensToJavaKoreanTokenList(Seq<KoreanTokenizer.KoreanToken> tokens, boolean keepSpace) {
        Iterator tokenized = tokens.iterator();
        LinkedList<KoreanTokenJava> output = new LinkedList<KoreanTokenJava>();
        while (tokenized.hasNext()) {
            KoreanTokenizer.KoreanToken token = (KoreanTokenizer.KoreanToken)tokenized.next();
            if (!keepSpace && token.pos() == KoreanPos.Space()) continue;
            output.add(new KoreanTokenJava(token.text(), KoreanPosJava.valueOf(token.pos().toString()), token.offset(), token.length(), token.unknown()));
        }
        return output;
    }

    public static List<KoreanTokenJava> tokensToJavaKoreanTokenList(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return TwitterKoreanProcessorJava.tokensToJavaKoreanTokenList(tokens, false);
    }

    public static List<String> tokensToJavaStringList(Seq<KoreanTokenizer.KoreanToken> tokens, boolean keepSpace) {
        Iterator tokenized = tokens.iterator();
        LinkedList<String> output = new LinkedList<String>();
        while (tokenized.hasNext()) {
            KoreanTokenizer.KoreanToken token = (KoreanTokenizer.KoreanToken)tokenized.next();
            if (!keepSpace && token.pos() == KoreanPos.Space()) continue;
            output.add(token.text());
        }
        return output;
    }

    public static List<String> tokensToJavaStringList(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return TwitterKoreanProcessorJava.tokensToJavaStringList(tokens, false);
    }

    public static Seq<KoreanTokenizer.KoreanToken> stem(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return TwitterKoreanProcessor.stem(tokens);
    }

    public static List<Sentence> splitSentences(CharSequence text2) {
        return JavaConversions.seqAsJavaList(TwitterKoreanProcessor.splitSentences(text2));
    }

    public static List<KoreanPhraseExtractor.KoreanPhrase> extractPhrases(Seq<KoreanTokenizer.KoreanToken> tokens, boolean filterSpam, boolean includeHashtags) {
        return JavaConversions.seqAsJavaList(TwitterKoreanProcessor.extractPhrases(tokens, filterSpam, includeHashtags));
    }

    public static String detokenize(List<String> tokens) {
        return TwitterKoreanProcessor.detokenize((Iterable<String>)JavaConversions.iterableAsScalaIterable(tokens));
    }
}

