/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium.reader;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.ververica.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import com.ververica.cdc.connectors.mysql.debezium.task.MySqlBinlogSplitReadTask;
import com.ververica.cdc.connectors.mysql.debezium.task.context.StatefulTaskContext;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetKind;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.split.SourceRecords;
import com.ververica.cdc.connectors.mysql.source.utils.ChunkUtils;
import com.ververica.cdc.connectors.mysql.source.utils.RecordUtils;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogSplitReader
implements DebeziumReader<SourceRecords, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(BinlogSplitReader.class);
    private final StatefulTaskContext statefulTaskContext;
    private final ExecutorService executorService;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private MySqlBinlogSplitReadTask binlogSplitReadTask;
    private MySqlBinlogSplit currentBinlogSplit;
    private Map<TableId, List<FinishedSnapshotSplitInfo>> finishedSplitsInfo;
    private Map<TableId, BinlogOffset> maxSplitHighWatermarkMap;
    private final Set<TableId> pureBinlogPhaseTables;
    private Tables.TableFilter capturedTableFilter;
    private static final long READER_CLOSE_TIMEOUT = 30L;

    public BinlogSplitReader(StatefulTaskContext statefulTaskContext, int subTaskId) {
        this.statefulTaskContext = statefulTaskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = true;
        this.pureBinlogPhaseTables = new HashSet<TableId>();
    }

    @Override
    public void submitSplit(MySqlSplit mySqlSplit) {
        this.currentBinlogSplit = mySqlSplit.asBinlogSplit();
        this.configureFilter();
        this.statefulTaskContext.configure(this.currentBinlogSplit);
        this.capturedTableFilter = this.statefulTaskContext.getConnectorConfig().getTableFilters().dataCollectionFilter();
        this.queue = this.statefulTaskContext.getQueue();
        this.binlogSplitReadTask = new MySqlBinlogSplitReadTask(this.statefulTaskContext.getConnectorConfig(), this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getSignalEventDispatcher(), this.statefulTaskContext.getErrorHandler(), StatefulTaskContext.getClock(), this.statefulTaskContext.getTaskContext(), (MySqlStreamingChangeEventSourceMetrics)this.statefulTaskContext.getStreamingChangeEventSourceMetrics(), this.currentBinlogSplit, this.createEventFilter(this.currentBinlogSplit.getStartingOffset()));
        this.executorService.submit(() -> {
            try {
                this.binlogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)new BinlogSplitChangeEventSourceContextImpl(), this.statefulTaskContext.getOffsetContext());
            }
            catch (Exception e) {
                this.currentTaskRunning = false;
                LOG.error(String.format("Execute binlog read task for mysql split %s fail", this.currentBinlogSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentBinlogSplit == null || !this.currentTaskRunning;
    }

    @Override
    @Nullable
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.currentTaskRunning) {
            List batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
            ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
            sourceRecordsSet.add(new SourceRecords(sourceRecords));
            return sourceRecordsSet.iterator();
        }
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentBinlogSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.statefulTaskContext.getConnection() != null) {
                this.statefulTaskContext.getConnection().close();
            }
            if (this.statefulTaskContext.getBinaryLogClient() != null) {
                this.statefulTaskContext.getBinaryLogClient().disconnect();
            }
            this.currentTaskRunning = false;
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Failed to close the binlog split reader in {} seconds.", (Object)30L);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Close binlog reader error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (RecordUtils.isDataChangeRecord(sourceRecord)) {
            BinlogOffset position;
            TableId tableId = RecordUtils.getTableId(sourceRecord);
            if (this.hasEnterPureBinlogPhase(tableId, position = RecordUtils.getBinlogPosition(sourceRecord))) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                RowType splitKeyType = ChunkUtils.getChunkKeyColumnType(this.statefulTaskContext.getDatabaseSchema().tableFor(tableId), this.statefulTaskContext.getSourceConfig().getChunkKeyColumn());
                Object[] key = RecordUtils.getSplitKey(splitKeyType, sourceRecord, this.statefulTaskContext.getSchemaNameAdjuster());
                for (FinishedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!RecordUtils.splitKeyRangeContains(key, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureBinlogPhase(TableId tableId, BinlogOffset position) {
        if (this.pureBinlogPhaseTables.contains(tableId)) {
            return true;
        }
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            this.pureBinlogPhaseTables.add(tableId);
            return true;
        }
        return !this.maxSplitHighWatermarkMap.containsKey(tableId) && this.capturedTableFilter.isIncluded(tableId);
    }

    private void configureFilter() {
        List<FinishedSnapshotSplitInfo> finishedSplitInfos = this.currentBinlogSplit.getFinishedSnapshotSplitInfos();
        HashMap<TableId, List<FinishedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<FinishedSnapshotSplitInfo>>();
        HashMap<TableId, BinlogOffset> tableIdBinlogPositionMap = new HashMap<TableId, BinlogOffset>();
        if (finishedSplitInfos.isEmpty()) {
            for (TableId tableId : this.currentBinlogSplit.getTableSchemas().keySet()) {
                tableIdBinlogPositionMap.put(tableId, this.currentBinlogSplit.getStartingOffset());
            }
        } else {
            for (FinishedSnapshotSplitInfo finishedSplitInfo : finishedSplitInfos) {
                TableId tableId = finishedSplitInfo.getTableId();
                List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
                list.add(finishedSplitInfo);
                splitsInfoMap.put(tableId, list);
                BinlogOffset highWatermark = finishedSplitInfo.getHighWatermark();
                BinlogOffset maxHighWatermark = (BinlogOffset)tableIdBinlogPositionMap.get(tableId);
                if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
                tableIdBinlogPositionMap.put(tableId, highWatermark);
            }
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdBinlogPositionMap;
        this.pureBinlogPhaseTables.clear();
    }

    private Predicate<Event> createEventFilter(BinlogOffset startingOffset) {
        if (BinlogOffsetKind.TIMESTAMP.equals((Object)startingOffset.getOffsetKind())) {
            long startTimestampSec = startingOffset.getTimestampSec();
            return event -> EventType.HEARTBEAT.equals((Object)event.getHeader().getEventType()) || event.getHeader().getTimestamp() >= startTimestampSec * 1000L;
        }
        return event -> true;
    }

    public void stopBinlogReadTask() {
        this.currentTaskRunning = false;
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private class BinlogSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private BinlogSplitChangeEventSourceContextImpl() {
        }

        public boolean isRunning() {
            return BinlogSplitReader.this.currentTaskRunning;
        }
    }
}

