/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.source;

import com.mysql.jdbc.ResultSetMetaData;
import com.oceanbase.clogproxy.client.LogProxyClient;
import com.oceanbase.clogproxy.client.config.AbstractConnectionConfig;
import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.config.ObReaderConfig;
import com.oceanbase.clogproxy.client.exception.LogProxyClientException;
import com.oceanbase.clogproxy.client.listener.RecordListener;
import com.oceanbase.clogproxy.client.util.ClientIdGenerator;
import com.oceanbase.oms.logmessage.DataMessage;
import com.oceanbase.oms.logmessage.LogMessage;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseConnection;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseJdbcConverter;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseSchemaUtils;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseTableSchema;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import io.debezium.relational.TableSchema;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseRichSourceFunction<T>
extends RichSourceFunction<T>
implements CheckpointListener,
CheckpointedFunction,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 2844054619864617340L;
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseRichSourceFunction.class);
    private final boolean snapshot;
    private final String username;
    private final String password;
    private final String tenantName;
    private final String databaseName;
    private final String tableName;
    private final String hostname;
    private final Integer port;
    private final Duration connectTimeout;
    private final String rsList;
    private final String logProxyHost;
    private final int logProxyPort;
    private final long startTimestamp;
    private final ZoneOffset zoneOffset;
    private final DebeziumDeserializationSchema<T> deserializer;
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean(false);
    private final List<LogMessage> logMessageBuffer = new LinkedList<LogMessage>();
    private transient Map<String, TableSchema> tableSchemaMap;
    private volatile transient long resolvedTimestamp;
    private volatile transient OceanBaseConnection snapshotConnection;
    private transient LogProxyClient logProxyClient;
    private transient ListState<Long> offsetState;
    private transient OutputCollector<T> outputCollector;

    public OceanBaseRichSourceFunction(boolean snapshot, long startTimestamp, String username, String password, String tenantName, String databaseName, String tableName, String hostname, Integer port, Duration connectTimeout, String rsList, String logProxyHost, int logProxyPort, ZoneId serverTimeZone, DebeziumDeserializationSchema<T> deserializer) {
        this.snapshot = snapshot;
        this.username = username;
        this.password = password;
        this.tenantName = tenantName;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.hostname = hostname;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.rsList = rsList;
        this.logProxyHost = logProxyHost;
        this.logProxyPort = logProxyPort;
        this.startTimestamp = startTimestamp;
        this.zoneOffset = serverTimeZone.getRules().getOffset(Instant.now());
        this.deserializer = deserializer;
    }

    public void open(Configuration config) throws Exception {
        super.open(config);
        this.outputCollector = new OutputCollector();
        this.tableSchemaMap = new ConcurrentHashMap<String, TableSchema>();
        this.resolvedTimestamp = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        ((OutputCollector)this.outputCollector).context = ctx;
        LOG.info("Start readChangeEvents process");
        this.readChangeEvents();
        if (this.shouldReadSnapshot()) {
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                try {
                    if (this.snapshotConnection == null) {
                        this.snapshotConnection = new OceanBaseConnection(this.hostname, this.port, this.username, this.password, this.connectTimeout, ((Object)((Object)this)).getClass().getClassLoader());
                    }
                    this.readSnapshot();
                }
                finally {
                    if (this.snapshotConnection != null) {
                        this.snapshotConnection.close();
                    }
                }
                LOG.info("Snapshot reading finished");
            }
        }
        LOG.info("Skip snapshot read");
        this.logProxyClient.join();
    }

    protected void readSnapshot() {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        try {
            String sql = String.format("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='BASE TABLE' and TABLE_SCHEMA REGEXP '%s' and TABLE_NAME REGEXP '%s'", this.databaseName, this.tableName);
            this.snapshotConnection.query(sql, rs -> {
                while (rs.next()) {
                    tableMap.put(rs.getString(1), rs.getString(2));
                }
            });
        }
        catch (SQLException e) {
            LOG.error("Query database and table name failed", (Throwable)e);
            throw new FlinkRuntimeException((Throwable)e);
        }
        tableMap.forEach(this::readSnapshotFromTable);
        this.snapshotCompleted.set(true);
    }

    private void readSnapshotFromTable(String databaseName, String tableName) {
        String topicName = this.getDefaultTopicName(this.tenantName, databaseName, tableName);
        Map<String, String> partition = this.getSourcePartition(this.tenantName, databaseName, tableName);
        Map<String, Object> offset = this.getSourceOffset(this.resolvedTimestamp);
        String fullName = String.format("`%s`.`%s`", databaseName, tableName);
        String selectSql = "SELECT * FROM " + fullName;
        try {
            this.snapshotConnection.query(selectSql, rs -> {
                ResultSetMetaData metaData = (ResultSetMetaData)rs.getMetaData();
                String[] columnNames = new String[metaData.getColumnCount()];
                int[] jdbcTypes = new int[metaData.getColumnCount()];
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    columnNames[i] = metaData.getColumnName(i + 1);
                    jdbcTypes[i] = OceanBaseJdbcConverter.getType(metaData.getColumnType(i + 1), metaData.getColumnTypeName(i + 1));
                }
                TableSchema tableSchema = this.tableSchemaMap.get(topicName);
                if (tableSchema == null) {
                    tableSchema = OceanBaseTableSchema.getTableSchema(topicName, databaseName, tableName, columnNames, jdbcTypes, this.zoneOffset);
                    this.tableSchemaMap.put(topicName, tableSchema);
                }
                Struct source = OceanBaseSchemaUtils.sourceStruct(this.tenantName, databaseName, tableName, null, null);
                while (rs.next()) {
                    Struct value = new Struct(tableSchema.valueSchema());
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        value.put(columnNames[i], OceanBaseJdbcConverter.getField(jdbcTypes[i], rs.getObject(i + 1)));
                    }
                    Struct struct = tableSchema.getEnvelopeSchema().create((Object)value, source, null);
                    try {
                        this.deserializer.deserialize(new SourceRecord(partition, offset, topicName, null, null, null, struct.schema(), (Object)struct), this.outputCollector);
                    }
                    catch (Exception e) {
                        LOG.error("Deserialize snapshot record failed ", (Throwable)e);
                        throw new FlinkRuntimeException((Throwable)e);
                    }
                }
            });
        }
        catch (SQLException e) {
            LOG.error("Read snapshot from table " + fullName + " failed", (Throwable)e);
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    protected void readChangeEvents() throws InterruptedException {
        String tableWhiteList = String.format("%s.%s.%s", this.tenantName, this.databaseName, this.tableName);
        ObReaderConfig obReaderConfig = new ObReaderConfig();
        obReaderConfig.setRsList(this.rsList);
        obReaderConfig.setUsername(this.username);
        obReaderConfig.setPassword(this.password);
        obReaderConfig.setTableWhiteList(tableWhiteList);
        if (this.resolvedTimestamp > 0L) {
            obReaderConfig.setStartTimestamp(Long.valueOf(this.resolvedTimestamp));
            LOG.info("Read change events from resolvedTimestamp: {}", (Object)this.resolvedTimestamp);
        } else {
            obReaderConfig.setStartTimestamp(Long.valueOf(this.startTimestamp));
            LOG.info("Read change events from startTimestamp: {}", (Object)this.startTimestamp);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        ClientConf.USER_DEFINED_CLIENTID = ClientIdGenerator.generate() + tableWhiteList;
        this.logProxyClient = new LogProxyClient(this.logProxyHost, this.logProxyPort, (AbstractConnectionConfig)obReaderConfig);
        this.logProxyClient.addListener(new RecordListener(){
            boolean started = false;

            public void notify(LogMessage message) {
                switch (message.getOpt()) {
                    case HEARTBEAT: 
                    case BEGIN: {
                        if (this.started) break;
                        this.started = true;
                        latch.countDown();
                        break;
                    }
                    case INSERT: 
                    case UPDATE: 
                    case DELETE: {
                        if (!this.started) break;
                        OceanBaseRichSourceFunction.this.logMessageBuffer.add(message);
                        break;
                    }
                    case COMMIT: {
                        if (OceanBaseRichSourceFunction.this.shouldReadSnapshot() && !OceanBaseRichSourceFunction.this.snapshotCompleted.get()) break;
                        OceanBaseRichSourceFunction.this.logMessageBuffer.forEach(msg -> {
                            try {
                                OceanBaseRichSourceFunction.this.deserializer.deserialize(OceanBaseRichSourceFunction.this.getRecordFromLogMessage(msg), (Collector)OceanBaseRichSourceFunction.this.outputCollector);
                            }
                            catch (Exception e) {
                                throw new FlinkRuntimeException((Throwable)e);
                            }
                        });
                        OceanBaseRichSourceFunction.this.logMessageBuffer.clear();
                        OceanBaseRichSourceFunction.this.resolvedTimestamp = Long.parseLong(message.getTimestamp());
                        break;
                    }
                    case DDL: {
                        LOG.trace("Ddl: {}", (Object)((DataMessage.Record.Field)message.getFieldList().get(0)).getValue().toString());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported type: " + message.getOpt());
                    }
                }
            }

            public void onException(LogProxyClientException e) {
                LOG.error("LogProxyClient exception", (Throwable)e);
                OceanBaseRichSourceFunction.this.logProxyClient.stop();
            }
        });
        this.logProxyClient.start();
        LOG.info("LogProxyClient started");
        latch.await();
        LOG.info("LogProxyClient packet processing started");
    }

    private SourceRecord getRecordFromLogMessage(LogMessage message) throws Exception {
        Struct struct;
        String databaseName = message.getDbName().replace(this.tenantName + ".", "");
        String topicName = this.getDefaultTopicName(this.tenantName, databaseName, message.getTableName());
        if (this.tableSchemaMap.get(topicName) == null) {
            String[] columnNames = new String[message.getFieldCount()];
            int[] jdbcTypes = new int[message.getFieldCount()];
            int i = 0;
            for (DataMessage.Record.Field field : message.getFieldList()) {
                if (message.getOpt() == DataMessage.Record.Type.UPDATE && field.isPrev()) continue;
                columnNames[i] = field.getFieldname();
                jdbcTypes[i] = OceanBaseJdbcConverter.getType(field.getType());
                ++i;
            }
            TableSchema tableSchema = OceanBaseTableSchema.getTableSchema(topicName, databaseName, this.tableName, columnNames, jdbcTypes, this.zoneOffset);
            this.tableSchemaMap.put(topicName, tableSchema);
        }
        Struct source = OceanBaseSchemaUtils.sourceStruct(this.tenantName, databaseName, message.getTableName(), message.getTimestamp(), message.getOB10UniqueId());
        switch (message.getOpt()) {
            case INSERT: {
                Struct after = this.getLogValueStruct(topicName, message.getFieldList());
                struct = this.tableSchemaMap.get(topicName).getEnvelopeSchema().create((Object)after, source, null);
                break;
            }
            case UPDATE: {
                ArrayList<DataMessage.Record.Field> beforeFields = new ArrayList<DataMessage.Record.Field>();
                ArrayList<DataMessage.Record.Field> afterFields = new ArrayList<DataMessage.Record.Field>();
                for (DataMessage.Record.Field field : message.getFieldList()) {
                    if (field.isPrev()) {
                        beforeFields.add(field);
                        continue;
                    }
                    afterFields.add(field);
                }
                Struct after = this.getLogValueStruct(topicName, afterFields);
                Struct before = this.getLogValueStruct(topicName, beforeFields);
                struct = this.tableSchemaMap.get(topicName).getEnvelopeSchema().update((Object)before, after, source, null);
                break;
            }
            case DELETE: {
                Struct before = this.getLogValueStruct(topicName, message.getFieldList());
                struct = this.tableSchemaMap.get(topicName).getEnvelopeSchema().delete((Object)before, source, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported dml type: " + message.getOpt());
            }
        }
        return new SourceRecord(this.getSourcePartition(this.tenantName, databaseName, message.getTableName()), this.getSourceOffset(Long.parseLong(message.getTimestamp())), topicName, null, null, null, struct.schema(), (Object)struct);
    }

    private boolean shouldReadSnapshot() {
        return this.resolvedTimestamp == -1L && this.snapshot;
    }

    private String getDefaultTopicName(String tenantName, String databaseName, String tableName) {
        return String.format("%s.%s.%s", tenantName, databaseName, tableName);
    }

    private Map<String, String> getSourcePartition(String tenantName, String databaseName, String tableName) {
        HashMap<String, String> sourcePartition = new HashMap<String, String>();
        sourcePartition.put("tenant", tenantName);
        sourcePartition.put("database", databaseName);
        sourcePartition.put("table", tableName);
        return sourcePartition;
    }

    private Map<String, Object> getSourceOffset(long timestamp) {
        HashMap<String, Object> sourceOffset = new HashMap<String, Object>();
        sourceOffset.put("timestamp", timestamp);
        return sourceOffset;
    }

    private Struct getLogValueStruct(String topicName, List<DataMessage.Record.Field> fieldList) {
        TableSchema tableSchema = this.tableSchemaMap.get(topicName);
        Struct value = new Struct(tableSchema.valueSchema());
        for (DataMessage.Record.Field field : fieldList) {
            try {
                Schema fieldSchema = tableSchema.valueSchema().field(field.getFieldname()).schema();
                Object fieldValue = OceanBaseJdbcConverter.getField(fieldSchema.type(), field.getType(), field.getValue());
                value.put(field.getFieldname(), fieldValue);
            }
            catch (NumberFormatException e) {
                tableSchema = OceanBaseTableSchema.upcastingTableSchema(topicName, tableSchema, fieldList.stream().collect(Collectors.toMap(DataMessage.Record.Field::getFieldname, f -> f.getValue().toString())));
                this.tableSchemaMap.put(topicName, tableSchema);
                return this.getLogValueStruct(topicName, fieldList);
            }
        }
        return value;
    }

    public void notifyCheckpointComplete(long l) {
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializer.getProducedType();
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        LOG.info("snapshotState checkpoint: {} at resolvedTimestamp: {}", (Object)context.getCheckpointId(), (Object)this.resolvedTimestamp);
        this.offsetState.clear();
        this.offsetState.add((Object)this.resolvedTimestamp);
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        Iterator iterator;
        LOG.info("initialize checkpoint");
        this.offsetState = context.getOperatorStateStore().getListState(new ListStateDescriptor("resolvedTimestampState", (TypeSerializer)LongSerializer.INSTANCE));
        if (context.isRestored() && (iterator = ((Iterable)this.offsetState.get()).iterator()).hasNext()) {
            Long offset = (Long)iterator.next();
            this.resolvedTimestamp = offset;
            LOG.info("Restore State from resolvedTimestamp: {}", (Object)this.resolvedTimestamp);
            return;
        }
    }

    public void cancel() {
        try {
            if (this.snapshotConnection != null) {
                this.snapshotConnection.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Failed to close snapshotConnection", (Throwable)e);
        }
        if (this.logProxyClient != null) {
            this.logProxyClient.stop();
        }
    }

    private static class OutputCollector<T>
    implements Collector<T> {
        private SourceFunction.SourceContext<T> context;

        private OutputCollector() {
        }

        public void collect(T record) {
            this.context.collect(record);
        }

        public void close() {
        }
    }
}

