/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.source;

import com.ververica.cdc.connectors.oceanbase.source.OceanBaseJdbcConverter;
import com.ververica.cdc.connectors.oceanbase.source.OceanBaseSchemaUtils;
import io.debezium.data.Envelope;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.util.SchemaNameAdjuster;
import java.math.BigInteger;
import java.time.ZoneOffset;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class OceanBaseTableSchema {
    public static TableSchemaBuilder tableSchemaBuilder(ZoneOffset zoneOffset) {
        return new TableSchemaBuilder(OceanBaseJdbcConverter.valueConverterProvider(zoneOffset), SchemaNameAdjuster.create(), new CustomConverterRegistry(null), OceanBaseSchemaUtils.sourceSchema(), false);
    }

    public static TableId tableId(String databaseName, String tableName) {
        return new TableId(databaseName, null, tableName);
    }

    public static Column getColumn(String name, int jdbcType) {
        ColumnEditor columnEditor = Column.editor().name(name).jdbcType(jdbcType).optional(true).scale(Integer.valueOf(0));
        if (columnEditor.jdbcType() == 93 || columnEditor.jdbcType() == -7) {
            columnEditor.length(6);
        }
        return columnEditor.create();
    }

    public static TableSchema getTableSchema(String topicName, String databaseName, String tableName, String[] columnNames, int[] jdbcTypes, ZoneOffset zoneOffset) {
        TableEditor tableEditor = Table.editor().tableId(OceanBaseTableSchema.tableId(databaseName, tableName));
        for (int i = 0; i < columnNames.length; ++i) {
            tableEditor.addColumn(OceanBaseTableSchema.getColumn(columnNames[i], jdbcTypes[i]));
        }
        return OceanBaseTableSchema.tableSchemaBuilder(zoneOffset).create(null, Envelope.schemaName((String)topicName), tableEditor.create(), null, null, null);
    }

    public static Schema upcastingSchemaType(Schema schema, String value) {
        BigInteger bigInt;
        if (schema.type().equals((Object)Schema.Type.INT32) && Long.parseLong(value) > Integer.MAX_VALUE) {
            return Schema.INT64_SCHEMA;
        }
        if (schema.type().equals((Object)Schema.Type.INT64) && (bigInt = new BigInteger(value)).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            return Schema.STRING_SCHEMA;
        }
        return schema;
    }

    public static Schema upcastingValueSchema(Schema valueSchema, Map<String, String> fields) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            Schema fieldSchema = valueSchema.field(entry.getKey()).schema();
            fieldSchema = OceanBaseTableSchema.upcastingSchemaType(fieldSchema, entry.getValue());
            schemaBuilder.field(entry.getKey(), fieldSchema);
        }
        return schemaBuilder.build();
    }

    public static Envelope getEnvelope(String name, Schema valueSchema) {
        return Envelope.defineSchema().withName(name).withRecord(valueSchema).withSource(OceanBaseSchemaUtils.sourceSchema()).build();
    }

    public static TableSchema upcastingTableSchema(String topicName, TableSchema tableSchema, Map<String, String> fields) {
        Schema valueSchema = OceanBaseTableSchema.upcastingValueSchema(tableSchema.valueSchema(), fields);
        return new TableSchema(tableSchema.id(), null, null, OceanBaseTableSchema.getEnvelope(Envelope.schemaName((String)topicName), valueSchema), valueSchema, null);
    }
}

