/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.connectors.oceanbase.OceanBaseSource;
import com.ververica.cdc.connectors.oceanbase.table.OceanBaseReadableMetadata;
import com.ververica.cdc.connectors.oceanbase.table.StartupMode;
import com.ververica.cdc.debezium.table.MetadataConverter;
import com.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class OceanBaseTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final StartupMode startupMode;
    private final Long startupTimestamp;
    private final String username;
    private final String password;
    private final String tenantName;
    private final String databaseName;
    private final String tableName;
    private final String hostname;
    private final Integer port;
    private final Duration connectTimeout;
    private final ZoneId serverTimeZone;
    private final String rsList;
    private final String logProxyHost;
    private final Integer logProxyPort;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public OceanBaseTableSource(ResolvedSchema physicalSchema, StartupMode startupMode, Long startupTimestamp, String username, String password, String tenantName, String databaseName, String tableName, String hostname, Integer port, Duration connectTimeout, ZoneId serverTimeZone, String rsList, String logProxyHost, int logProxyPort) {
        this.physicalSchema = physicalSchema;
        this.startupMode = startupMode;
        this.startupTimestamp = startupTimestamp;
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.tenantName = (String)Preconditions.checkNotNull((Object)tenantName);
        this.databaseName = (String)Preconditions.checkNotNull((Object)databaseName);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.hostname = hostname;
        this.port = port;
        this.serverTimeZone = serverTimeZone;
        this.connectTimeout = connectTimeout;
        this.rsList = (String)Preconditions.checkNotNull((Object)rsList);
        this.logProxyHost = (String)Preconditions.checkNotNull((Object)logProxyHost);
        this.logProxyPort = logProxyPort;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation resultTypeInfo = context.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo(resultTypeInfo).setServerTimeZone(this.serverTimeZone).build();
        OceanBaseSource.Builder builder = OceanBaseSource.builder().startupMode(this.startupMode).startupTimestamp(this.startupTimestamp).username(this.username).password(this.password).tenantName(this.tenantName).databaseName(this.databaseName).tableName(this.tableName).hostname(this.hostname).port(this.port).connectTimeout(this.connectTimeout).rsList(this.rsList).logProxyHost(this.logProxyHost).logProxyPort(this.logProxyPort).serverTimeZone(this.serverTimeZone).deserializer(deserializer);
        return SourceFunctionProvider.of(builder.build(), (boolean)false);
    }

    protected MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(OceanBaseReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(OceanBaseReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(OceanBaseReadableMetadata.values()).collect(Collectors.toMap(OceanBaseReadableMetadata::getKey, OceanBaseReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public DynamicTableSource copy() {
        OceanBaseTableSource source = new OceanBaseTableSource(this.physicalSchema, this.startupMode, this.startupTimestamp, this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.hostname, this.port, this.connectTimeout, this.serverTimeZone, this.rsList, this.logProxyHost, this.logProxyPort);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OceanBaseTableSource that = (OceanBaseTableSource)o;
        return Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals((Object)this.startupMode, (Object)that.startupMode) && Objects.equals(this.startupTimestamp, that.startupTimestamp) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tenantName, that.tenantName) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.port, that.port) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.rsList, that.rsList) && Objects.equals(this.logProxyHost, that.logProxyHost) && Objects.equals(this.logProxyPort, that.logProxyPort) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.physicalSchema, this.startupMode, this.startupTimestamp, this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.hostname, this.port, this.connectTimeout, this.serverTimeZone, this.rsList, this.logProxyHost, this.logProxyPort, this.producedDataType, this.metadataKeys});
    }

    public String asSummaryString() {
        return "OceanBase-CDC";
    }
}

