/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.eventstore;

import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.MapListener;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.ConcurrentMapEventStore;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastEventStore
extends ConcurrentMapEventStore {
    private static final Logger log = LoggerFactory.getLogger(HazelcastEventStore.class);

    public HazelcastEventStore(IMap<InstanceId, List<InstanceEvent>> eventLogs) {
        this(100, eventLogs);
    }

    public HazelcastEventStore(int maxLogSizePerAggregate, IMap<InstanceId, List<InstanceEvent>> eventLog) {
        super(maxLogSizePerAggregate, (ConcurrentMap<InstanceId, List<InstanceEvent>>)eventLog);
        eventLog.addEntryListener((MapListener)new EntryAdapter<InstanceId, List<InstanceEvent>>(){

            public void entryUpdated(EntryEvent<InstanceId, List<InstanceEvent>> event) {
                log.debug("Updated {}", event);
                long lastKnownVersion = ConcurrentMapEventStore.getLastVersion((List)event.getOldValue());
                List<InstanceEvent> newEvents = ((List)event.getValue()).stream().filter(e -> e.getVersion() > lastKnownVersion).collect(Collectors.toList());
                HazelcastEventStore.this.publish(newEvents);
            }
        }, true);
    }
}

