/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher.impl.log;

import io.camunda.zeebe.dispatcher.Loggers;
import io.camunda.zeebe.dispatcher.impl.log.LogBufferDescriptor;
import io.camunda.zeebe.dispatcher.impl.log.LogBufferPartition;
import io.camunda.zeebe.dispatcher.impl.log.PartitionBuilder;
import io.camunda.zeebe.util.allocation.AllocatedBuffer;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class LogBuffer {
    public static final Logger LOG = Loggers.DISPATCHER_LOGGER;
    protected final AllocatedBuffer rawBuffer;
    protected final LogBufferPartition[] partitions;
    protected final UnsafeBuffer metadataBuffer;
    protected final int partitionSize;

    public LogBuffer(AllocatedBuffer allocatedBuffer, int partitionSize) {
        this.partitionSize = partitionSize;
        this.rawBuffer = allocatedBuffer;
        this.partitions = new PartitionBuilder().slicePartitions(partitionSize, this.rawBuffer);
        this.metadataBuffer = new UnsafeBuffer(this.rawBuffer.getRawBuffer(), LogBufferDescriptor.logMetadataOffset(partitionSize), LogBufferDescriptor.LOG_META_DATA_LENGTH);
        this.metadataBuffer.putIntVolatile(LogBufferDescriptor.LOG_ACTIVE_PARTITION_ID_OFFSET, 0);
    }

    public LogBufferPartition getPartition(int id) {
        return this.partitions[id % this.getPartitionCount()];
    }

    public int getActivePartitionIdVolatile() {
        return this.metadataBuffer.getIntVolatile(LogBufferDescriptor.LOG_ACTIVE_PARTITION_ID_OFFSET);
    }

    public int getPartitionCount() {
        return this.partitions.length;
    }

    public int getDataFrameMaxLength() {
        return this.metadataBuffer.getInt(LogBufferDescriptor.LOG_MAX_FRAME_LENGTH_OFFSET);
    }

    public void onActivePartitionFilled(int activePartitionId) {
        int nextPartitionId = 1 + activePartitionId;
        int nextNextPartitionId = 1 + nextPartitionId;
        LogBufferPartition nextNextPartition = this.partitions[nextNextPartitionId % this.getPartitionCount()];
        nextNextPartition.setStatusOrdered(1);
        this.metadataBuffer.putIntOrdered(LogBufferDescriptor.LOG_ACTIVE_PARTITION_ID_OFFSET, nextPartitionId);
        LOG.trace("Partition {} is filled, mark partition {} as active", (Object)(activePartitionId % this.getPartitionCount()), (Object)(nextPartitionId % this.getPartitionCount()));
    }

    public void cleanPartitions() {
        for (int i = 0; i < 3; ++i) {
            LogBufferPartition partition = this.partitions[i];
            if (partition.getStatusVolatile() != 1) continue;
            LOG.trace("Clean partition {}", (Object)i);
            partition.clean();
        }
    }

    public void close() {
        this.rawBuffer.close();
    }

    public boolean isClosed() {
        return this.rawBuffer.isClosed();
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public ByteBuffer createRawBufferView() {
        return this.rawBuffer.getRawBuffer().duplicate();
    }
}

