/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.container.CallActivityProcessor;
import io.camunda.zeebe.engine.processing.bpmn.container.EventSubProcessProcessor;
import io.camunda.zeebe.engine.processing.bpmn.container.MultiInstanceBodyProcessor;
import io.camunda.zeebe.engine.processing.bpmn.container.ProcessProcessor;
import io.camunda.zeebe.engine.processing.bpmn.container.SubProcessProcessor;
import io.camunda.zeebe.engine.processing.bpmn.event.BoundaryEventProcessor;
import io.camunda.zeebe.engine.processing.bpmn.event.EndEventProcessor;
import io.camunda.zeebe.engine.processing.bpmn.event.IntermediateCatchEventProcessor;
import io.camunda.zeebe.engine.processing.bpmn.event.StartEventProcessor;
import io.camunda.zeebe.engine.processing.bpmn.gateway.EventBasedGatewayProcessor;
import io.camunda.zeebe.engine.processing.bpmn.gateway.ExclusiveGatewayProcessor;
import io.camunda.zeebe.engine.processing.bpmn.gateway.ParallelGatewayProcessor;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskProcessor;
import io.camunda.zeebe.engine.processing.bpmn.task.ReceiveTaskProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.EnumMap;
import java.util.Map;

public final class BpmnElementProcessors {
    private final Map<BpmnElementType, BpmnElementProcessor<?>> processors = new EnumMap(BpmnElementType.class);

    public BpmnElementProcessors(BpmnBehaviors bpmnBehaviors) {
        this.processors.put(BpmnElementType.SERVICE_TASK, new JobWorkerTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.BUSINESS_RULE_TASK, new JobWorkerTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.SCRIPT_TASK, new JobWorkerTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.SEND_TASK, new JobWorkerTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.USER_TASK, new JobWorkerTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.RECEIVE_TASK, new ReceiveTaskProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.EXCLUSIVE_GATEWAY, new ExclusiveGatewayProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.PARALLEL_GATEWAY, new ParallelGatewayProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.EVENT_BASED_GATEWAY, new EventBasedGatewayProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.PROCESS, new ProcessProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.SUB_PROCESS, new SubProcessProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.EVENT_SUB_PROCESS, new EventSubProcessProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.MULTI_INSTANCE_BODY, new MultiInstanceBodyProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.CALL_ACTIVITY, new CallActivityProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.START_EVENT, new StartEventProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.INTERMEDIATE_CATCH_EVENT, new IntermediateCatchEventProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.END_EVENT, new EndEventProcessor(bpmnBehaviors));
        this.processors.put(BpmnElementType.BOUNDARY_EVENT, new BoundaryEventProcessor(bpmnBehaviors));
    }

    public <T extends ExecutableFlowElement> BpmnElementProcessor<T> getProcessor(BpmnElementType bpmnElementType) {
        BpmnElementProcessor<?> processor = this.processors.get(bpmnElementType);
        if (processor == null) {
            throw new UnsupportedOperationException(String.format("Expected to find a BPMN element processor for the BPMN element type '%s' but not found.", bpmnElementType));
        }
        return processor;
    }

    public <T extends ExecutableFlowElement> BpmnElementContainerProcessor<T> getContainerProcessor(BpmnElementType bpmnElementType) {
        BpmnElementProcessor<?> processor = this.processors.get(bpmnElementType);
        if (processor instanceof BpmnElementContainerProcessor) {
            return (BpmnElementContainerProcessor)processor;
        }
        throw new UnsupportedOperationException(String.format("Expected to find a BPMN container processor for the BPMN element type '%s' but not found.", bpmnElementType));
    }
}

