/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessors;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.TypedResponseWriterProxy;
import io.camunda.zeebe.engine.processing.bpmn.behavior.TypedStreamWriterProxy;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BpmnStreamProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private static final Logger LOGGER = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final TypedStreamWriterProxy streamWriterProxy = new TypedStreamWriterProxy();
    private final TypedResponseWriterProxy responseWriterProxy = new TypedResponseWriterProxy();
    private final SideEffectQueue sideEffectQueue = new SideEffectQueue();
    private final BpmnElementContextImpl context = new BpmnElementContextImpl();
    private final ProcessState processState;
    private final BpmnElementProcessors processors;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final MutableElementInstanceState elementInstanceState;
    private final TypedRejectionWriter rejectionWriter;
    private boolean reprocessingMode = true;
    private final BpmnIncidentBehavior incidentBehavior;

    public BpmnStreamProcessor(ExpressionProcessor expressionProcessor, CatchEventBehavior catchEventBehavior, VariableBehavior variableBehavior, EventTriggerBehavior eventTriggerBehavior, MutableZeebeState zeebeState, Writers writers) {
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        BpmnBehaviorsImpl bpmnBehaviors = new BpmnBehaviorsImpl(expressionProcessor, this.streamWriterProxy, this.responseWriterProxy, this.sideEffectQueue, zeebeState, catchEventBehavior, variableBehavior, eventTriggerBehavior, this::getContainerProcessor, writers);
        this.rejectionWriter = writers.rejection();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.processors = new BpmnElementProcessors(bpmnBehaviors);
        this.stateTransitionGuard = bpmnBehaviors.stateTransitionGuard();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
    }

    private BpmnElementContainerProcessor<ExecutableFlowElement> getContainerProcessor(BpmnElementType elementType) {
        return this.processors.getContainerProcessor(elementType);
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext context) {
        this.reprocessingMode = false;
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.streamWriterProxy.wrap(streamWriter);
        this.responseWriterProxy.wrap(responseWriter, writer -> this.sideEffectQueue.add(writer::flush));
        this.sideEffectQueue.clear();
        sideEffect.accept(this.sideEffectQueue);
        ProcessInstanceIntent intent = (ProcessInstanceIntent)record.getIntent();
        ProcessInstanceRecord recordValue = record.getValue();
        this.context.init(record.getKey(), recordValue, intent);
        this.context.setReprocessingMode(this.reprocessingMode);
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        BpmnElementProcessor<ExecutableFlowElement> processor = this.processors.getProcessor(bpmnElementType);
        ExecutableFlowElement element = this.getElement(recordValue, processor);
        if (!MigratedStreamProcessors.isMigrated(this.context.getBpmnElementType())) {
            this.relieveReprocessingStateProblems();
        }
        this.stateTransitionGuard.isValidStateTransition(this.context).ifRightOrLeft(ok -> {
            LOGGER.trace("Process process instance event [context: {}]", (Object)this.context);
            this.processEvent(intent, processor, element);
        }, violation -> this.rejectionWriter.appendRejection(record, RejectionType.INVALID_STATE, violation.getMessage()));
    }

    private void relieveReprocessingStateProblems() {
        ElementInstance instance = this.elementInstanceState.getInstance(this.context.getElementInstanceKey());
        if (instance == null) {
            if (this.context.getIntent() != ProcessInstanceIntent.ELEMENT_ACTIVATING) {
                return;
            }
            ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(this.context.getFlowScopeKey());
            ElementInstance elementInstance = this.elementInstanceState.newInstance(flowScopeInstance, this.context.getElementInstanceKey(), this.context.getRecordValue(), ProcessInstanceIntent.ELEMENT_ACTIVATING);
            ElementInstance parentElementInstance = this.elementInstanceState.getInstance(this.context.getRecordValue().getParentElementInstanceKey());
            if (parentElementInstance == null || this.context.getBpmnElementType() != BpmnElementType.PROCESS) {
                return;
            }
            parentElementInstance.setCalledChildInstanceKey(elementInstance.getKey());
            this.elementInstanceState.updateInstance(parentElementInstance);
            return;
        }
        if (this.context.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING && this.context.getBpmnElementType() == BpmnElementType.PROCESS) {
            instance.setState(ProcessInstanceIntent.ELEMENT_TERMINATING);
            this.elementInstanceState.updateInstance(instance);
        }
    }

    private void processEvent(ProcessInstanceIntent intent, BpmnElementProcessor<ExecutableFlowElement> processor, ExecutableFlowElement element) {
        switch (intent) {
            case ACTIVATE_ELEMENT: {
                BpmnElementContext activatingContext = this.stateTransitionBehavior.transitionToActivating(this.context);
                this.stateTransitionBehavior.onElementActivating(element, activatingContext).ifRightOrLeft(ok -> processor.onActivate(element, activatingContext), failure -> this.incidentBehavior.createIncident((Failure)failure, activatingContext));
                break;
            }
            case COMPLETE_ELEMENT: {
                BpmnElementContext completingContext = this.stateTransitionBehavior.transitionToCompleting(this.context);
                processor.onComplete(element, completingContext);
                break;
            }
            case TERMINATE_ELEMENT: {
                BpmnElementContext terminatingContext = this.stateTransitionBehavior.transitionToTerminating(this.context);
                processor.onTerminate(element, terminatingContext);
                break;
            }
            default: {
                throw new BpmnProcessingException(this.context, String.format("Expected the processor '%s' to handle the event but the intent '%s' is not supported", processor.getClass(), intent));
            }
        }
    }

    private ExecutableFlowElement getElement(ProcessInstanceRecord recordValue, BpmnElementProcessor<ExecutableFlowElement> processor) {
        return this.processState.getFlowElement(recordValue.getProcessDefinitionKey(), recordValue.getElementIdBuffer(), processor.getType());
    }
}

