/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BpmnEventPublicationBehavior {
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final ElementInstanceState elementInstanceState;
    private final EventHandle eventHandle;
    private final CatchEventAnalyzer catchEventAnalyzer;

    public BpmnEventPublicationBehavior(MutableZeebeState zeebeState, EventTriggerBehavior eventTriggerBehavior, Writers writers) {
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.eventHandle = new EventHandle(zeebeState.getKeyGenerator(), zeebeState.getEventScopeInstanceState(), writers, zeebeState.getProcessState(), eventTriggerBehavior);
        this.catchEventAnalyzer = new CatchEventAnalyzer(zeebeState.getProcessState(), this.elementInstanceState);
    }

    public void throwErrorEvent(CatchEventAnalyzer.CatchEventTuple catchEventTuple) {
        ElementInstance eventScopeInstance = catchEventTuple.getElementInstance();
        ExecutableCatchEvent catchEvent = catchEventTuple.getCatchEvent();
        if (this.eventHandle.canTriggerElement(eventScopeInstance)) {
            this.eventHandle.activateElement(catchEvent, eventScopeInstance.getKey(), eventScopeInstance.getValue());
        }
    }

    public Either<Failure, CatchEventAnalyzer.CatchEventTuple> findErrorCatchEvent(DirectBuffer errorCode, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(context.getFlowScopeKey());
        CatchEventAnalyzer.CatchEventTuple catchEvent = this.catchEventAnalyzer.findCatchEvent(errorCode, flowScopeInstance);
        if (catchEvent != null) {
            return Either.right((Object)catchEvent);
        }
        String errorMessage = String.format("Expected to throw an error event with the code '%s', but it was not caught.", BufferUtil.bufferAsString((DirectBuffer)errorCode));
        Failure failure = new Failure(errorMessage, ErrorType.UNHANDLED_ERROR_EVENT);
        return Either.left((Object)failure);
    }
}

