/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

public final class BpmnJobBehavior {
    private final JobRecord jobRecord = new JobRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;
    private final JobState jobState;

    public BpmnJobBehavior(KeyGenerator keyGenerator, JobState jobState, Writers writers) {
        this.keyGenerator = keyGenerator;
        this.jobState = jobState;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
    }

    public void createNewJob(BpmnElementContext context, ExecutableJobWorkerTask serviceTask, String jobType, int retries) {
        this.jobRecord.setType(jobType).setRetries(retries).setCustomHeaders(serviceTask.getEncodedHeaders()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(serviceTask.getId()).setElementInstanceKey(context.getElementInstanceKey());
        long jobKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CREATED, (RecordValue)this.jobRecord);
    }

    public void cancelJob(long jobKey) {
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATABLE || state == JobState.State.ACTIVATED || state == JobState.State.FAILED) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.commandWriter.appendFollowUpCommand(jobKey, (Intent)JobIntent.CANCEL, (RecordValue)job);
        }
    }
}

