/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.collection.Tuple;
import org.agrona.DirectBuffer;

public final class EndEventProcessor
implements BpmnElementProcessor<ExecutableEndEvent> {
    private static final String TRANSITION_TO_COMPLETED_PRECONDITION_ERROR = "Expected to transition element to completed, but state is not ELEMENT_ACTIVATING";
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;

    public EndEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
    }

    @Override
    public Class<ExecutableEndEvent> getType() {
        return ExecutableEndEvent.class;
    }

    @Override
    public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
        if (!element.hasError()) {
            this.transitionUntilCompleted(element, activating).ifLeft(this.incidentBehavior::createIncident);
            return;
        }
        ExecutableError error = element.getError();
        EnsureUtil.ensureNotNull((String)"error", (Object)error);
        DirectBuffer errorCode = error.getErrorCode();
        EnsureUtil.ensureNotNullOrEmpty((String)"errorCode", (DirectBuffer)errorCode);
        this.eventPublicationBehavior.findErrorCatchEvent(errorCode, activating).ifRightOrLeft(catchEvent -> {
            this.stateTransitionBehavior.transitionToActivated(activating);
            this.eventPublicationBehavior.throwErrorEvent((CatchEventAnalyzer.CatchEventTuple)catchEvent);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, activating));
    }

    @Override
    public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        this.incidentBehavior.resolveIncidents(terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private Either<Tuple<Failure, BpmnElementContext>, BpmnElementContext> transitionUntilCompleted(ExecutableEndEvent element, BpmnElementContext activating) {
        if (activating.getIntent() != ProcessInstanceIntent.ELEMENT_ACTIVATING) {
            throw new BpmnProcessingException(activating, TRANSITION_TO_COMPLETED_PRECONDITION_ERROR);
        }
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating);
        BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
        return this.stateTransitionBehavior.transitionToCompleted(element, completing).mapLeft(failure -> new Tuple(failure, (Object)completing));
    }
}

